/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.util.openoffice;

import java.util.Vector;

/**
* Une ligne de tableau, compose de N cellules
**/
public class OooLigne
{
	Vector<OooCellule> ligne;
	private String style;
	/**
	 * Construit une ligne de tableau vide.
	 */
	public OooLigne(OooStyleLigne leStyle)
	{
		ligne=new Vector<OooCellule>();
		style=leStyle.getNomStyle();
	}
	
	/**
	 * Construit une ligne de tableau avec un cellule dedans
	 * @param cellule la cellule
	 */
	public OooLigne(OooCellule cellule, OooStyleLigne leStyle)
	{
		ligne=new Vector<OooCellule>();
		ligne.addElement(cellule);
		style=leStyle.getNomStyle();

	}
	
	/**
	 * ajoute une cellule  la ligne
	 * @param cellule la cellule  ajouter
	 */
	public void ajouterCellule(OooCellule cellule)
	{
		ligne.addElement(cellule);
	}
	
	
	/**
	 * Pour connaitre le nombre de cellules dans la ligne
	 * @return le nombre de cellules
	 */
	public int getNbCellules()
	{
		return ligne.size();
	}
	
	/**
	 * Cre la chaine de caractre  crire formate en openoffice.
	 * @return la chaine de caractre formate en openoffice.
	 */
	public String toStringOoo()
	{
		String result="";
		
		result+="<table:table-row table:style-name=\""+style+"\">";
		
		for (int p=0; p<ligne.size();p++)
					{
						result += ligne.elementAt(p).toStringOoo();
					}
		result+="</table:table-row>";
					
		return result;
					
	}
}
