/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.util.listing;


import java.util.ArrayList;


public abstract class ListingFile {


	private ArrayList<ArrayList<String>> lines = new ArrayList<ArrayList<String>>();
	private ArrayList<String> currentLine;
	private int maxCol = 0;

	private ArrayList<String> searchLine;
	private int numSearchLine = 0;
	private int numSearchCell = 0;
	private String searchCellValue;


	public final void newLine() {

		currentLine = new ArrayList<String>();
		lines.add(currentLine);
	}


	public final void addToLine(String str) {
		try {

			currentLine.add(str);

			if (currentLine.size()>maxCol)
				maxCol = currentLine.size();
		}
		catch (NullPointerException npe) {
			System.out.println("\nListingFile: current line is not initialized !\n");
		}
	}


	public int getMaxCol() {
		return maxCol;
	}


	public boolean nextLine() {
		try {
			searchLine = lines.get(numSearchLine);
			numSearchLine++;
			numSearchCell = 0;
			return true;
		}
		catch (IndexOutOfBoundsException e) {
			return false;
		}
	}


	public boolean nextCell() {
		try {
			searchCellValue = searchLine.get(numSearchCell);
			numSearchCell++;
			return true;
		}
		catch (IndexOutOfBoundsException e) {
			return false;
		}
	}


	public String getCellValue() {
		return searchCellValue;
	}

	public int getLineSize() {
		return searchLine.size();
	}


	public abstract void write(String folder, String filename, boolean deleteOnExit);


} // fin ListingFile
