/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Calendar;

import org.experlog.openeas.api.Session;


public class PeriodeN1CA {

	private Session session;
	private long periodeN1;
		
  public PeriodeN1CA(long periodeN, String sessionId) {
		
		Calendar calendar = Calendar.getInstance();
		calendar.clear();
		
		calendar.setTimeInMillis(periodeN);
		
		calendar.set(calendar.get(Calendar.YEAR)-1, calendar.get(Calendar.MONTH), 1,0,0,0);
		
		this.periodeN1 = calendar.getTimeInMillis();
		
		session = Session.findClient(sessionId);
	
	}
	
	/** renvoi le nom de la base contenant la periode N-1  */
	
	public String getBase() {
	
		String base = null;
	
		try {
			Connection con = session.getConnection(null);
			Statement stt = con.createStatement();
		
			String req = "select Debut_Exercice, Nom_Base from "+ session.getCookie().get("BaseDossier") +".EXERCICE order by Num_Exercice desc";
		
			ResultSet rset = stt.executeQuery(req);			

			while (rset.next() && base==null) {
				base = (rset.getLong("Debut_Exercice")<=periodeN1)?rset.getString("Nom_Base"):null;
			}
			rset.close();			
			
			stt.close();
			session.closeConnection(con, null);
		}
		catch(Exception e) {e.printStackTrace();}
			
		return base==null?"":base;
	
	}
		
	
	/** renvoi la periode N-1 correspondante  la priode N */
	
	public long getPeriodeN1() {
	
		return periodeN1;
	
	}
	
  
} // fin PeriodeN1CA
