/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration des expditions
 */

package org.opensi.facturation.expedition;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Calendar;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;


public class Expeditions extends Action {


	public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {

  	String fichier = r.getParameter("Fichier");
		String absdir = s.getAppConfiguration().get("opensi.absdir");

		String periode = r.getParameter("Periode");
		String expediteur = r.getParameter("Expediteur");
		String[] heure = r.getParameter("Heure").split(":");
		boolean colis = r.getParameter("Colis").equals("true");
		String provenance = r.getParameter("Provenance");
		String dateDebut = r.getParameter("Date_Debut");
		String[] heureDebut = r.getParameter("Heure_Debut").split(":");
		String dateFin = r.getParameter("Date_Fin");
		String[] heureFin = r.getParameter("Heure_Fin").split(":");
		String format = r.getParameter("Format");

		long debutPeriode = 0;
		long finPeriode = 0;
		
		Calendar calendar = Calendar.getInstance();
		calendar.clear();

		if (periode.equals("dd")) {
			calendar.set(Integer.parseInt(dateDebut.substring(6,10)), Integer.parseInt(dateDebut.substring(3,5))-1, Integer.parseInt(dateDebut.substring(0,2)),0,0,0);
			calendar.set(Calendar.HOUR_OF_DAY,Integer.parseInt(heureDebut[0]));
			calendar.set(Calendar.MINUTE,Integer.parseInt(heureDebut[1]));
			debutPeriode = calendar.getTimeInMillis();
			calendar.set(Integer.parseInt(dateFin.substring(6,10)), Integer.parseInt(dateFin.substring(3,5))-1, Integer.parseInt(dateFin.substring(0,2)),0,0,0);
			calendar.set(Calendar.HOUR_OF_DAY,Integer.parseInt(heureFin[0]));
			calendar.set(Calendar.MINUTE,Integer.parseInt(heureFin[1]));
			finPeriode = calendar.getTimeInMillis();
		}
		else if (periode.equals("A")) {
			calendar = Calendar.getInstance();
			calendar.set(Calendar.HOUR_OF_DAY,Integer.parseInt(heure[0]));
			calendar.set(Calendar.MINUTE,Integer.parseInt(heure[1]));
			debutPeriode = calendar.getTimeInMillis();
		}
		else if (periode.equals("M")) {
			calendar = Calendar.getInstance();
			calendar.set(Calendar.HOUR_OF_DAY,0);
			calendar.set(Calendar.DAY_OF_MONTH,1);
			debutPeriode = calendar.getTimeInMillis();
		}
		
		Connection con = s.getConnection(null);
		Statement stt = con.createStatement();
		String base = s.getCookie().get("BaseDossier");
		String reqNumClient = "select o.Num_Client from "+ base +".EXPORT_COLIS e, "+ base +".ORG_LIVRAISON o";
		reqNumClient += " where e.Export_Id='"+ format +"' and e.Num_Org=o.Organisme_Id";
		String numClient = "";
		ResultSet rsNumOrg = stt.executeQuery(reqNumClient);
		if (rsNumOrg.next()) {
			numClient=rsNumOrg.getString("Num_Client");
		}		
		rsNumOrg.close();

		DataExpedition de = new DataExpedition(s, periode, numClient, debutPeriode, finPeriode, expediteur, colis, provenance);
		String buffer = absdir +"/iobuffer/";
		String nom_sugg = "";
		
		IExpedition expedition;
		
		if (format.equals("COLISSIMO")) {
			// format par dfaut, sous licence GPL
			expedition = new CsvExportColissimo();
		} else if (format.equals("CHRONOPOST")) {
			// format par dfaut, sous licence GPL
			expedition = new CsvExportChronopost();
		}
		else {
			// autres formats			
			ResultSet rsClass = stt.executeQuery("select Class from "+ base +".EXPORT_COLIS where Export_Id='"+ format +"'");
			rsClass.next();
			expedition = (IExpedition)Class.forName(rsClass.getString("Class")).newInstance();
			rsClass.close();			
		}
		stt.close();
		s.closeConnection(con, null);
		
		expedition.makeExpedition(buffer, fichier, de);
		nom_sugg = expedition.getNomFichier();
		
		File f = new File(buffer + fichier);
		String action_error = "";
		if (f.length() == 0) {
			action_error = "Aucun rsultat !";
		}
		
		r.addParameter("ActionError", action_error);
		r.addParameter("NomSugg", nom_sugg);

		return true;


	} // fin service



} // fin Expeditions
