/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *   Import des numros de colis pour La Poste
 */

package org.opensi.facturation.expedition;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import org.experlog.openeas.api.Session;


public class CsvImportLaposte implements IImportation {
	
	private String base;
		
	public String makeImportation(Session s, String nom_fichier) throws Exception {
		
		this.base = s.getCookie().get("BaseDossier");
    	String bons = "";
		
		//Lecture du fichier CSV
		BufferedReader reader = null;
	    String ligne;
	    
	    try {
	    	reader = new BufferedReader(new FileReader(nom_fichier));
	    	Connection con = s.getConnection(null);
	    	
	    	reader.readLine(); // on limine la premire ligne
	    	String[] data;
	    	while ((ligne = reader.readLine()) != null) {
				data = getData(ligne);
		    	if (data != null) {
	    			String bon = this.importer(con, data);
	    			if (!bon.equals("")) {
			    		bons += bon+",";
			    	}
	    		}
	    	}
	    	
	    	s.closeConnection(con, null);
		    reader.close();  
	    } catch(FileNotFoundException exc) {
	    	System.out.println("Erreur d'ouverture du fichier " + nom_fichier);
	    }
	    return bons;

	}
	
	
	private String[] getData(String data) {
		// 1er lment : rf expdition (contient le num BL)
		// 2e lment : num colis de la poste
		String[] tokens = new String[2];
		int nbtoken = 0;
		int length = data.length();
		
		// provoque une erreur si le fichier  importer contient + de 2 points virgules (sparateurs du csv)
		// il convient donc que le fichier  importer soit valide pour l'importer

		String tok = "";
		
		int startpos = 0;
		char currentchar = ' ';
		char lastchar = ' ';
		int i=0;
		for (i=0; i<length; i++) {
			currentchar = data.charAt(i);
			if (currentchar == ';') {
				tok = (currentchar == lastchar) ? "" : data.substring(startpos, i);
		    	tokens[nbtoken] = tok;
		    	nbtoken++;
				startpos = i+1;
			}
			lastchar = currentchar;
		}
		
		return tokens;
	}
	
	
	private String importer(Connection con, String[] data) {
		String bon = "";
		try {
			String ref_expedition = data[0];
			String num_colis = data[1];
			String lien = "http://www.coliposte.net/particulier/suivi_particulier.jsp?colispart="+ num_colis;
			
			Statement stt = con.createStatement();
			
			// aller chercher le Bon_Id
			String reqBL = "select Commande_Id, Bon_Id from "+ base +".BON_LIVRAISON where Numero>0 and Num_Entier='"+ ref_expedition + "'";
			ResultSet rset = stt.executeQuery(reqBL);
			// Il peut ne pas y avoir de rsultat (si le bon de livraison a t cr manuellement)
			if (rset.next()) {
				int bon_id = rset.getInt("Bon_Id");
				int commandeId = rset.getInt("Commande_Id");
				
				// on ne fait le traitement que si le numro de colis n'est pas dj attribu
				String reqVerifExist = "select * from "+ base +".COLIS where Ident_Suivi='"+ num_colis + "' and Bon_Id=" + bon_id;
				PreparedStatement psVerifExist = con.prepareStatement(reqVerifExist);
				ResultSet rset2 = psVerifExist.executeQuery();
				if (!rset2.next()) {
					String reqUpd = "update "+ base +".COLIS";
					reqUpd += " set Ident_Suivi='"+ num_colis + "', Lien='" + lien + "'";
					reqUpd += " where Ident_Suivi='' and Lien='' and Bon_Id=" + bon_id;
					reqUpd += " limit 1";
					
					// si la mise  jour n'a aucun effet, on fera une insertion
					int res = stt.executeUpdate(reqUpd);
					if (res==0) {
						String reqIns = "insert into "+ base +".COLIS (Bon_Id, Ident_Suivi, Lien) values ("+ bon_id +", '"+ num_colis + "', '" + lien + "')";
						stt.executeUpdate(reqIns);
					}
					
					reqUpd = "update "+ base +".BON_LIVRAISON set Statut_Expedition='E' where Statut_Expedition='P' and Bon_Id="+ bon_id;
					stt.executeUpdate(reqUpd);
					
					reqUpd = "update "+ base +".COMMANDE_CLIENT_WEB set Statut_Modifie=1 where Commande_Id="+ commandeId;
					stt.executeUpdate(reqUpd);
					
					bon = ""+bon_id;
				}
				rset2.close();
			}
			rset.close();
			stt.close();
			
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return bon;
	}
} // fin CsvImportLaposte
