/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *   Export des expditions pour La Poste
 */

package org.opensi.facturation.expedition;

import org.opensi.util.listing.ListingFile;
import org.opensi.util.listing.ListingTabFile;
import org.opensi.util.tools.DateTime;


public class CsvExportColissimo implements IExpedition {
		
	public void makeExpedition(String buffer, String fichier, DataExpedition de) throws Exception {
		
		ListingFile lf = new ListingTabFile();
		
		int nbLignes = de.getNbLignes();
		
		for (int i=0; i<nbLignes; i++) {
			LigneExpedition le = de.lignes.get(i);
			
			lf.newLine();
			lf.addToLine("\"" + le.num_entier + "\"");
			lf.addToLine("\"\"");
			lf.addToLine("\"" + le.nom_liv + "\"");
			lf.addToLine("\"" + le.adresse_liv + "\"");
			lf.addToLine("\"" + le.comp_adresse_liv + "\"");
			lf.addToLine("\"" + le.adresse_3_liv + "\"");
			lf.addToLine("\"" + le.CP_liv + "\"");
			lf.addToLine("\"" + le.ville_liv + "\"");
			lf.addToLine("\"" + le.code_pays_liv + "\"");
			lf.addToLine("\"" + le.tel_inter_liv + "\"");
			lf.addToLine("\"" + le.code_porte_liv + " " + le.infos_liv + "\""); // instructions de livraisons
			lf.addToLine("\"" + le.email_inter_liv + "\"");
			lf.addToLine("\"" + le.ref_commande + "\"");
			lf.addToLine("" + le.poids);
			lf.addToLine("\"" + le.civ_inter_liv + " " + le.nom_inter_liv + "\"");
		}
		
		lf.write(buffer, fichier, true);
	}
	
	public String getNomFichier() {
		return DateTime.formatTime(System.currentTimeMillis(), "dd-MM-yyyy_HH-mm-ss")+".txt";
	}
	
} // fin CsvExportColissimo
