/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation.actions.transcompta;

import java.sql.*;

import org.opensi.api.SessionOSI;

import java.util.HashMap;
import java.util.Iterator;


public abstract class TransfertAchats extends TransfertCompta {


	protected String compteLivraison;
	protected String compteEscompteAC;
	protected String compteTvaDueIC;
	protected String compteTvaDedIC;
	protected boolean intituleTiers;
	protected double tauxNormalFR;


	protected String compteAchatDefaultUE;
	protected String compteAchatDefaultI;

	private String compteFournisseursDivers;

	private PreparedStatement psCpteFournisseur;
	private PreparedStatement psCpteArticleUE;
	private PreparedStatement psCpteFamilleUE;
	private PreparedStatement psCpteArticleI;
	private PreparedStatement psCpteFamilleI;
	private PreparedStatement psCpteArticleN;
	private PreparedStatement psCpteFamilleN;

	private HashMap<Integer, String> cptesATva = new HashMap<Integer, String>(3);

	protected HashMap<Integer, String> cptesTva = new HashMap<Integer, String>(3);


  public TransfertAchats(SessionOSI sosi) throws Exception {

		super(sosi);

		Statement stt = con.createStatement();

		ResultSet rset = stt.executeQuery("select Numero_Compte_Achat_UE, Numero_Compte_Achat_I, Numero_Compte_Fournisseurs, Numero_Compte_Escompte_AC, Numero_Compte_Port_AC, Intitule_Ecr_Tiers, Numero_Compte_Tva_Due_IC, Numero_Compte_Tva_Ded_IC from "+ baseDossier +".PARAM_DOSSIER");
		rset.next();

		compteAchatDefaultUE = rset.getString("Numero_Compte_Achat_UE");
		compteAchatDefaultI = rset.getString("Numero_Compte_Achat_I");
		this.compteFournisseursDivers = rset.getString("Numero_Compte_Fournisseurs");
		this.compteLivraison = rset.getString("Numero_Compte_Port_AC");
		this.compteEscompteAC = rset.getString("Numero_Compte_Escompte_AC");
		this.compteTvaDueIC = rset.getString("Numero_Compte_Tva_Due_IC");
		this.compteTvaDedIC = rset.getString("Numero_Compte_Tva_Ded_IC");
		this.intituleTiers = rset.getInt("Intitule_Ecr_Tiers")==1;

		rset = stt.executeQuery("select Taux_TVA from "+ baseDossier +".TAUX_TVA where Code_Pays='FR' and Normal=1");
		rset.next();

		this.tauxNormalFR = rset.getDouble("Taux_TVA");

		stt.close();


		String reqCpteFournisseur = "select c.Numero_Compte from "+ baseDossier +".FICHE_FOURNISSEUR e,"+ baseDossier +".COMPTE c "
		+ "where e.Fournisseur_Id=? and e.Numero_Compte=c.Numero_Compte";

		String reqCpteArticleUE = "select f.Compte_Achat_UE from "+ baseDossier +".FICHE_ARTICLE f,"+ baseDossier +".COMPTE c "
		+ "where f.Article_Id=? and f.Compte_Achat_UE=c.Numero_Compte";

		String reqCpteArticleI = "select f.Compte_Achat_I from "+ baseDossier +".FICHE_ARTICLE f,"+ baseDossier +".COMPTE c "
		+ "where f.Article_Id=? and f.Compte_Achat_I=c.Numero_Compte";

		String reqCpteArticleN = "select ca.Compte_Achat from "+ baseDossier +".COMPTE_ARTICLE ca,"+ baseDossier +".TAUX_TVA t,"+ baseDossier +".COMPTE c "
		+ "where t.Code_TVA=ca.Code_TVA and c.Numero_Compte=ca.Compte_Achat and Article_Id=? and t.Code_TVA=?";

		String reqCpteFamilleUE = "select f.Compte_Achat_UE from "+ baseDossier +".FAMILLE_ARTICLE f,"+ baseDossier +".COMPTE c,"+ baseDossier +".FICHE_ARTICLE a "
		+ "where a.Article_Id=? and f.Famille_Id=a.Famille_? and f.Compte_Achat_UE=c.Numero_Compte";

		String reqCpteFamilleI = "select f.Compte_Achat_I from "+ baseDossier +".FAMILLE_ARTICLE f,"+ baseDossier +".COMPTE c,"+ baseDossier +".FICHE_ARTICLE a "
		+ "where a.Article_Id=? and f.Famille_Id=a.Famille_? and f.Compte_Achat_I=c.Numero_Compte";

		String reqCpteFamilleN = "select cf.Compte_Achat from "+ baseDossier +".COMPTE_FAMILLE_ARTICLE cf,"+ baseDossier +".TAUX_TVA t,"+ baseDossier +".COMPTE c,"+ baseDossier +".FICHE_ARTICLE a "
		+ "where t.Code_TVA=cf.Code_TVA and c.Numero_Compte=cf.Compte_Achat and a.Famille_?=cf.Famille_Id and a.Article_Id=? and t.Code_TVA=?";



		psCpteFournisseur = con.prepareStatement(reqCpteFournisseur);
		psCpteArticleUE = con.prepareStatement(reqCpteArticleUE);
		psCpteArticleI = con.prepareStatement(reqCpteArticleI);
		psCpteArticleN = con.prepareStatement(reqCpteArticleN);
		psCpteFamilleUE = con.prepareStatement(reqCpteFamilleUE);
		psCpteFamilleI = con.prepareStatement(reqCpteFamilleI);
		psCpteFamilleN = con.prepareStatement(reqCpteFamilleN);


		PreparedStatement psCptesTva = con.prepareStatement("select Compte_TVA_Achat, Compte_Achat, Code_TVA from "+ baseDossier +".TAUX_TVA where Code_Pays='FR'");

		rset = psCptesTva.executeQuery();

		while (rset.next()) {
			cptesTva.put(new Integer(rset.getInt("Code_TVA")), rset.getString("Compte_TVA_Achat"));
			cptesATva.put(new Integer(rset.getInt("Code_TVA")), rset.getString("Compte_Achat"));
		}

		rset.close();
		psCptesTva.close();
	}


	public abstract void transfert() throws Exception;

	protected abstract void marquerDocument(int documentId) throws SQLException;


	protected final void ajusterHT(double montant, char sens, HashMap<String, Double> vachats) throws SQLException {

		Iterator<String> li = vachats.keySet().iterator();

		while (li.hasNext() && montant>0) {

			String compteHT = li.next();

			double montantHT = vachats.get(compteHT).doubleValue();

			if (sens=='P') {
				montantHT += montant;
				montant = 0;
			}
			else {
				montantHT = (montantHT>montant?montantHT - montant:0);
				montant -= montantHT;
			}

			if (montantHT>0)
				vachats.put(compteHT, new Double(montantHT));
			else
				vachats.put(compteHT, new Double(0));
		}
	}


	protected final String getCompteFournisseur(String fournisseurId) throws SQLException {

		if (fournisseurId.equals("")) {
			return compteFournisseursDivers;
		}
		else {
			psCpteFournisseur.setString(1, fournisseurId);
			ResultSet rset = psCpteFournisseur.executeQuery();

			if (rset.next()) {
				return rset.getString("Numero_Compte");
			}
			else {
				return compteFournisseursDivers;
			}
		}
	}


	private final String getCompteFamilleI(String reference, int niveauFamille) throws SQLException {

		psCpteFamilleI.setString(1, reference);
		psCpteFamilleI.setInt(2, niveauFamille);
		ResultSet rset = psCpteFamilleI.executeQuery();

		if (rset.next()) {
			return rset.getString("Compte_Achat_I");
		}
		else if (niveauFamille>1) {
			return getCompteFamilleI(reference, niveauFamille-1);
		}
		else {
			return compteAchatDefaultI;
		}
	}


	private final String getCompteFamilleUE(String reference, int niveauFamille) throws SQLException {

		psCpteFamilleUE.setString(1, reference);
		psCpteFamilleUE.setInt(2, niveauFamille);
		ResultSet rset = psCpteFamilleUE.executeQuery();

		if (rset.next()) {
			return rset.getString("Compte_Achat_UE");
		}
		else if (niveauFamille>1) {
			return getCompteFamilleUE(reference, niveauFamille-1);
		}
		else {
			return compteAchatDefaultUE;
		}
	}


	private final String getCompteFamilleN(String reference, int codeTVA, int niveauFamille) throws SQLException {

		psCpteFamilleN.setInt(1, niveauFamille);
		psCpteFamilleN.setString(2, reference);
		psCpteFamilleN.setDouble(3, codeTVA);
		ResultSet rset = psCpteFamilleN.executeQuery();

		if (rset.next()) {
			return rset.getString("Compte_Achat");
		}
		else if (niveauFamille>1) {
			return getCompteFamilleN(reference, codeTVA, niveauFamille-1);
		}
		else {
			return cptesATva.get(codeTVA);
		}
	}


	private final String getCompteArticleI(String reference) throws SQLException {

		psCpteArticleI.setString(1, reference);
		ResultSet rset = psCpteArticleI.executeQuery();

		if (rset.next()) {
			return rset.getString("Compte_Achat_I");
		}
		else {
			return getCompteFamilleI(reference, 3);
		}
	}


	private final String getCompteArticleUE(String reference) throws SQLException {

		psCpteArticleUE.setString(1, reference);
		ResultSet rset = psCpteArticleUE.executeQuery();

		if (rset.next()) {
			return rset.getString("Compte_Achat_UE");
		}
		else {
			return getCompteFamilleUE(reference, 3);
		}
	}


	private final String getCompteArticleN(String reference, int codeTVA) throws SQLException {

		psCpteArticleN.setString(1, reference);
		psCpteArticleN.setInt(2, codeTVA);
		ResultSet rset = psCpteArticleN.executeQuery();

		if (rset.next()) {
			return rset.getString("Compte_Achat");
		}
		else {
			return getCompteFamilleN(reference, codeTVA, 3);
		}
	}


	protected final String getCompteHT(String reference, String typeAchat, int codeTVA) throws SQLException {

		if (typeAchat.equalsIgnoreCase("I")) {
			return getCompteArticleI(reference);
		}
		else if (typeAchat.equalsIgnoreCase("U")) {
			return getCompteArticleUE(reference);
		}
		else {
			return getCompteArticleN(reference, codeTVA);
		}
	}


	protected final String getCompteDefault(String typeAchat, int codeTVA) {

		if (typeAchat.equalsIgnoreCase("I")) {
			return compteAchatDefaultI;
		}
		else if (typeAchat.equalsIgnoreCase("U")) {
			return compteAchatDefaultUE;
		}
		else {
			return cptesATva.get(codeTVA);
		}
	}


} // fin TransfertAchats

