/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Informations permettant la constitution d'une tiquette de colisage
 */

package org.opensi.facturation.actions.editions.etiquettes;



public class InfosEtiquette {

	
	protected int numColis = 0;
	protected int nbColis;
	protected String numAffaire;
	protected String numCommande;
	protected String numBL;
	protected String codeClient;
	protected String client;
	protected String refCom;
	
	
	private CoordExp dest;
	private CoordExp exp;
	
	

	public InfosEtiquette(int nbColis, String numAffaire, String numBL, String refCom, String numCommande, String codeClient, String client, CoordExp dest, CoordExp exp) {
	
		this.nbColis = nbColis;
		this.numAffaire = numAffaire;
		this.numBL = numBL;
		this.refCom = refCom;
		this.numCommande = numCommande;
		this.client = client;
		this.codeClient = codeClient;
		this.dest = dest;
		this.exp = exp;	
	}
	
	public CoordExp getExpediteur() { return exp; }
	
	public CoordExp getDestinataire() { return dest; }
	
	public int getNumColis() { return numColis; }
	public int getNbColis() { return nbColis; }
	public String getNumAffaire() { return numAffaire; }
	public String getNumCommande() { return numCommande; }
	public String getNumBL() { return numBL; }
	public String getCodeClient() { return codeClient; }
	public String getClient() { return client; }
	public String getRefCom() { return refCom; }
	
	public void setNumColis(int numColis) {
		
		this.numColis = numColis;
	}


} // fin InfosEtiquette
