/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'un tat des stocks
 */

package org.opensi.facturation.actions.editions;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;
import org.opensi.util.tools.DateTime;


public class DataEtatStock {

	
	// les lignes de l'tat des stocks
	protected ArrayList<LigneEtatStock> lignes = new ArrayList<LigneEtatStock>(100);

	protected String dossierId;
	protected String raisonSociale;
	protected String adresse1;
	protected String adresse2;
	protected String adresse3;
	protected String codePostal;
	protected String ville;
	protected String monnaie;

	protected String finPeriodeStr;
	protected String debutPeriodeStr;
	protected String dateCourante;
	protected String dateArrete;
	protected int famille1;
	protected int famille2;
	protected int famille3;
	protected int marque;
	
	protected double valorisationTotale = 0;
	protected double reelTotal = 0;
	
	protected String criteres = "";
	protected boolean stockEntier;
	protected boolean existeDateArrete;


	public DataEtatStock(Session s, String valorisation, long debutPeriode, long finPeriode, int famille1, int famille2, int famille3, int marque, boolean stockEntier, long dateArrete) {
		try {
			
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			
			String base = s.getCookie().get("BaseDossier");
			this.dossierId = s.getCookie().get("Dossier_Id");			
			
			this.finPeriodeStr = DateTime.formatTime(finPeriode, "dd/MM/yyyy");
			this.debutPeriodeStr = DateTime.formatTime(debutPeriode, "dd/MM/yyyy");
			this.dateCourante = DateTime.formatTime(System.currentTimeMillis(), "dd/MM/yyyy");
			this.dateArrete = (dateArrete!=0?DateTime.formatTime(dateArrete, "dd/MM/yyyy"):"");
			this.existeDateArrete = (dateArrete!=0);
			
			this.famille1 = famille1;
			this.famille2 = famille2;
			this.famille3 = famille3;
			this.marque = marque;
			this.stockEntier = stockEntier;
			
			DateTime dtPeriode = new DateTime();
			dtPeriode.setDay(1);
			dtPeriode.setMonth(dtPeriode.getMonth() + 1);			

			String reqLeDossier = "select s.Denomination, s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville, d.Intitule as Devise from "+ base +".SOCIETE s join DEVISE d on s.Monnaie_Tenue=d.Devise_Id";

			ResultSet rset = stt.executeQuery(reqLeDossier);
			if (rset.next()) {
				this.raisonSociale = rset.getString("Denomination");
				this.adresse1 = rset.getString("Adresse_1");
				this.adresse2 = rset.getString("Adresse_2");
				this.adresse3 = rset.getString("Adresse_3");
				this.codePostal = rset.getString("Code_Postal");
				this.ville = rset.getString("Ville");
				this.monnaie = rset.getString("Devise");
			}
			
			String reqMvtStock = "select Entrees - Sorties as Stock_Reel from";
			reqMvtStock += "(select coalesce(sum(Quantite),0) as Entrees from "+ base +".MVT_STOCK where Type_Mvt='E' and Date_Mvt<="+ dateArrete +" and Article_Id=?) as t1,";
			reqMvtStock += "(select coalesce(sum(Quantite),0) as Sorties from "+ base +".MVT_STOCK where Type_Mvt='S' and Date_Mvt<="+ dateArrete +" and Article_Id=?) as t2";
			PreparedStatement psMvtStock = con.prepareStatement(reqMvtStock);
			
			String reqMvtComClient = "select coalesce(sum(Quantite),0) as Reservation from "+ base +".MVT_COM_CLIENT where Article_Id=? and Date_Mvt<="+ dateArrete;
			PreparedStatement psMvtComClient = con.prepareStatement(reqMvtComClient);
			
			String reqStock ="";
			if (valorisation.equals("cump")) {
				reqStock = "select coalesce(ma.Libelle,'') as Marque, a.Article_Id, coalesce(stock.Valorisation, 0) as Valorisation, a.Designation,";
				reqStock += " s.Stock_Init + s.Entrees - s.Sorties as Stock_Reel, s.Com_Clients, s.Com_Fournisseurs";
				reqStock += " from "+ base +".STOCKS_ARTICLE s,"+ base +".FICHE_ARTICLE a left join "+ base +".MARQUE_ARTICLE ma on a.Marque_Id=ma.Marque_Id";
				reqStock += " left join (select san.Article_Id,san.Valorisation from "+ base +".STOCK_ANOUVEAU san join (select Article_Id,max(Periode) as Periode from  "+ base +".STOCK_ANOUVEAU san";
				if (existeDateArrete) {
					reqStock += " where Periode<="+ dateArrete;
				}
				reqStock += " group by Article_Id ) as max";
				reqStock += " on max.Article_Id=san.Article_Id and max.Periode=san.Periode) as stock on stock.Article_Id=a.Fiche_Article_Id";
				reqStock += " where ";
				
				String reqLibelleFamille = "select Libelle from "+ base +".FAMILLE_ARTICLE where Famille_Id=?";
				PreparedStatement psLibelleFamille = con.prepareStatement(reqLibelleFamille);
	
				if (famille1 != 0) {
					reqStock += "a.Famille_1="+ famille1 +" and ";
					psLibelleFamille.setInt(1, famille1);
					rset = psLibelleFamille.executeQuery();
					rset.next();
					criteres += "Famille 1 : "+ rset.getString("Libelle");
					rset.close();
	
					if (famille2 != 0) {
						reqStock += "a.Famille_2="+ famille2 +" and ";
						if (criteres.length()>0) {
							criteres += " - ";
						}
						psLibelleFamille.setInt(1, famille2);
						rset = psLibelleFamille.executeQuery();
						rset.next();
						criteres += "Famille 2 : "+ rset.getString("Libelle");
						rset.close();
						
						if (famille3 != 0) {
							reqStock += "a.Famille_3="+ famille3 +" and ";
							if (criteres.length()>0) {
								criteres += " - ";
							}
							psLibelleFamille.setInt(1, famille3);
							rset = psLibelleFamille.executeQuery();
							rset.next();
							criteres += "Famille 3 : "+ rset.getString("Libelle");
							rset.close();
						}
					}
				}
				psLibelleFamille.close();
				
				String reqLibelleMarque = "select Libelle from "+ base +".MARQUE_ARTICLE where Marque_Id=?";
				PreparedStatement psLibelleMarque = con.prepareStatement(reqLibelleMarque);
	
				if (marque != 0) {
					reqStock += "a.Marque_Id="+ marque +" and ";
					if (criteres.length()>0) {
						criteres += " - ";
					}
					psLibelleMarque.setInt(1, marque);
					rset = psLibelleMarque.executeQuery();
					rset.next();
					criteres += "Marque : "+ rset.getString("Libelle");
					rset.close();
				}
				psLibelleMarque.close();
				
				if (!stockEntier) {
					reqStock += " s.Stock_Init + s.Entrees - s.Sorties>0 and ";
				}
	
				reqStock += "a.Article_Id=s.Article_Id and a.Supprime=0 order by a.Article_Id";
		  
			}
			else if (valorisation.equals("dpa")){
				reqStock ="select coalesce(ma.Libelle,'') as Marque, a.Article_Id, coalesce(a.Prix_Achat_Der, 0) as Valorisation, a.Designation,";
				reqStock += " s.Stock_Init + s.Entrees - s.Sorties as Stock_Reel, s.Com_Clients, s.Com_Fournisseurs from "+ base +".STOCKS_ARTICLE s,";
				reqStock += base +".FICHE_ARTICLE a left join "+ base +".MARQUE_ARTICLE ma on a.Marque_Id=ma.Marque_Id";
				reqStock += " where ";
				
				String reqLibelleFamille = "select Libelle from "+ base +".FAMILLE_ARTICLE where Famille_Id=?";
				PreparedStatement psLibelleFamille = con.prepareStatement(reqLibelleFamille);
	
				if (famille1 != 0) {
					reqStock += "a.Famille_1="+ famille1 +" and ";
					psLibelleFamille.setInt(1, famille1);
					rset = psLibelleFamille.executeQuery();
					rset.next();
					criteres += "Famille 1 : "+ rset.getString("Libelle");
					rset.close();
	
					if (famille2 != 0) {
						reqStock += "a.Famille_2="+ famille2 +" and ";
						if (criteres.length()>0) {
							criteres += " - ";
						}
						psLibelleFamille.setInt(1, famille2);
						rset = psLibelleFamille.executeQuery();
						rset.next();
						criteres += "Famille 2 : "+ rset.getString("Libelle");
						rset.close();
						
						if (famille3 != 0) {
							reqStock += "a.Famille_3="+ famille3 +" and ";
							if (criteres.length()>0) {
								criteres += " - ";
							}
							psLibelleFamille.setInt(1, famille3);
							rset = psLibelleFamille.executeQuery();
							rset.next();
							criteres += "Famille 3 : "+ rset.getString("Libelle");
							rset.close();
						}
					}
				}
				psLibelleFamille.close();
				
				String reqLibelleMarque = "select Libelle from "+ base +".MARQUE_ARTICLE where Marque_Id=?";
				PreparedStatement psLibelleMarque = con.prepareStatement(reqLibelleMarque);
	
				if (marque != 0) {
					reqStock += "a.Marque_Id="+ marque +" and ";
					if (criteres.length()>0) {
						criteres += " - ";
					}
					psLibelleMarque.setInt(1, marque);
					rset = psLibelleMarque.executeQuery();
					rset.next();
					criteres += "Marque : "+ rset.getString("Libelle");
					rset.close();
				}
				psLibelleMarque.close();
				
				if (!stockEntier) {
					reqStock += " s.Stock_Init + s.Entrees - s.Sorties>0 and ";
				}

				reqStock += "a.Article_Id=s.Article_Id and a.Supprime=0 order by a.Article_Id";
			}
			
			rset = stt.executeQuery(reqStock);
			
			while (rset.next()) {
				
				LigneEtatStock les = new LigneEtatStock();

				String articleId = rset.getString("Article_Id");
				les.setNumero(articleId);
				les.setMarque(rset.getString("Marque"));
				les.setDesignation(rset.getString("Designation"));
				
				if (existeDateArrete) {
					psMvtStock.setString(1, articleId);
					psMvtStock.setString(2, articleId);
					
					ResultSet rset2 = psMvtStock.executeQuery();
					rset2.next();
					les.setReel(rset2.getDouble("Stock_Reel"));
					rset2.close();
					
					psMvtComClient.setString(1, articleId);
					rset2 = psMvtComClient.executeQuery();
					rset2.next();
					les.setDispo(les.reel - rset2.getDouble("Reservation"));
					rset2.close();
				} else {
					les.setReel(rset.getDouble("Stock_Reel"));
					les.setComClient(rset.getDouble("Com_Clients"));
					les.setComFourn(rset.getDouble("Com_Fournisseurs"));
					les.setDispo(les.reel - les.comClient);
					les.setVirtuel(les.dispo + les.comFourn);
				}
				les.setValorisation(rset.getDouble("Valorisation"));
				
				valorisationTotale += les.valorisation * les.reel;
				reelTotal += les.reel;
				
				lignes.add(les);
			}
			rset.close();
			stt.close();
			
			psMvtStock.close();
			psMvtComClient.close();
			s.closeConnection(con, null);
			
		} catch(Exception e) {
			e.printStackTrace();
		}
	}
	
	
	public int getNbLignes() {
		return lignes.size();
	}



} // fin DataEtatStock
