/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un tableau de statistiques
 */

package org.opensi.facturation.actions.editions;

import java.sql.Date;
import java.text.SimpleDateFormat;

import org.opensi.util.listing.ListingFile;
import org.opensi.util.listing.ListingTabFile;
import org.opensi.util.tools.Arrondi;

public class CsvStatistiquesMA {
	
	public CsvStatistiquesMA(String buffer, String fichier, DataStatistiquesMA dsc) throws Exception {
		
		ListingFile lf = new ListingTabFile();
			
		 SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
		 
			lf.newLine();
			lf.addToLine("P\u00E9riode du "+ formatDate.format(new Date(dsc.debutPeriode)) + " au " + formatDate.format(new Date(dsc.finPeriode)));
			lf.addToLine("");
			lf.addToLine("");
			lf.addToLine("");
			lf.addToLine("");
			lf.addToLine("");
			lf.addToLine("");
			lf.addToLine("");
		
			lf.newLine();
			lf.addToLine("R\u00E9f. Article");
			lf.addToLine("Fournisseur");
			lf.addToLine("Quantit\u00E9 vendue");
			lf.addToLine("Prix d'achat");
			lf.addToLine("Prix de vente HT");
			lf.addToLine("CA HT");
			lf.addToLine("Marge en valeur");
			lf.addToLine("Marge en %");
			int nbLignes = dsc.getNbLignes();
			for (int i=0; i<nbLignes; i++) {
				LigneStatistiqueMA lsc = dsc.lignes.get(i);
				lf.newLine();
				lf.addToLine(lsc.getArticle_Id());
				lf.addToLine(("" + lsc.getFournisseur()).replaceAll("\\.", ","));
				lf.addToLine(("" + lsc.getQte()).replaceAll("\\.", ","));
				lf.addToLine(("" + lsc.getPrix_achat()).replaceAll("\\.", ","));
				lf.addToLine(("" + lsc.getPrix_vente()).replaceAll("\\.", ","));
				lf.addToLine(("" + lsc.getCA_HT()).replaceAll("\\.", ","));
				lf.addToLine(("" + lsc.getMargeValeur()).replaceAll("\\.", ","));
				lf.addToLine(("" + lsc.getMargePourcent()).replaceAll("\\.", ","));
				
			}
			double totCA1 = 0;
			double totCA2=0;
			double totMarV1=0;
			double totMarV2=0;
			double totMarP1=0;
			double totMarP2=0;
			int nbLignes2 = dsc.getNbLignesTot1();
			for (int i=0; i<nbLignes2; i++) {
				LigneStatistiqueMA tot1 = dsc.totaux1.get(i);
				lf.newLine();
				lf.addToLine("Total");
				lf.addToLine("");
				lf.addToLine("");
				lf.addToLine("");
				lf.addToLine("");
				totCA1=tot1.getTotCA();
				totMarV1=tot1.getTotMargeV();
				totMarP1=tot1.getTotMargeP();
				lf.addToLine((""+ tot1.getTotCA()).replaceAll("\\.", ","));
				lf.addToLine((""+ tot1.getTotMargeV()).replaceAll("\\.", ","));
				lf.addToLine((""+ tot1.getTotMargeP()).replaceAll("\\.", ","));
			}
				lf.newLine();
				lf.addToLine("");
				lf.addToLine("");
				lf.addToLine("");
				lf.addToLine("");
				lf.addToLine("");
				lf.addToLine("");
				lf.addToLine("");
				lf.addToLine("");
			int nbLignes3 = dsc.getNbLignesTot2();
			for (int i=0; i<nbLignes3; i++) {
				LigneStatistiqueMA tot2 = dsc.totaux2.get(i);
				lf.newLine();
				lf.addToLine("");
				lf.addToLine("");
				lf.addToLine("");
				lf.addToLine("P\u00E9riode pr\u00E9c\u00E9dente du "+ formatDate.format(new Date(dsc.debutNmoins1)) + " au " + formatDate.format(new Date(dsc.finNmoins1)) +"");
				totCA2=tot2.getTotCA();
				totMarV2=tot2.getTotMargeV();
				if (totMarV2==0 || totCA2==0){
					totMarP2=0;
				}
				else{
				totMarP2=tot2.getTotMargeP();
				}
				lf.addToLine("Total p\u00E9riode pr\u00E9c\u00E9dente");
				lf.addToLine((""+ totCA2).replaceAll("\\.", ","));
				lf.addToLine((""+ totMarV2).replaceAll("\\.", ","));
				lf.addToLine((""+ totMarP2).replaceAll("\\.", ","));
			}
				lf.newLine();
				lf.addToLine("");
				lf.addToLine("");
				lf.addToLine("");
				lf.addToLine("");
				lf.addToLine("");
				lf.addToLine("");
				lf.addToLine("");
				lf.addToLine("");
				
				lf.newLine();
				lf.addToLine("");
				lf.addToLine("");
				lf.addToLine("");
				lf.addToLine("");
				lf.addToLine("Evolution en %");
				if (totMarV2==0 || totCA2==0 || totMarV1==0 || totCA1==0){
					lf.addToLine("0");
					lf.addToLine("0");
					lf.addToLine("0");
				}
				else{
					Arrondi arrondi=new Arrondi(2);
					lf.addToLine(""+ arrondi.round((totCA1-totCA2)*100/totCA2));
					lf.addToLine(""+ arrondi.round((totMarV1-totMarV2)*100/totMarV2));
					if (totMarP2==0) {
						lf.addToLine("0");
					} else {
						lf.addToLine(""+ arrondi.round((totMarP1-totMarP2)*100/totMarP2));
					}
				}
				
			
		lf.write(buffer, fichier, true);
	}



} // fin CsvStatistiquesMA
