/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un palmars article en csv
 */

package org.opensi.facturation.actions.editions;

import org.opensi.util.listing.ListingFile;
import org.opensi.util.listing.ListingTabFile;


public class CsvPalmaresArticle {
		
	public CsvPalmaresArticle(String buffer, String fichier, DataPalmaresArticle dpa) throws Exception {
		
		ListingFile lf = new ListingTabFile();

		lf.newLine();
		lf.addToLine("R\u00E9f\u00E9rence");
		lf.addToLine("Article");
		lf.addToLine("Quantit\u00E9");
		lf.addToLine("CA HT");
		
		int nbLignes = dpa.getNbLignes();
		
		for (int i=0; i<nbLignes; i++) {
			LignePalmaresArticle lp = dpa.lignes.get(i);
			
			lf.newLine();
			lf.addToLine(lp.numero);
			lf.addToLine("\"" +lp.designation + "\"");
			lf.addToLine(("" + lp.qte).replaceAll("\\.", ","));
			lf.addToLine(("" + lp.caHT).replaceAll("\\.", ","));
		}
		
		lf.write(buffer, fichier, true);
	}



} // fin CsvPalmaresArticle
