/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un listing article
 */

package org.opensi.facturation.actions.editions;

import org.opensi.util.listing.ListingFile;
import org.opensi.util.listing.ListingTabFile;

public class CsvListeArticle {
	
	public CsvListeArticle(String buffer, String fichier, DataListeArticle da) throws Exception {
		
		ListingFile lf = new ListingTabFile();

		lf.newLine();
		lf.addToLine("R\u00E9f. Article");
		lf.addToLine("D\u00E9signation");
		lf.addToLine("Marque");
		lf.addToLine("Famille 1");
		lf.addToLine("Famille 2");
		lf.addToLine("Famille 3");
		lf.addToLine("PV HT du "+ da.labelTarif1);
		lf.addToLine("PV HT du "+ da.labelTarif2);
		lf.addToLine("PV HT du "+ da.labelTarif3);
		lf.addToLine("PV HT du "+ da.labelTarif4);
		lf.addToLine("PV HT du "+ da.labelTarif5);
		lf.addToLine("PV TTC du "+ da.labelTarif1);
		lf.addToLine("PV TTC du "+ da.labelTarif2);
		lf.addToLine("PV TTC du "+ da.labelTarif3);
		lf.addToLine("PV TTC du "+ da.labelTarif4);
		lf.addToLine("PV TTC du "+ da.labelTarif5);
		lf.addToLine("R\u00E9f. Fournisseur");
		lf.addToLine("Prix d'Achat");
		
		int nbLignes = da.getNbLignes();				
		for (int j=0; j<nbLignes; j++) {
			LigneArticle la = da.lignes.get(j);
			
			lf.newLine();
			lf.addToLine("\""+la.refArticle+"\"");
			lf.addToLine("\""+la.designation+"\"");
			lf.addToLine("\""+la.marque+"\"");
			lf.addToLine("\""+la.famille1+"\"");
			lf.addToLine("\""+la.famille2+"\"");
			lf.addToLine("\""+la.famille3+"\"");
			lf.addToLine(("" + la.tarif_1_HT).replaceAll("\\.", ","));
			lf.addToLine(("" + la.tarif_2_HT).replaceAll("\\.", ","));
			lf.addToLine(("" + la.tarif_3_HT).replaceAll("\\.", ","));
			lf.addToLine(("" + la.tarif_4_HT).replaceAll("\\.", ","));
			lf.addToLine(("" + la.tarif_5_HT).replaceAll("\\.", ","));
			lf.addToLine(("" + la.tarif_1_TTC).replaceAll("\\.", ","));
			lf.addToLine(("" + la.tarif_2_TTC).replaceAll("\\.", ","));
			lf.addToLine(("" + la.tarif_3_TTC).replaceAll("\\.", ","));
			lf.addToLine(("" + la.tarif_4_TTC).replaceAll("\\.", ","));
			lf.addToLine(("" + la.tarif_5_TTC).replaceAll("\\.", ","));
			lf.addToLine("\""+la.refFournisseur+"\"");
			lf.addToLine(("" + la.prixAchat).replaceAll("\\.", ","));
		}
		
		lf.write(buffer, fichier, true);
	}



} // fin CsvListeArticle
