/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un journal des acomptes en csv
 */

package org.opensi.facturation.actions.editions;

import org.opensi.util.listing.ListingFile;
import org.opensi.util.listing.ListingTabFile;
import org.opensi.util.tools.DateTime;

public class CsvJournalAcomptes {
	
	public CsvJournalAcomptes(String buffer, String fichier, DataJournalAcomptes dja, boolean detailCC) throws Exception {
		
		ListingFile lf = new ListingTabFile();

		lf.newLine();
		lf.addToLine("Date");
		lf.addToLine("Num\u00E9ro Client");
		lf.addToLine("Client");
		lf.addToLine("Num\u00E9ro Compte");
		lf.addToLine("Num\u00E9ro Pi\u00E8ce");
		lf.addToLine("Montant HT");
		lf.addToLine("Montant TVA");
		lf.addToLine("Montant TTC");
		lf.addToLine("Solde TTC progressif");
		
		int nbLignes = dja.getNbLignes();
		
		for (int i=0; i<nbLignes; i++) {
			LigneJournal lj = dja.lignes.get(i);
			
			lf.newLine();
			lf.addToLine(DateTime.formatTime(lj.datePiece, "dd/MM/yyyy"));
			lf.addToLine(lj.numTiers);
			lf.addToLine("\"" + lj.tiers + "\"");
			lf.addToLine(lj.numCompte);
			lf.addToLine(lj.numPiece);
			lf.addToLine(("" + lj.montantHT).replaceAll("\\.", ","));
			lf.addToLine(("" + lj.montantTVA).replaceAll("\\.", ","));
			lf.addToLine(("" + lj.montantTTC).replaceAll("\\.", ","));
			lf.addToLine(("" + lj.totalProgressif).replaceAll("\\.", ","));
		}
		
		if (detailCC) {
			lf.newLine();
			lf.addToLine("Num\u00E9ro Compte");
			lf.addToLine("Client");
			lf.addToLine("Montant HT");
			lf.addToLine("Montant TVA");
			lf.addToLine("Montant TTC");
			lf.addToLine("");
			lf.addToLine("");
			lf.addToLine("");
			lf.addToLine("");
			
			nbLignes = dja.getNbLignesDetails();
			for (int i=0; i<nbLignes; i++) {
				LigneDetailCompte ldc = dja.details.get(i);
				
				lf.newLine();
				lf.addToLine(ldc.numCompte);
				lf.addToLine("\"" + ldc.tiers + "\"");
				lf.addToLine(("" + ldc.montantHT).replaceAll("\\.", ","));
				lf.addToLine(("" + ldc.montantTVA).replaceAll("\\.", ","));
				lf.addToLine(("" + ldc.montantTTC).replaceAll("\\.", ","));
				lf.addToLine("");
				lf.addToLine("");
				lf.addToLine("");
				lf.addToLine("");
			}
		}
		
		lf.write(buffer, fichier, true);
	}



} // fin CsvJournalAcomptes
