/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'une facture standard
 */

package org.opensi.facturation.actions.documents.modeles;


import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;

import org.experlog.openeas.api.Session;
import org.opensi.facturation.DocumentUtils;
import org.opensi.util.calcul.Calcul;
import org.opensi.util.calcul.CalculVentilTVA;
import org.opensi.util.tools.StringUtils;


class Ligne {
	public long date = 0;
	public double montant = 0;
	public String libelle = "";
	
	public Ligne(long date, double montant, String libelle) {
		this.date = date;
		this.montant = montant;
		this.libelle = libelle;
	}
}


public class DataFacture {


	private DecimalFormatSymbols dfs2 = new DecimalFormatSymbols();
	
	private DecimalFormat numFormatQte = new DecimalFormat("0.##");
	private SimpleDateFormat formatDate = new SimpleDateFormat("dd.MM.yy");



	// les lignes de la facture
	public ArrayList<LigneFacture> lignes = new ArrayList<LigneFacture>(10);
	public ArrayList<Ligne> lignesEcheances = new ArrayList<Ligne>(10);
	public ArrayList<Ligne> lignesAcomptes = new ArrayList<Ligne>(10);


	// coordonnes socit mettrice

	public String raisonSociale;
	public String adresse1;
	public String adresse2;
	public String adresse3;
	public String codePostal;
	public String ville;
	public String pays;
	public String tel;
	public String fax;
	public String email;
	public String web;
	
	public double capital;
	public String typeSociete;
	public String tvaIntra;
	public String rcs;
	public String siren;
	
	// coordonnes du destinataire
	
	public String clientId;
	public String raisonSocialeDest;
	public String adresseDest;
	public String compAdresseDest;
	public String adresseDest3;
	public String codePostalDest;
	public String villeDest;
	public String paysDest;
	
	// coordonnes de livraison
	
	public String denominationLiv;
	public String adresse1Liv;
	public String adresse2Liv;
	public String adresse3Liv;
	public String codePostalLiv;
	public String villeLiv;
	public String paysLiv;
	
	public String codePaysLiv;

	public String numTvaClient = "";
	
	// coordonnes d'envoi
	
	public String denominationEnvoi;
	public String adresse1Envoi;
	public String adresse2Envoi;
	public String adresse3Envoi;
	public String codePostalEnvoi;
	public String villeEnvoi;
	public String paysEnvoi;
	public String faxEnvoi;
	
	// infos facture
	
	public String numeroFacture;
	public String modeEnvoiFacture;
	public String interlocuteur = "";
	public String interTel = "";
	public String interFax = "";
	public String interMail = "";
	public String interlocuteurLiv = "";
	public String interTelLiv = "";
	public String interFaxLiv = "";
	public String interMailLiv = "";
	public String interlocuteurEnvoi = "";
	public boolean zoneUE=false;
	public String comFin = "";
	public String mentions = "";
	public String codeFournisseur;
	public String refAffaire;
	public String numCommande;
	public String refCommande;
	public String refBL;
	
	public long dateFacture;
	
	public double tRemise = 0;
	public double tEscompte = 0;
	public double mRemise = 0;
	public double mEscompte = 0;
	public double acompte = 0;
	public double fraisPort = 0;
	public double montantBase = 0;
	public double totalBase = 0;
	public double totalTVA = 0;
	public double montantTTC = 0;
	public double netAPayer = 0;
	public double tauxTvaPort = 0;
	public double ecoTaxe = 0;	
	
	public double montantBaseInd;
	public double mRemiseInd;
	public double fraisPortInd = 0;
	public double totalBaseInd = 0;
	public double totalTVAInd = 0;
	public double montantTTCInd = 0;
	public double netAPayerInd = 0;
	public double mEscompteInd = 0;
	
	public double tauxInd = 0;

	public boolean sansarticles = false;
	public boolean editionTTC = false;
	public boolean rist = false;
	public boolean coul = false;
	public boolean tail = false;
	public boolean unite = false;
	public boolean commission = false;
	public boolean nbPieces = false;
	public boolean numLot = false;
	public boolean datePeremption = false;
	public boolean logoAdr;
	public String urlLogo = "";
	public String urlApercu = "";
	
	public String urlFlecheHautLCR = "";
	public String urlFlecheBasLCR = "";
	public String urlPetiteFlecheLCR = "";
	
	public int nbex;
	public int directe;
	public boolean imprimerAdrLiv;
	public boolean imprimerLCR;
	public boolean imprimerRIB;
	public boolean apercu;
	
	public String regimeTVA = "G";
	public boolean exonerationTVA = false;
	
	public boolean envoimail = false;
	public String modeEnvoi = "";
	
	public boolean assujetti;
	public boolean TVALiv;
	public String typePays;
	
	// coordonnes du virement
	public String codeBanque;
	public String codeGuichet;
	public String numCompte;
	public String cleRIB;
	public String domiciliation;
	public String IBAN;
	public String BIC;
	public boolean existeBanque;
	
	// dtails des totaux
	public double tRemiseFP = 0;
	public double mRemiseFP = 0;
	
	public double totalHTCommissionne = 0;

	public double mRemiseHT = 0;
	public double tauxTvaRemise = 0;
	public double montantTvaRemise = 0;
	public double mRemiseTTC = 0;
	
	public double mCommissionHT = 0;
	public double tauxTvaCommission = 0;
	public double montantTvaCommission = 0;
	public double mCommissionTTC = 0;
	
	public double mFraisPortHT = 0;
	public double montantTvaFraisPort = 0;
	public double mFraisPortTTC = 0;
	
	public double mRemiseFraisPortHT = 0;
	public double tauxTvaRemiseFraisPort = 0;
	public double montantTvaRemiseFraisPort = 0;
	public double mRemiseFraisPortTTC = 0;
	

	private String codePays;
	
	public String absdir;

	public Calcul calc;

	protected HashMap<Integer, CalculVentilTVA> ventilTVA;


	/**
	 * Constructeur appel par dfaut
	 */
	public DataFacture(Session s, String factureId) {
		this(s, factureId, false, 0);
	}
	
	
	public DataFacture(Session s, String factureId, boolean apercu, long dateFacture) {	
		try {		
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			Statement stt2 = con.createStatement();
			
			String dossierId = s.getCookie().get("Dossier_Id");
			String base = s.getCookie().get("BaseDossier");
			this.absdir = s.getAppConfiguration().get("opensi.absdir");
			
			this.urlLogo = s.getAppConfiguration().get("opensi.absdir") +"/logos/"+ dossierId +".jpg";
			this.urlApercu = s.getAppConfiguration().get("opensi.absdir") +"/images/apercu.jpg";
			this.urlFlecheHautLCR = s.getAppConfiguration().get("opensi.absdir") +"/images/fleche_haut.jpg";
			this.urlFlecheBasLCR = s.getAppConfiguration().get("opensi.absdir") +"/images/fleche_bas.jpg";
			this.urlPetiteFlecheLCR = s.getAppConfiguration().get("opensi.absdir") +"/images/petite_fleche.jpg";
			this.apercu = apercu;

			ResultSet rset;
			
			dfs2.setDecimalSeparator('.');
			numFormatQte.setDecimalFormatSymbols(dfs2);
			
      
			// coordonnes de l'entreprise facturante
			
			String reqFacturante = "select s.Ville_RCS, s.Num_TVA_Intra, ts.Libelle as Type_Societe, s.Montant_Capital, s.Num_SIRET, s.Denomination, s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville, s.Telephone, s.Fax, s.Email, s.Site_Web";
			reqFacturante += " from "+ base +".SOCIETE s join "+ base +".TYPE_SOCIETE ts on s.Type_Societe=ts.Type_Societe_Id";
			
			rset = stt.executeQuery(reqFacturante);
			
			rset.next();
			
			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.tel = rset.getString("Telephone");
			this.fax = rset.getString("Fax");
			this.email = rset.getString("Email");
			this.web = rset.getString("Site_Web");
			
			this.siren = DocumentUtils.formatSiren(rset.getString("Num_SIRET"));
			this.typeSociete = rset.getString("Type_Societe");
			this.capital = rset.getDouble("Montant_Capital");
			this.tvaIntra = rset.getString("Num_TVA_Intra");
			this.rcs = rset.getString("Ville_RCS");		
			
			rset.close();
			
			
			String reqAcomptes = "select coalesce(sum(ac.Total_TTC),0) as Montant from "+ base +".ACOMPTE_CLIENT ac join "+ base +".COMMANDE_CLIENT_FACTURE ccf on ac.Commande_Id=ccf.Commande_Id where ccf.Facture_Id="+ factureId;
			rset = stt.executeQuery(reqAcomptes);
			rset.next();
			this.acompte = rset.getDouble("Montant");
			rset.close();
			
			
			// RIB de l'entreprise
			String reqRIB = "select if(p.Banque_Id is NULL,0,1) as Existe_Banque, coalesce(b.Nom,'') as Nom, coalesce(b.Adresse,'') as Adresse, coalesce(b.Code_Agence,'') as Code_Agence, coalesce(b.Code_Guichet,'') as Code_Guichet,";
			reqRIB += " coalesce(b.Num_Compte,'') as Num_Compte, coalesce(b.Cle_RIB,'') as Cle_RIB, coalesce(b.IBAN,'') as IBAN, coalesce(b.BIC,'') as BIC";
			reqRIB += " from "+ base +".PARAM_DOSSIER p left join "+ base +".BANQUE b on p.Banque_Id=b.Banque_Id";
			rset = stt.executeQuery(reqRIB);
			rset.next();
			this.codeBanque = rset.getString("Code_Agence");
			this.codeGuichet = rset.getString("Code_Guichet");
			this.numCompte = rset.getString("Num_Compte");
			this.cleRIB = rset.getString("Cle_RIB");
			this.domiciliation = rset.getString("Nom")+ " - "+ rset.getString("Adresse");
			this.IBAN = rset.getString("IBAN");
			this.BIC = rset.getString("BIC");
			this.existeBanque = (rset.getInt("Existe_Banque")==1);
			rset.close();
			
			// Elments de la facture
			
			boolean existeLCR = false;
			boolean existeVirement = false;
			boolean premiereEcheance = true;
			
			String reqEchFact = "select coalesce(mr.Libelle,'') as Mode_Reg, coalesce(tr.Libelle,'') as Type_Reglement, efc.Montant, efc.Date_Echeance";
			reqEchFact += " from "+ base +".ECHEANCE_FACTURE_CLIENT efc left join "+ base +".MODE_REGLEMENT mr on efc.Mode_Reg_Id=mr.Mode_Reg_Id";
			reqEchFact += " left join "+ base +".TYPE_REGLEMENT tr on mr.Type_R=tr.Type_Reg_Id where efc.Facture_Id="+ factureId +" order by efc.Date_Echeance";
			rset = stt.executeQuery(reqEchFact);
			while (rset.next()) {
				if (premiereEcheance) {
					String typeReglement = rset.getString("Type_Reglement");
					if (typeReglement.equals("LCR")) { existeLCR = true; }
					else if (typeReglement.equals("VIREMENT")) { existeVirement = true; }
					premiereEcheance = false;
				}
				this.lignesEcheances.add(new Ligne(rset.getLong("Date_Echeance"), rset.getDouble("Montant"), rset.getString("Mode_Reg")));
			}
			rset.close();
			
			String reqEchAcomptes = "select ac.Date_Acompte, ac.Numero, iafc.Montant from "+ base +".IMPUTATION_ACOMPTE_FACTURE_CLIENT iafc";
			reqEchAcomptes += " join "+ base +".ACOMPTE_CLIENT ac on iafc.Acompte_Id=ac.Acompte_Id where iafc.Facture_Id="+ factureId +" order by ac.Date_Acompte";
			rset = stt.executeQuery(reqEchAcomptes);
			while (rset.next()) {
				this.lignesAcomptes.add(new Ligne(rset.getLong("Date_Acompte"), rset.getDouble("Montant"), rset.getString("Numero")));
			}
			rset.close();
			
			String reqFacture = "select f.*, coalesce(f.Client_Id,'') as ClientId, if(f.Fax_Inter_Envoi<>'',f.Fax_Inter_Envoi,coalesce(fc.Fax_1,'')) as Fax_Envoi, c1.Civ_Courte as Civ_Courte_Fact, c2.Civ_Courte as Civ_Courte_Liv, c3.Civ_Courte as Civ_Courte_Envoi,";
			reqFacture += " p1.Nom_FR as Pays, p2.Nom_FR as Pays_Liv, p3.Nom_FR as Pays_Envoi, p2.Zone_UE, p2.Type_Pays from "+ base +".FACTURE f";
			reqFacture += " left join "+ base +".FICHE_CLIENT fc on f.Client_Id=fc.Client_Id, CIVILITE c1, CIVILITE c2, CIVILITE c3, PAYS p1, PAYS p2, PAYS p3";
			reqFacture += " where c1.Civ_Id=f.Civ_Inter and c2.Civ_Id=f.Civ_Inter_Liv and c3.Civ_Id=f.Civ_Inter_Envoi and f.Code_Pays=p1.Code_Pays and f.Code_Pays_Liv=p2.Code_Pays and f.Code_Pays_Envoi=p3.Code_Pays and f.Facture_Id="+ factureId;
			
			rset = stt.executeQuery(reqFacture);
			
			rset.next();
			
			
			this.numeroFacture = rset.getString("Num_Entier");
			this.modeEnvoiFacture = rset.getString("Mode_Envoi_Facture");
			this.dateFacture = this.apercu ? dateFacture : rset.getLong("Date_Facture");
			this.tEscompte = rset.getDouble("Escompte");
			this.tRemise = rset.getDouble("Remise");
			this.fraisPort = rset.getDouble("Frais_Port");
			this.raisonSocialeDest = rset.getString("Denomination");
			this.adresseDest = rset.getString("Adresse_1");
			this.compAdresseDest = rset.getString("Adresse_2");
			this.adresseDest3 = rset.getString("Adresse_3");
			this.codePostalDest = rset.getString("Code_Postal");
			this.villeDest = rset.getString("Ville");
			this.paysDest = rset.getString("Pays");
			this.codePays = rset.getString("Code_Pays");
			this.denominationLiv = rset.getString("Denomination_Liv");
			this.adresse1Liv = rset.getString("Adresse_1_Liv");
			this.adresse2Liv = rset.getString("Adresse_2_Liv");
			this.adresse3Liv = rset.getString("Adresse_3_Liv");
			this.codePostalLiv = rset.getString("Code_Postal_Liv");
			this.villeLiv = rset.getString("Ville_Liv");
			this.paysLiv = rset.getString("Pays_Liv");
			this.codePaysLiv = rset.getString("Code_Pays_Liv");
			this.denominationEnvoi = rset.getString("Denomination_Envoi");
			this.adresse1Envoi = rset.getString("Adresse_1_Envoi");
			this.adresse2Envoi = rset.getString("Adresse_2_Envoi");
			this.adresse3Envoi = rset.getString("Adresse_3_Envoi");
			this.codePostalEnvoi = rset.getString("Code_Postal_Envoi");
			this.villeEnvoi = rset.getString("Ville_Envoi");
			this.paysEnvoi = rset.getString("Pays_Envoi");
			this.faxEnvoi = rset.getString("Fax_Envoi");
			this.clientId = rset.getString("ClientId");
			this.numTvaClient = rset.getString("Num_TVA_Intra");
			this.zoneUE = (rset.getInt("Zone_UE")==1);
			this.editionTTC = rset.getInt("Edition_TTC")==1;
			this.directe = rset.getInt("Directe");
			this.tauxTvaPort = rset.getDouble("Taux_TVA_Port");
			this.ecoTaxe = rset.getDouble("Eco_Taxe");
			this.assujetti = rset.getInt("Assujetti_TVA")==1;
			this.TVALiv = rset.getInt("TVA_Liv")==1;
			this.typePays = rset.getString("Type_Pays");
			this.tauxInd = rset.getDouble("Taux_Indicatif");
			this.regimeTVA = rset.getString("Regime_TVA");
			this.modeEnvoi = rset.getString("Mode_Envoi_Facture");
			this.envoimail = rset.getLong("Date_Envoi")!=0;
			
			if (rset.getString("Nom_Inter").equals("")) {
				this.interlocuteur = "";
			}
			else {
				this.interlocuteur = rset.getString("Civ_Courte_Fact") +" "+ rset.getString("Nom_Inter").toUpperCase() + " " + rset.getString("Prenom_Inter");
			}
			this.interFax = rset.getString("Fax_Inter");
			this.interTel = rset.getString("Tel_Inter");
			this.interMail = rset.getString("Email_Inter");
			
			if (rset.getString("Nom_Inter_Liv").equals("")) {
				this.interlocuteurLiv = "";
			}
			else {
				this.interlocuteurLiv = rset.getString("Civ_Courte_Liv") +" "+ rset.getString("Nom_Inter_Liv").toUpperCase() + " " + rset.getString("Prenom_Inter_Liv");
			}
			this.interFaxLiv = rset.getString("Fax_Inter_Liv");
			this.interTelLiv = rset.getString("Tel_Inter_Liv");
			this.interMailLiv = rset.getString("Email_Inter_Liv");
			
			if (rset.getString("Nom_Inter_Envoi").equals("")) {
				this.interlocuteurEnvoi = "";
			}
			else {
				this.interlocuteurEnvoi = rset.getString("Civ_Courte_Envoi") +" "+ rset.getString("Nom_Inter_Envoi").toUpperCase() + " " + rset.getString("Prenom_Inter_Envoi");
			}
			
			
			if (!rset.getString("Commentaires_Fin").equals("")) {
				this.comFin = StringUtils.removeHtmlTags("\n"+ rset.getString("Commentaires_Fin"));
			}
			this.mentions = "\n\n"+ rset.getString("Mentions");
			
			rset.close();
			
			this.exonerationTVA = this.regimeTVA.equals("E") || (this.regimeTVA.equals("G") && !this.zoneUE);
					
			
			// Paramtres dossier
      
			String reqCom = "select Com_Fact, Logo_Adr, Imprimer_Adr_Liv, Imp_LCR, Imp_RIB from "+ base +".PARAM_DOSSIER";
			
			rset = stt.executeQuery(reqCom);
			
			rset.next();
			
			logoAdr = rset.getInt("Logo_Adr")==1;
			
			if (rset.getString("Com_Fact").length()>0) {
				this.comFin += "\n\n"+rset.getString("Com_Fact");
			}
			
			this.imprimerAdrLiv = (rset.getInt("Imprimer_Adr_Liv")==1 || !this.codePaysLiv.equals("FR"));
			this.imprimerLCR = (rset.getInt("Imp_LCR")==1  && existeLCR);
			this.imprimerRIB = (existeBanque && rset.getInt("Imp_RIB")==1  && existeVirement);
			rset.close();
			
			
			// modification des coordonnes de l'entreprise facturante si code_pays reli a un site_id dans PARAM_PAYS_WEB
      
			String reqParamPaysWeb = "select * from "+ base +".SITE s,"+ base +".PARAM_PAYS_WEB ppw where ppw.Site_Id=s.Site_Id and ppw.Code_Pays='"+ this.codePays +"'";
			
			rset = stt.executeQuery(reqParamPaysWeb);
			
			if (rset.next()) {
				this.raisonSociale = rset.getString("Denomination");
				this.adresse1 = rset.getString("Adresse_1");
				this.adresse2 = rset.getString("Adresse_2");
				this.adresse3 = rset.getString("Adresse_3");
				this.codePostal = rset.getString("Code_Postal");
				this.ville = rset.getString("Ville");
				this.tel = rset.getString("Tel");
				this.fax = rset.getString("Fax");
				this.email = rset.getString("Email");
				this.tvaIntra = rset.getString("Numero_TVA");
			}
			rset.close();
			

			
			// rfrences affaire, BL et commandes
			
			this.refAffaire = "";
			this.numCommande = "";
			this.refCommande = "";
			this.refBL = "";
			
			int nbBons = 0;
			int nbAffaires = 0;
			
			
			if (directe==0) {
				String reqAffaire = "select a.Num_Entier from "+ base +".AFFAIRE_FACTURE f,"+ base +".AFFAIRE a where f.Affaire_Id=a.Affaire_Id and f.Facture_Id="+ factureId;
				rset = stt.executeQuery(reqAffaire);
				if (rset.next()) {
					this.refAffaire = rset.getString("Num_Entier");
					nbAffaires++;
					while (rset.next()) {
						this.refAffaire += " - "+ rset.getString("Num_Entier");
						nbAffaires++;
					}
				}
				rset.close();
				
				
				String reqCommande = "select cc.Numero, cc.Ref_Commande from "+ base +".COMMANDE_CLIENT cc, "+ base +".COMMANDE_CLIENT_FACTURE ccf where ccf.Commande_Id=cc.Commande_Id and Facture_Id="+ factureId;
				rset = stt.executeQuery(reqCommande);
				if (rset.next()) {
					this.numCommande = rset.getString("Numero");
					this.refCommande = rset.getString("Ref_Commande");
					while (rset.next()) {
						this.numCommande += " - "+ rset.getString("Numero");
						this.refCommande += " - "+ rset.getString("Ref_Commande");
					}
				}
				rset.close();
				
				String reqBL = "select bl.Num_Entier from "+ base +".BON_LIVRAISON bl, "+ base +".BON_LIVRAISON_FACTURE blf";
				reqBL += " where bl.Bon_Id=blf.Bon_Id and Numero>0 and blf.Facture_Id="+ factureId;
				rset = stt.executeQuery(reqBL);
				if (rset.next()) {
					this.refBL = rset.getString("Num_Entier");
					nbBons++;
					while (rset.next()) {
						this.refBL += " - "+ rset.getString("Num_Entier");
						nbBons++;
					}
				}
				rset.close();
			}
			
			
			// nombre d'exemplaires  sortir et donnes fiche client
       
      if (clientId.equals("")) {
        this.comFin += "\n\n";
        this.nbex = 1;
		this.codeFournisseur = "";
      }
			else {

			  String reqEx = "select Nb_Ex, Com_Fact, Code_Fournisseur from "+ base +".FICHE_CLIENT where Client_Id='"+ clientId +"'";
			  rset = stt.executeQuery(reqEx);
			
			  if (rset.next()) {
			    if (rset.getString("Com_Fact").length()>0) {
				    this.comFin += "\n\n"+rset.getString("Com_Fact");
			    }
			    this.nbex = rset.getInt("Nb_Ex") + 1;
					this.codeFournisseur = rset.getString("Code_Fournisseur");
        }
				else {
					this.comFin += "\n\n";
					this.nbex = 1;
					this.codeFournisseur = "";
        }			
			  rset.close();
      }
      if (this.envoimail && this.modeEnvoi.equals("M")) {
    	  this.nbex = 1;
      }
      
      
      // selection des articles appartenant  la facture
			
			String reqArticles = "select * from "+ base +".LIGNE_FACTURE where Facture_Id="+ factureId +" order by Rank";
			rset = stt.executeQuery(reqArticles);
			
			
			String reqInfosSup = "select coalesce(ca.Libelle,'') as Couleur, coalesce(ta.Libelle,'') as Taille, fa.Descrip_1, fa.Descrip_2, fa.Imp_Nom_Facture, fa.Imp_Desc1_Facture, fa.Imp_Desc2_Facture";
			reqInfosSup += " from "+ base +".FICHE_ARTICLE fa left join "+ base +".COULEUR_ARTICLE ca on fa.Couleur_Id=ca.Couleur_Id";
			reqInfosSup += " left join "+ base +".TAILLE_ARTICLE ta on fa.Taille_Id=ta.Taille_Id where fa.Article_Id=?";
			
			PreparedStatement psInfosSup = con.prepareStatement(reqInfosSup);
			
			
			String reqNomenclature = "select n.ArticleComp_Id, n.Quantite, f.Designation "
														 + "from "+ base +".FICHE_ARTICLE f,"+ base +".COMPOSANT_ARTICLE n where f.Article_Id=n.ArticleComp_Id and n.Article_Id=?";
			
			PreparedStatement psNomenclature = con.prepareStatement(reqNomenclature);
					
			sansarticles = false;
			while (rset.next()) {
				
				String commentaireAvant = rset.getString("Commentaire_Avant");				
				
				if (commentaireAvant.length()>0) {
				
					String tabCom[] = commentaireAvant.split("\n");
					
					for (int i=0; i<tabCom.length; i++) {
					
						LigneFacture lc = new LigneFacture();
						lc.setType('C');
						lc.setDesignation(tabCom[i]);
						lc.setSousTotal(montantBase);
						lignes.add(lc);
					}
				}
				
				
				LigneFacture lf = new LigneFacture();
        
				String libelle = rset.getString("Libelle");
				
				if (libelle.length()>0) {
					libelle = "\n"+ libelle;
				}			
				
				lf.setReference(rset.getString("Reference"));
				lf.setDesignation(rset.getString("Designation") + libelle);
				lf.setQuantite(rset.getDouble("Quantite"));
				lf.setPrixUnitaire(rset.getDouble("Prix"));
				lf.setRistourne(rset.getDouble("Ristourne"));
				lf.setCommission(rset.getDouble("Commission"));
				lf.setUnite(rset.getString("Unite"));
				lf.setNumLot(rset.getString("Num_Lot"));
				lf.setNbPieces(rset.getInt("Nb_Pieces"));
				lf.setDatePeremption(rset.getLong("Date_Peremption"));
				lf.setType('A');				
				lf.setPrixIndicatif(rset.getDouble("Prix")*tauxInd);
				
				if (lf.ristourne!=0) rist = true;
				if (lf.commission!=0) commission = true;
				if (!lf.unite.equals("U")) unite = true;
				if (!lf.num_lot.equals("")) numLot = true;
				if (lf.nb_pieces != 0) nbPieces = true;
				if (lf.date_peremption != 0) datePeremption = true;
				
				lf.setMontant(lf.prixUnitaire * lf.quantite * (1-lf.ristourne/100) * (1-lf.commission/100));
				
				montantBase += lf.montant;
				
				lf.setSousTotal(montantBase);
				

				ResultSet rset2;
				
				if (directe==0 && nbAffaires>1) {
					
					// ajout des rfrences affaire et commande
					String reqRefCom = "select a.Num_Entier, cc.Ref_Commande from "+ base +".AFFAIRE a, "+ base +".COMMANDE_CLIENT cc, "+ base +".LIGNE_FACTURE af, "+ base +".LIGNE_COMMANDE_CLIENT lcc ";
					reqRefCom += "where lcc.Ligne_Id=af.Ref_Ligne and lcc.Statut='V' and cc.Commande_Id=lcc.Commande_Id and cc.Affaire_Id=a.Affaire_Id and af.Facture_Id="+ factureId +" and af.Ref_Ligne="+ rset.getString("Ref_Ligne");
					
					rset2 = stt2.executeQuery(reqRefCom);
					
					if (rset2.next()) {
						lf.setRefBL("R\u00E9f. Affaire : "+ rset2.getString("Num_Entier") +" / R\u00E9f. Com : "+ rset2.getString("Ref_Commande") +"\n");
					}
				}
				
				
				if (directe==0 && nbBons>1) {
					
					// ajout des rfrences BL
					
					String reqRefBL = "select b.Num_Entier, lbl.Quantite, b.Date_Liv from "+ base +".BON_LIVRAISON b, "+ base +".LIGNE_BON_LIVRAISON lbl, "+ base +".BON_LIVRAISON_FACTURE blf";
					reqRefBL += " where Numero>0 and blf.Bon_Id=b.Bon_Id and lbl.Statut='V' and blf.Facture_Id="+ factureId +" and b.Bon_Id=lbl.Bon_Id and lbl.Ref_Ligne="+ rset.getString("Ref_Ligne");

					rset2 = stt2.executeQuery(reqRefBL);

					while (rset2.next()) {
						lf.setRefBL(lf.refBL + formatDate.format(new Date(rset2.getLong("Date_Liv"))) +" BL N\u00B0 "+ rset2.getString("Num_Entier") +" : Qt = "+ numFormatQte.format(rset2.getDouble("Quantite")) +"\n");
					}

					rset2.close();
				}
				
				lignes.add(lf);
				
				
				String commentaireApres = rset.getString("Commentaire");				
				
				if (commentaireApres.length()>0) {
				
					String tabCom[] = commentaireApres.split("\n");
					
					for (int i=0; i<tabCom.length; i++) {
					
						LigneFacture lc = new LigneFacture();
						lc.setType('C');
						lc.setDesignation(tabCom[i]);
						lc.setSousTotal(montantBase);
						lignes.add(lc);
					}
				}
				
				
				if (rset.getString("Type_Ligne").equalsIgnoreCase("S")) {					
				
					// rcupration infos supplmentaires si existent
					psInfosSup.setString(1, lf.reference);
					ResultSet rsIS = psInfosSup.executeQuery();

					if (rsIS.next()) {

						lf.setCouleur(rsIS.getString("Couleur"));
						lf.setTaille(rsIS.getString("Taille"));

						if (rsIS.getString("Couleur").length()>0) {
							coul = true;
						}

						if (rsIS.getString("Taille").length()>0) {
							tail = true;
						}
						
						if (rsIS.getInt("Imp_Desc1_Facture")==1) {
							lf.setDetail_1(StringUtils.removeHtmlTags(rsIS.getString("Descrip_1")));
						}
						if (rsIS.getInt("Imp_Desc2_Facture")==1) {
							lf.setDetail_2(StringUtils.removeHtmlTags(rsIS.getString("Descrip_2")));
						}

						// gestion de la nomenclature
						if (rsIS.getInt("Imp_Nom_Facture")==1)	{

							psNomenclature.setString(1, lf.reference);
							ResultSet rsN = psNomenclature.executeQuery();

							while (rsN.next()) {
								LigneFacture ln = new LigneFacture();

								ln.setReference(rsN.getString("ArticleComp_Id"));
								ln.setDesignation(rsN.getString("Designation"));
								ln.setQuantite(rsN.getDouble("Quantite"));
								ln.setType('N');
								ln.setSousTotal(montantBase);			

								lignes.add(ln);
							}

							rsN.close();
						}
						
					}
					rsIS.close();								
				}
			}
			
			if (getNbLignes()==0 && fraisPort>0) {
				sansarticles = true;
				LigneFacture lf = new LigneFacture();
		        					
				lf.setReference("");
				lf.setDesignation("Frais De Livraison");
				lf.setQuantite(1);
				lf.setPrixUnitaire(fraisPort);
				lf.setRistourne(0);
				lf.setType('A');
				if (lf.ristourne!=0) rist = true;
				if (!lf.unite.equals("U")) unite = true;
				if (!lf.num_lot.equals("")) numLot = true;
				if (lf.nb_pieces != 0) nbPieces = true;
				if (lf.date_peremption != 0) datePeremption = true;
				
				lf.setMontant(lf.prixUnitaire * lf.quantite * (1-lf.ristourne/100));
				
				montantBase += lf.montant;
				
				lf.setSousTotal(montantBase);
				lignes.add(lf);
				
			}

			calc = new Calcul(s, Integer.parseInt(factureId), "Facture");

			ventilTVA = calc.getLignesTVA();

			mRemise = calc.getRemiseM();
			totalBase = (editionTTC)?calc.getTotalTTC():calc.getTotalHT();
			
			totalHTCommissionne = calc.getTotalHTCommissionne();
			
			totalTVA = calc.getTotalTVA();
			
			tRemiseFP = calc.getPRemise_FP();
			mRemiseFP = calc.getMRemise_FP();
			
			mRemiseHT = calc.getMTTCRemise();
			tauxTvaRemise = calc.getTTVARemise();
			montantTvaRemise = calc.getMTVARemise();
			mRemiseTTC = calc.getMTTCRemise();
			
			mCommissionHT = calc.getMHTCommission();
			tauxTvaCommission = calc.getTTVACommission();
			montantTvaCommission = calc.getMTVACommission();
			mCommissionTTC = calc.getMTTCCommission();
			
			mFraisPortHT = calc.getFraisPortHTHR();
			montantTvaFraisPort = calc.getFraisPortTVAHR();
			mFraisPortTTC = calc.getFraisPortTTCHR();
			
			mRemiseFraisPortHT = calc.getMHTRemise_FP();
			tauxTvaRemiseFraisPort = calc.getTTVARemise_FP();
			montantTvaRemiseFraisPort = calc.getMTVARemise_FP();
			mRemiseFraisPortTTC = calc.getMTTCRemise_FP();
			
			montantTTC = calc.getMontantTTC();
			mEscompte = calc.getEscompteM();
			netAPayer = calc.getMontantNet();
			
			
			montantBaseInd=montantBase*tauxInd;
			mRemiseInd=mRemise*tauxInd;
			fraisPortInd=fraisPort*tauxInd;
			totalBaseInd=totalBase*tauxInd;
			totalTVAInd=totalTVA*tauxInd;
			montantTTCInd=montantTTC*tauxInd;
			netAPayerInd=netAPayer*tauxInd;
			mEscompteInd=mEscompte*tauxInd;
		
			rset.close();
			stt.close();
			stt2.close();
			s.closeConnection(con, null);
			
		} catch(Exception e) {
			e.printStackTrace();
		}	
	}
	
	
	
	public double calcSousTotal(int derniereLigne) {
	
		if (derniereLigne<0) 
			return 0;
		return lignes.get(derniereLigne).sousTotal;		
	}	
	
	
	public int getNbLignes() {
		return lignes.size();
	}
	
	
	public int getNbEx() {	
		return nbex;
	}
	
	
} // fin DataFacture
