/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'une commande fournisseur standard
 */

package org.opensi.facturation.actions.documents.modeles;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;

import org.experlog.openeas.api.Session;
import org.opensi.facturation.DocumentUtils;
import org.opensi.util.calcul.Calcul;
import org.opensi.util.calcul.CalculVentilTVA;
import org.opensi.util.tools.StringUtils;


public class DataCommandeFournisseur {


	private DecimalFormatSymbols dfs2 = new DecimalFormatSymbols();
	
	private DecimalFormat numFormatQte = new DecimalFormat("0.##");


	// les lignes de la commande
	protected ArrayList<LigneCommandeFournisseur> lignes = new ArrayList<LigneCommandeFournisseur>(10);
	


	// coordonnes socit mettrice

	protected String raisonSociale;
	protected String adresse1;
	protected String adresse2;
	protected String adresse3;
	protected String codePostal;
	protected String ville;
	protected String tel;
	protected String fax;
	protected String email;
	protected String web;
	
	protected double capital;
	protected String typeSociete;
	protected String tvaIntra;
	protected String rcs;
	protected String siren;
	
	// coordonnes du destinataire
	
	protected String fournisseurId;
	protected String raisonSocialeDest;
	protected String adresseDest;
	protected String compAdresseDest;
	protected String adresseDest3;
	protected String codePostalDest;
	protected String villeDest;
	protected String paysDest;
	
	// coordonnes de livraison
	
	protected String raisonSocialeLiv;
	protected String adresseLiv;
	protected String compAdresseLiv;
	protected String adresseLiv3;
	protected String codePostalLiv;
	protected String villeLiv;
	protected String paysLiv;
	
	// infos commande
	
	protected String numeroCommande;
	protected String interlocuteur = "";
	protected String interTel = "";
	protected String interFax = "";
	protected String interMail = "";
	protected String responsable = "";
	protected String typeVente;
	protected String modeReglement;
	protected String comFin = "";
	protected String mentions = "";
	protected String codeClient;
	protected String typeAchat;
	
	protected long dateCommande;
	
	protected double tRemise = 0;
	protected double tEscompte = 0;
	protected double mRemise = 0;
	protected double mEscompte = 0;
	protected double acompte = 0;
	protected double fraisPort = 0;
	protected double montantBase = 0;
	protected double totalBase = 0;
	protected double totalTVA = 0;
	protected double montantTTC = 0;
	protected double netAPayer = 0;
	protected double tauxTvaPort = 0;
	
	protected boolean rist = false;
	protected boolean coul = false;
	protected boolean tail = false;
	protected boolean unite = false;
	protected boolean nbPieces = false;
	protected boolean logoAdr;
	protected String urlLogo = "";	

	protected boolean chiffre;

	private Calcul calc;

	protected HashMap<Integer, CalculVentilTVA> ventilTVA;
	
	
	
	public DataCommandeFournisseur(Session s, String commandeId, boolean chiffre) {	
		try {
		
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			
			String dossierId = s.getCookie().get("Dossier_Id");
			String base = s.getCookie().get("BaseDossier");
			
			this.urlLogo = s.getAppConfiguration().get("opensi.absdir") +"/logos/"+ dossierId +".jpg";
			this.chiffre = chiffre;
			
			ResultSet rset;
			
			dfs2.setDecimalSeparator('.');
			numFormatQte.setDecimalFormatSymbols(dfs2);
			
      
			// coordonnes de l'entreprise facturante
      
			String reqFacturante = "select s.Ville_RCS, s.Num_TVA_Intra, ts.Libelle as Type_Societe, s.Montant_Capital, s.Num_SIRET, s.Denomination, s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville, s.Telephone, s.Fax, s.Email, s.Site_Web";
			reqFacturante += " from "+ base +".SOCIETE s join "+ base +".TYPE_SOCIETE ts on s.Type_Societe=ts.Type_Societe_Id";
			rset = stt.executeQuery(reqFacturante);
			
			rset.next();
			
			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.tel = rset.getString("Telephone");
			this.fax = rset.getString("Fax");
			this.email = rset.getString("Email");
			this.web = rset.getString("Site_Web");
			
			this.siren = DocumentUtils.formatSiren(rset.getString("Num_SIRET"));
			this.typeSociete = rset.getString("Type_Societe");
			this.capital = rset.getDouble("Montant_Capital");
			this.tvaIntra = rset.getString("Num_TVA_Intra");
			this.rcs = rset.getString("Ville_RCS");		
			
			rset.close();
			
			
			// Elments de la commande
			
			String reqCommande = "select c.Num_Entier, c.Date_Commande, c.Escompte, c.Acompte, c.Remise, c.Frais_Port, c.Type_Achat, c.Taux_TVA_Port,";
			reqCommande += " c.Denomination_Liv, c.Adresse_1_Liv, c.Adresse_2_Liv, c.Adresse_3_Liv, c.Code_Postal_Liv, c.Ville_Liv, p1.Nom_FR as Pays_Liv,";
			reqCommande += " c.Denomination, c.Adresse_1, c.Adresse_2, c.Adresse_3, c.Code_Postal, c.Ville, p2.Nom_FR as Pays,";
			reqCommande += " c.Fournisseur_Id, c.Commentaires_Fin, c.Mentions from "+ base +".COMMANDE_FOURNISSEUR c, PAYS p1, PAYS p2";
			reqCommande += " where c.Code_Pays_Liv=p1.Code_Pays and c.Code_Pays=p2.Code_Pays and c.Commande_Id="+ commandeId;
			
			rset = stt.executeQuery(reqCommande);
			
			rset.next();
			
			this.numeroCommande = rset.getString("Num_Entier");
			this.dateCommande = rset.getLong("Date_Commande");
			this.tEscompte = rset.getDouble("Escompte");
			this.acompte = rset.getDouble("Acompte");
			this.tRemise = rset.getDouble("Remise");
			this.fraisPort = rset.getDouble("Frais_Port");			
			this.typeAchat = rset.getString("Type_Achat");
			
			this.raisonSocialeLiv = rset.getString("Denomination_Liv");
			this.adresseLiv = rset.getString("Adresse_1_Liv");	
			this.compAdresseLiv = rset.getString("Adresse_2_Liv");	
			this.adresseLiv3 = rset.getString("Adresse_3_Liv");	
			this.codePostalLiv = rset.getString("Code_Postal_Liv");	
			this.villeLiv = rset.getString("Ville_Liv");	
			this.paysLiv = rset.getString("Pays_Liv");
			
			this.raisonSocialeDest = rset.getString("Denomination");
			this.adresseDest = rset.getString("Adresse_1");
			this.compAdresseDest = rset.getString("Adresse_2");
			this.adresseDest3 = rset.getString("Adresse_3");
			this.codePostalDest = rset.getString("Code_Postal");
			this.villeDest = rset.getString("Ville");
			this.paysDest = rset.getString("Pays");
			
			this.tauxTvaPort = rset.getDouble("Taux_TVA_Port");
			
			this.fournisseurId = rset.getString("Fournisseur_Id");
			
			if (!rset.getString("Commentaires_Fin").equals("")) {
				this.comFin = StringUtils.removeHtmlTags("\n"+ rset.getString("Commentaires_Fin"));
			}
			this.mentions = "\n" + rset.getString("Mentions");
			
			rset.close();
			
			
			// commande

			String reqFacturee = "select c.Util_C, civ.Civ_Courte, c.Nom_Inter, c.Prenom_Inter, c.Tel_Inter, c.Fax_Inter, c.Email_Inter, i.Code_Client ";
			reqFacturee += "from "+ base +".COMMANDE_FOURNISSEUR c, "+ base +".FICHE_FOURNISSEUR i, CIVILITE civ ";
			reqFacturee += "where c.Fournisseur_Id=i.Fournisseur_Id and c.Civ_Inter=civ.Civ_Id and c.Commande_Id="+ commandeId;

			rset = stt.executeQuery(reqFacturee);

			rset.next();			
			
			this.codeClient = rset.getString("Code_Client");			

			int utilR = rset.getInt("Util_C");

			this.interlocuteur = rset.getString("Civ_Courte") +" "+ rset.getString("Nom_Inter").toUpperCase() +" "+ rset.getString("Prenom_Inter");
			this.interFax = rset.getString("Fax_Inter");
			this.interTel = rset.getString("Tel_Inter");
			this.interMail = rset.getString("Email_Inter");
			
			rset.close();

			// responsable entreprise

			String reqResp = "select Civ_Courte, Nom, Prenom from UTILISATEUR, CIVILITE where Civ_Id=Civ_Courte and Utilisateur_Id="+ utilR;

			rset = stt.executeQuery(reqResp);

			if (rset.next()) {
				this.responsable = rset.getString("Civ_Courte") +" "+ rset.getString("Nom").toUpperCase() +" "+ rset.getString("Prenom");
			}
			rset.close();			
			      
			
			// Paramtres dossier
      
			String reqCom = "select Logo_Adr from "+ base +".PARAM_DOSSIER";
			
			rset = stt.executeQuery(reqCom);
			
			rset.next();
			
			logoAdr = rset.getInt("Logo_Adr")==1;
			
			rset.close();
						
			
			// selection des articles appartenant  la commande
			
			String reqArticles = "select * from "+ base +".LIGNE_COMMANDE_FOURNISSEUR where Commande_Id="+ commandeId +" order by Rank";
			rset = stt.executeQuery(reqArticles);
			
			
			String reqInfosSup = "select coalesce(ca.Libelle,'') as Couleur, coalesce(ta.Libelle,'') as Taille, fa.Descrip_1, fa.Descrip_2, fa.Imp_Nom_BCF, fa.Imp_Desc1_BCF, fa.Imp_Desc2_BCF";
			reqInfosSup += " from "+ base +".FICHE_ARTICLE fa left join "+ base +".COULEUR_ARTICLE ca on fa.Couleur_Id=ca.Couleur_Id";
			reqInfosSup += " left join "+ base +".TAILLE_ARTICLE ta on fa.Taille_Id=ta.Taille_Id where fa.Article_Id=?";
			PreparedStatement psInfosSup = con.prepareStatement(reqInfosSup);
			
			
			String reqNomenclature = "select n.ArticleComp_Id, n.Quantite, f.Designation "
														 + "from "+ base +".FICHE_ARTICLE f,"+ base +".COMPOSANT_ARTICLE n where f.Article_Id=n.ArticleComp_Id and n.Article_Id=?";
			
			PreparedStatement psNomenclature = con.prepareStatement(reqNomenclature);
					
			
			while (rset.next()) {
				
				String commentaireAvant = rset.getString("Commentaire_Avant");				
				
				if (commentaireAvant.length()>0) {
				
					String tabCom[] = commentaireAvant.split("\n");
					
					for (int i=0; i<tabCom.length; i++) {
					
						LigneCommandeFournisseur la = new LigneCommandeFournisseur();
						la.setType('C');
						la.setDesignation(tabCom[i]);
						la.setSousTotal(montantBase);
						lignes.add(la);
					}
				}
				
				LigneCommandeFournisseur lc = new LigneCommandeFournisseur();		
				
				lc.setReference(rset.getString("Ref_Fournisseur"));
				lc.setDesignation(rset.getString("Designation"));
				lc.setQuantite(rset.getDouble("Quantite"));
				lc.setUnite(rset.getString("Unite"));
				lc.setNbPieces(rset.getInt("Nb_Pieces"));
				lc.setPrixUnitaire(rset.getDouble("Prix"));
				lc.setRistourne(rset.getDouble("Ristourne"));
				lc.setType('A');				
				
				if (lc.ristourne!=0) rist = true;
				if (!lc.unite.equals("U")) unite = true;
				if (lc.nb_pieces != 0) nbPieces = true;
				
				lc.setMontant(lc.prixUnitaire * lc.quantite * (1-lc.ristourne/100));
				
				montantBase += lc.montant;
				
				lc.setSousTotal(montantBase);
				
				lignes.add(lc);
				
				String commentaireApres = rset.getString("Commentaire");				
				
				if (commentaireApres.length()>0) {
				
					String tabCom[] = commentaireApres.split("\n");
					
					for (int i=0; i<tabCom.length; i++) {
					
						LigneCommandeFournisseur ld = new LigneCommandeFournisseur();
						ld.setType('C');
						ld.setDesignation(tabCom[i]);
						ld.setSousTotal(montantBase);
						lignes.add(ld);
					}
				}
				
				
				if (rset.getString("Type_Ligne").equalsIgnoreCase("S")) {					
				
					// rcupration infos supplmentaires si existent
					psInfosSup.setString(1, rset.getString("Reference"));
					ResultSet rsIS = psInfosSup.executeQuery();

					if (rsIS.next()) {

						lc.setCouleur(rsIS.getString("Couleur"));
						lc.setTaille(rsIS.getString("Taille"));

						if (rsIS.getString("Couleur").length()>0) {
							coul = true;
						}

						if (rsIS.getString("Taille").length()>0) {
							tail = true;
						}
						
						if (rsIS.getInt("Imp_Desc1_BCF")==1) {
							lc.setDetail_1(StringUtils.removeHtmlTags(rsIS.getString("Descrip_1")));
						}
						if (rsIS.getInt("Imp_Desc2_BCF")==1) {
							lc.setDetail_2(StringUtils.removeHtmlTags(rsIS.getString("Descrip_2")));
						}

						// gestion de la nomenclature
						if (rsIS.getInt("Imp_Nom_BCF")==1)	{

							psNomenclature.setString(1, rset.getString("Reference"));
							ResultSet rsN = psNomenclature.executeQuery();

							while (rsN.next()) {
								LigneCommandeFournisseur ln = new LigneCommandeFournisseur();

								ln.setReference(rsN.getString("ArticleComp_Id"));
								ln.setDesignation(rsN.getString("Designation"));
								ln.setQuantite(rsN.getDouble("Quantite"));
								ln.setType('N');
								ln.setSousTotal(montantBase);			

								lignes.add(ln);
							}

							rsN.close();
						}
						
					}
					rsIS.close();								
				}				
			}
			
			calc = new Calcul(s, Integer.parseInt(commandeId), "Commande_Fournisseur");

			ventilTVA = calc.getLignesTVA();

			mRemise = calc.getRemiseM();
			totalBase = calc.getTotalHT();
			
			totalTVA = calc.getTotalTVA();
			
			montantTTC = calc.getMontantTTC();
			mEscompte = calc.getEscompteM();
			netAPayer = calc.getMontantNet();
			
			
      rset.close();
			stt.close();			
			s.closeConnection(con, null);
			
		} catch(Exception e) {
			e.printStackTrace();
		}	
	}
	
	
	
	public double calcSousTotal(int derniereLigne) {
	
		if (derniereLigne<0) 
			return 0;
		else {
			return lignes.get(derniereLigne).sousTotal;
		}		
	}	
	
	
	public int getNbLignes() {
		return lignes.size();
	}
	
	
} // fin DataCommandeFournisseur
