/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'une commande client standard
 */

package org.opensi.facturation.actions.documents.modeles;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;

import org.experlog.openeas.api.Session;
import org.opensi.facturation.DocumentUtils;
import org.opensi.util.calcul.Calcul;
import org.opensi.util.calcul.CalculVentilTVA;
import org.opensi.util.tools.StringUtils;


public class DataCommandeClient {


	private DecimalFormatSymbols dfs2 = new DecimalFormatSymbols();
	
	private DecimalFormat numFormatQte = new DecimalFormat("0.##");



	// les lignes de la facture
	public ArrayList<LigneCommandeClient> lignes = new ArrayList<LigneCommandeClient>(10);
	


	// coordonnes socit mettrice

	public String raisonSociale;
	public String adresse1;
	public String adresse2;
	public String adresse3;
	public String codePostal;
	public String ville;
	public String tel;
	public String fax;
	public String email;
	public String web;
	
	public double capital;
	public String typeSociete;
	public String tvaIntra;
	public String rcs;
	public String siren;
	
	// coordonnes du destinataire
	
	public String clientId;
	public String denominationFact;
	public String adresse1Fact;
	public String adresse2Fact;
	public String adresse3Fact;
	public String codePostalFact;
	public String villeFact;
	public String paysFact;
	
	// coordonnes de livraison
	
	public String denominationLiv;
	public String adresse1Liv;
	public String adresse2Liv;
	public String adresse3Liv;
	public String codePostalLiv;
	public String villeLiv;
	public String paysLiv;
	
	public String numTvaClient = "";
	
	
	// infos commande
	
	public String refCommande;
	public String numCommande;
	public String responsable = "";
	public String interlocuteur = "";
	public String interTel = "";
	public String interFax = "";
	public String interMail = "";
	public String interlocuteurLiv = "";
	public String interTelLiv = "";
	public String interFaxLiv = "";
	public String interMailLiv = "";
	public String comFin = "";
	public String mentions = "";
	public String refAffaire;
	public boolean zoneUE=false;
	public String modeExpedition = "";
	
	public long dateCommande;
	public long delai;
	
	public double tRemise = 0;
	public double tEscompte = 0;
	public double mRemise = 0;
	public double mEscompte = 0;
	public double acompte = 0;
	public double fraisPort = 0;
	public double tRemiseFP = 0;
	public double mRemiseFP = 0;
	public double montantBase = 0;
	public double totalBase = 0;
	public double totalTVA = 0;
	public double montantTTC = 0;
	public double netAPayer = 0;
	public double tauxTvaPort = 0;
	public double totalHTCommissionne = 0;
	
	// dtails des totaux
	public double mRemiseHT = 0;
	public double tauxTvaRemise = 0;
	public double montantTvaRemise = 0;
	public double mRemiseTTC = 0;
	
	public double mCommissionHT = 0;
	public double tauxTvaCommission = 0;
	public double montantTvaCommission = 0;
	public double mCommissionTTC = 0;
	
	public double mFraisPortHT = 0;
	public double montantTvaFraisPort = 0;
	public double mFraisPortTTC = 0;
	
	public double mRemiseFraisPortHT = 0;
	public double tauxTvaRemiseFraisPort = 0;
	public double montantTvaRemiseFraisPort = 0;
	public double mRemiseFraisPortTTC = 0;
	
	public boolean editionTTC = false;
	public boolean rist = false;
	public boolean coul = false;
	public boolean tail = false;
	public boolean unite = false;
	public boolean commission = false;
	public boolean nbPieces = false;
	public boolean numLot = false;
	public boolean datePeremption = false;
	public boolean codeStats = false;
	public boolean logoAdr;
	public String urlLogo = "";
	public String urlAnnule = "";
	public boolean annule;
	
	public int nbex;
	
	public  boolean of = false;
	
	public String regimeTVA = "G";
	public boolean exonerationTVA = false;
			
	public String absdir;

	protected Calcul calc;

	protected HashMap<Integer, CalculVentilTVA> ventilTVA;
	
	
	
	public DataCommandeClient(Session s, String commandeId, boolean of, boolean editionInitiale) {	
		try {
			String tableCommande = (editionInitiale?"COMMANDE_CLIENT_INITIALE":"COMMANDE_CLIENT");
			String tableLigneCommande = (editionInitiale?"LIGNE_COMMANDE_CLIENT_INITIALE":"LIGNE_COMMANDE_CLIENT");
		
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			
			String dossierId = s.getCookie().get("Dossier_Id");
			String base = s.getCookie().get("BaseDossier");
			this.absdir = s.getAppConfiguration().get("opensi.absdir");
			
			this.urlLogo = s.getAppConfiguration().get("opensi.absdir") +"/logos/"+ dossierId +".jpg";
			this.urlAnnule = s.getAppConfiguration().get("opensi.absdir") +"/images/annule.jpg";
			this.of = of;
			
			ResultSet rset;
			
			dfs2.setDecimalSeparator('.');
			numFormatQte.setDecimalFormatSymbols(dfs2);
			
			
			// Paramtres dossier

			String reqLogo = "select Logo_Adr from "+ base +".PARAM_DOSSIER";
			rset = stt.executeQuery(reqLogo);
			rset.next();
			this.logoAdr = rset.getInt("Logo_Adr")==1;
			rset.close();
			
      
			// coordonnes de l'entreprise facturante
      
			String reqFacturante = "select s.Ville_RCS, s.Num_TVA_Intra, ts.Libelle as Type_Societe, s.Montant_Capital, s.Num_SIRET, s.Denomination, s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville, s.Telephone, s.Fax, s.Email, s.Site_Web";
			reqFacturante += " from "+ base +".SOCIETE s join "+ base +".TYPE_SOCIETE ts on s.Type_Societe=ts.Type_Societe_Id";
			rset = stt.executeQuery(reqFacturante);
			rset.next();
			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.tel = rset.getString("Telephone");
			this.fax = rset.getString("Fax");
			this.email = rset.getString("Email");
			this.web = rset.getString("Site_Web");
			this.siren = DocumentUtils.formatSiren(rset.getString("Num_SIRET"));
			this.typeSociete = rset.getString("Type_Societe");
			this.capital = rset.getDouble("Montant_Capital");
			this.tvaIntra = rset.getString("Num_TVA_Intra");
			this.rcs = rset.getString("Ville_RCS");		
			rset.close();
			
			
			String reqAcomptes = "select coalesce(sum(ac.Total_TTC),0) as Montant from "+ base +".ACOMPTE_CLIENT ac where ac.Commande_Id="+ commandeId;
			rset = stt.executeQuery(reqAcomptes);
			rset.next();
			this.acompte = rset.getDouble("Montant");
			rset.close();
			
			
			// Elments de la commande			
			
			String reqCommande = "select a.Num_Entier, cc.*, coalesce(cc.Client_Id,'') as ClientId,";
			reqCommande += " p1.Nom_FR as Pays, p2.Nom_FR as Pays_Liv, p2.Zone_UE,";
			reqCommande += " c1.Civ_Courte, c2.Civ_Courte as Civ_Courte_Liv,";
			reqCommande += " coalesce(cc.Util_R, '') as UtilR, coalesce(ml.Nom,'') as Mode_Exp";
			reqCommande += " from "+ base +".AFFAIRE a, PAYS p1, PAYS p2, CIVILITE c1, CIVILITE c2, "+ base +"."+ tableCommande +" cc left join "+ base +".MODE_LIVRAISON ml on cc.Mode_Expedition=ml.Mode_Liv_Id";
			reqCommande += " where cc.Code_Pays=p1.Code_Pays and cc.Code_Pays_Liv=p2.Code_Pays and cc.Affaire_Id=a.Affaire_Id and cc.Civ_Inter=c1.Civ_Id and cc.Civ_Inter_Liv=c2.Civ_Id and cc.Commande_Id="+ commandeId;
			
			rset = stt.executeQuery(reqCommande);
			rset.next();
			this.numCommande = rset.getString("Numero");
			this.refCommande = rset.getString("Ref_Commande");
			this.dateCommande = rset.getLong("Date_Commande");
			this.tEscompte = rset.getDouble("Escompte");
			this.tRemise = rset.getDouble("Remise");
			this.fraisPort = rset.getDouble("Frais_Port");
			this.delai = rset.getLong("Delai");
			this.tauxTvaPort = rset.getDouble("Taux_TVA_Port");
			this.regimeTVA = rset.getString("Regime_TVA");
			this.clientId = rset.getString("ClientId");
			this.modeExpedition = rset.getString("Mode_Exp");
			
			this.denominationFact = rset.getString("Denomination");
			this.adresse1Fact = rset.getString("Adresse_1");
			this.adresse2Fact = rset.getString("Adresse_2");
			this.adresse3Fact = rset.getString("Adresse_3");
			this.codePostalFact = rset.getString("Code_Postal");
			this.villeFact = rset.getString("Ville");
			this.paysFact = rset.getString("Pays");
			this.interTel = rset.getString("Tel_Inter");
			this.interFax = rset.getString("Fax_Inter");
			this.interMail = rset.getString("Email_Inter");
			this.denominationLiv = rset.getString("Denomination_Liv");
			this.adresse1Liv = rset.getString("Adresse_1_Liv");
			this.adresse2Liv = rset.getString("Adresse_2_Liv");
			this.adresse3Liv = rset.getString("Adresse_3_Liv");
			this.codePostalLiv = rset.getString("Code_Postal_Liv");
			this.villeLiv = rset.getString("Ville_Liv");
			this.paysLiv = rset.getString("Pays_Liv");
			this.interTelLiv = rset.getString("Tel_Inter_Liv");
			this.interFaxLiv = rset.getString("Fax_Inter_Liv");
			this.interMailLiv = rset.getString("Email_Inter_Liv");
			this.zoneUE = (rset.getInt("Zone_UE")==1);
			this.numTvaClient = rset.getString("Num_TVA_Intra");
			this.refAffaire = rset.getString("Num_Entier");
			
			if (!rset.getString("Commentaires_Fin").equals("")) {
				this.comFin = "\n"+ rset.getString("Commentaires_Fin");
			}
			this.mentions = "\n\n"+ rset.getString("Mentions");
			this.editionTTC = rset.getInt("Edition_TTC")==1;
			String utilR = rset.getString("UtilR");
			this.annule = rset.getString("Etat").equals("A");
			
			if (rset.getString("Nom_Inter").equals("")) {
				this.interlocuteur = "";
			}
			else {
				this.interlocuteur = rset.getString("Civ_Courte") +" "+ rset.getString("Nom_Inter").toUpperCase() + " " + rset.getString("Prenom_Inter");
			}
			
			if (rset.getString("Nom_Inter_Liv").equals("")) {
				this.interlocuteurLiv = "";
			}
			else {
				this.interlocuteurLiv = rset.getString("Civ_Courte_Liv") +" "+ rset.getString("Nom_Inter_Liv").toUpperCase() + " " + rset.getString("Prenom_Inter_Liv");
			}
			
			rset.close();	
			

			this.exonerationTVA = this.regimeTVA.equals("E") || (this.regimeTVA.equals("G") && !this.zoneUE);
			
			
			// responsable entreprise
			
			if (!utilR.equals("")) {
				String reqResp = "select c.Civ_Courte, u.Nom, u.Prenom from UTILISATEUR u, CIVILITE c where c.Civ_Id=u.Civilite and u.Utilisateur_Id="+ Integer.parseInt(utilR);
				rset = stt.executeQuery(reqResp);
				if (rset.next()) {
					this.responsable = rset.getString("Civ_Courte") +" "+ rset.getString("Nom").toUpperCase() +" "+ rset.getString("Prenom");
				}
				rset.close();
			}
			
			// selection des articles appartenant  la facture
			
			String doc = of?"OF":"Devis";
			
			String reqInfosSup = "select coalesce(ca.Libelle,'') as Couleur, coalesce(ta.Libelle,'') as Taille, fa.Descrip_1, fa.Descrip_2, fa.Imp_Nom_"+ doc +" as Imp_Nom, fa.Imp_Desc1_"+ doc +" as Imp_Desc1, fa.Imp_Desc2_"+ doc +" as Imp_Desc2";
			reqInfosSup += " from "+ base +".FICHE_ARTICLE fa left join "+ base +".COULEUR_ARTICLE ca on fa.Couleur_Id=ca.Couleur_Id";
			reqInfosSup += " left join "+ base +".TAILLE_ARTICLE ta on fa.Taille_Id=ta.Taille_Id where fa.Article_Id=?";
			PreparedStatement psInfosSup = con.prepareStatement(reqInfosSup);
			
			String reqNomenclature = "select n.ArticleComp_Id, n.Quantite, f.Designation";
			reqNomenclature += " from "+ base +".FICHE_ARTICLE f, "+ base +".COMPOSANT_ARTICLE n where f.Article_Id=n.ArticleComp_Id and n.Article_Id=?";
			PreparedStatement psNomenclature = con.prepareStatement(reqNomenclature);
			
			String reqArticles = "select lcc.Reference, lcc.Prix_Unitaire, lcc.Designation, lcc.Quantite, lcc.Ristourne, lcc.Type_Ligne, lcc.Code_TVA, lcc.Commentaire_Avant, lcc.Commentaire_Apres,";
			reqArticles += " lcc.Libelle, lcc.Unite, lcc.Nb_Pieces, lcc.Num_Lot, lcc.Date_Peremption, lcc.Code_Stats, lcc.Commission";
			reqArticles += " from "+ base +"."+ tableLigneCommande +" lcc where lcc.Commande_Id="+ commandeId;
			if (!editionInitiale) {
				reqArticles += " and lcc.Statut='V'";
			}
			reqArticles += " order by lcc.Rank";
			rset = stt.executeQuery(reqArticles);
			while (rset.next()) {
				
				String commentaireAvant = rset.getString("Commentaire_Avant");				
				if (commentaireAvant.length()>0) {
					String tabCom[] = commentaireAvant.split("\n");
					for (int i=0; i<tabCom.length; i++) {
						LigneCommandeClient lcc = new LigneCommandeClient();
						lcc.setType('C');
						lcc.setDesignation(tabCom[i]);
						lcc.setSousTotal(montantBase);
						lignes.add(lcc);
					}
				}
				
				LigneCommandeClient lc = new LigneCommandeClient();
				String libelle = rset.getString("Libelle");
				if (libelle.length()>0) { libelle = "\n"+ libelle; }			
				
				lc.setReference(rset.getString("Reference"));
				lc.setDesignation(rset.getString("Designation") + libelle);
				lc.setQuantite(rset.getDouble("Quantite"));
				lc.setPrixUnitaire(rset.getDouble("Prix_Unitaire"));
				lc.setRistourne(rset.getDouble("Ristourne"));
				lc.setCommission(rset.getDouble("Commission"));
				lc.setUnite(rset.getString("Unite"));
				lc.setNumLot(rset.getString("Num_Lot"));
				lc.setNbPieces(rset.getInt("Nb_Pieces"));
				lc.setDatePeremption(rset.getLong("Date_Peremption"));
				lc.setCodeStats(rset.getString("Code_Stats"));
				lc.setType('A');				
				lc.setMontant(lc.prixUnitaire * lc.quantite * (1-lc.ristourne/100) * (1-lc.commission/100));
				montantBase += lc.montant;
				lc.setSousTotal(montantBase);
				lignes.add(lc);
				
				if (lc.ristourne!=0) rist = true;
				if (lc.commission!=0) commission = true;
				if (!lc.unite.equals("U")) unite = true;
				if (!lc.num_lot.equals("")) numLot = true;
				if (lc.nb_pieces != 0) nbPieces = true;
				if (lc.date_peremption != 0) datePeremption = true;
				if (!lc.code_stats.equals("")) codeStats = true;
				
				String commentaireApres = rset.getString("Commentaire_Apres");
				if (commentaireApres.length()>0) {
					String tabCom[] = commentaireApres.split("\n");
					for (int i=0; i<tabCom.length; i++) {
						LigneCommandeClient lcc = new LigneCommandeClient();
						lcc.setType('C');
						lcc.setDesignation(tabCom[i]);
						lcc.setSousTotal(montantBase);
						lignes.add(lcc);
					}
				}
				
				
				if (rset.getString("Type_Ligne").equalsIgnoreCase("S")) {
					// rcupration infos supplmentaires si existent
					psInfosSup.setString(1, lc.reference);
					ResultSet rsIS = psInfosSup.executeQuery();
					if (rsIS.next()) {
						lc.setCouleur(rsIS.getString("Couleur"));
						lc.setTaille(rsIS.getString("Taille"));

						if (rsIS.getString("Couleur").length()>0) { coul = true; }
						if (rsIS.getString("Taille").length()>0) { tail = true; }
						
						if (rsIS.getInt("Imp_Desc1")==1) {
							lc.setDetail_1(StringUtils.removeHtmlTags(rsIS.getString("Descrip_1")));
						}
						if (rsIS.getInt("Imp_Desc2")==1) {
							lc.setDetail_2(StringUtils.removeHtmlTags(rsIS.getString("Descrip_2")));
						}

						// gestion de la nomenclature
						if (rsIS.getInt("Imp_Nom")==1)	{
							psNomenclature.setString(1, lc.reference);
							ResultSet rsN = psNomenclature.executeQuery();
							while (rsN.next()) {
								LigneCommandeClient ln = new LigneCommandeClient();
								ln.setReference(rsN.getString("ArticleComp_Id"));
								ln.setDesignation(rsN.getString("Designation"));
								ln.setQuantite(rsN.getDouble("Quantite"));
								ln.setType('N');
								ln.setSousTotal(montantBase);			
								lignes.add(ln);
							}
							rsN.close();
						}
					}
					rsIS.close();								
				}
			}
			
			
			calc = new Calcul(s, Integer.parseInt(commandeId), "Commande");

			ventilTVA = calc.getLignesTVA();

			mRemise = calc.getRemiseM();
			totalBase = (editionTTC)?calc.getTotalTTC():calc.getTotalHT();
			
			totalHTCommissionne = calc.getTotalHTCommissionne();

			totalTVA = calc.getTotalTVA();
			
			tRemiseFP = calc.getPRemise_FP();
			mRemiseFP = calc.getMRemise_FP();
			
			mRemiseHT = calc.getMTTCRemise();
			tauxTvaRemise = calc.getTTVARemise();
			montantTvaRemise = calc.getMTVARemise();
			mRemiseTTC = calc.getMTTCRemise();
			
			mCommissionHT = calc.getMHTCommission();
			tauxTvaCommission = calc.getTTVACommission();
			montantTvaCommission = calc.getMTVACommission();
			mCommissionTTC = calc.getMTTCCommission();
			
			mFraisPortHT = calc.getFraisPortHTHR();
			montantTvaFraisPort = calc.getFraisPortTVAHR();
			mFraisPortTTC = calc.getFraisPortTTCHR();
			
			mRemiseFraisPortHT = calc.getMHTRemise_FP();
			tauxTvaRemiseFraisPort = calc.getTTVARemise_FP();
			montantTvaRemiseFraisPort = calc.getMTVARemise_FP();
			mRemiseFraisPortTTC = calc.getMTTCRemise_FP();
			
			montantTTC = calc.getMontantTTC();
			mEscompte = calc.getEscompteM();
			netAPayer = calc.getMontantNet();
			
			rset.close();
			stt.close();			
			s.closeConnection(con, null);
			
		} catch(Exception e) {
			e.printStackTrace();
		}	
	}
	
	
	
	public double calcSousTotal(int derniereLigne) {
	
		if (derniereLigne<0) 
			return 0;
		else {
			return lignes.get(derniereLigne).sousTotal;
		}		
	}	
	
	
	public int getNbLignes() {
		return lignes.size();
	}
	
	
	public int getNbEx() {	
		return nbex;
	}
	
	
} // fin DataCommandeClient
