/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un courrier pour les clients concerns
 */

package org.opensi.facturation.actions.documents.modeles;


import java.awt.Color;
import java.io.IOException;
import java.text.DecimalFormat;

import org.opensi.util.pdf.MultiPagesDocument;
import org.opensi.util.pdf.TableBuilder;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;


public class CourrierLotStd extends MultiPagesDocument {


	private static final Font fontAdrSociete = new Font(Font.HELVETICA, 12, Font.BOLD);
	private static final Font fontObjet = new Font(Font.HELVETICA , 11, Font.BOLD);
	private static final Font fontAlerte = new Font(Font.HELVETICA , 11, Font.BOLD+Font.ITALIC);
	private static final Font fontLine = new Font(Font.HELVETICA , 10, Font.NORMAL);
	private static final Font fontLineGras = new Font(Font.HELVETICA , 10, Font.BOLD);	
	private static final Font fontLegale = new Font(Font.HELVETICA , 8, Font.NORMAL);
	private static final Font fontWeb = new Font(Font.HELVETICA, 10, Font.ITALIC);
	
	private DecimalFormat numFormatCap = new DecimalFormat("0.##");
	private DataCourrierLot id;	   // les donnes dynamiques du courrier
	private boolean multi = false;
	private Image logo;
	private int numPage;

	public CourrierLotStd(String tempdir, DataCourrierLot id, int numPage) throws Exception {

		super(tempdir);	

		this.id = id;
		this.numPage = numPage;

		int hauteurMax = 80;

		try {
			logo = Image.getInstance(id.urlLogo);
			if (logo.getDpiX()!=0 && logo.getDpiY()!=0) {
		      	logo.scaleAbsolute(logo.getPlainWidth() * 72 / logo.getDpiX(), logo.getPlainHeight() * 72 / logo.getDpiY());
			}
		    if (logo.getPlainHeight()>hauteurMax) {
				logo.scaleAbsolute(logo.getPlainWidth() / (logo.getPlainHeight() / hauteurMax), hauteurMax);
			}
		}
		catch (IOException e) {
			logo = null;
		}

	}



	/* implmentation des fonctions de MultiPagesDocument */

	public PdfPTable firstHeader() throws DocumentException {

		TableBuilder tb = new TableBuilder();

		tb.add(makeSpace(15));
		tb.add(makeEntete());
		tb.add(makeSpace(15));

		return tb.getTable();	
	}


	public PdfPTable middleHeader(int lastLine) throws DocumentException {

		TableBuilder tb = new TableBuilder();
		tb.add(makeSpace(40));

		return tb.getTable();
	}


	public PdfPTable lastFooter() throws DocumentException {

		TableBuilder tb = new TableBuilder();
		tb.add(makeSpace(15));
		tb.add(makeInfosLegales());

		return tb.getTable();
	}	


	public PdfPTable middleFooter(int nbLinesPage, int lastLine) throws DocumentException {

		TableBuilder tb = new TableBuilder();
		tb.add(lastFooter());

		return tb.getTable();		
	}


	public PdfPTable bodyLine(int numLine) throws DocumentException {
		switch (this.numPage) {
			case 1: return makeCourrier1();
			default:
			case 2: return makeCourrier2();
		}
	}


	public PdfPTable emptyLine(float emptyHeight) throws DocumentException {

		PdfPTable pptSpace = new PdfPTable(1);
		pptSpace.setWidthPercentage(100);

		PdfPCell cell = new PdfPCell(pptSpace.getDefaultCell());
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPaddingBottom(0);
		cell.setPaddingTop(0);
		cell.setFixedHeight(emptyHeight);		
		cell.setPhrase(new Phrase(""));		
		pptSpace.addCell(cell);

		return pptSpace;
	}


	public int nbLines() {
		return 1;
	}


	public int nbEx() {

		return (multi?id.getNbEx():1);
	}


	public Image imageFond() {
		return null;
	}



	/* mthodes internes */

	private PdfPTable makeSpace(int space) {

		PdfPTable pptSpace = new PdfPTable(1);
		PdfPCell cell = new PdfPCell(pptSpace.getDefaultCell());
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setFixedHeight(space);
		cell.setPhrase(new Phrase(""));

		pptSpace.addCell(cell);

		return pptSpace;
	}


	private PdfPTable makeEntete() throws DocumentException {

		PdfPTable pptEntete = new PdfPTable(1);
		pptEntete.setWidthPercentage(100);

		PdfPCell cellSociete = new PdfPCell(makeInfosSociete());
		cellSociete.setBorder(PdfPCell.NO_BORDER);
		pptEntete.addCell(cellSociete);		

		return pptEntete;		
	}


	private PdfPTable makeInfosSociete() {

		PdfPTable pptInfos = new PdfPTable(1);
		pptInfos.setWidthPercentage(100);

		PdfPCell cell;
		

		if (logo != null) {
			cell = new PdfPCell(logo, false);
			cell.setPaddingLeft(40);
			cell.setBorder(PdfPCell.NO_BORDER);
			cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
			cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

			pptInfos.addCell(cell);
		}
		else {
			cell = new PdfPCell(pptInfos.getDefaultCell());
			cell.setPaddingLeft(40);
			cell.setBorder(PdfPCell.NO_BORDER);
			cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
			cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		}
		cell.setImage(null);
		
		cell.setPhrase(new Phrase(id.raisonSociale, fontAdrSociete));		
		pptInfos.addCell(cell);
		cell.setPhrase(new Phrase(id.adresse1, fontAdrSociete));		
		pptInfos.addCell(cell);
		if (!id.adresse2.equals("")) {
			cell.setPhrase(new Phrase(id.adresse2, fontAdrSociete));
			pptInfos.addCell(cell);
		}
		if (!id.adresse3.equals("")) {
			cell.setPhrase(new Phrase(id.adresse3, fontAdrSociete));
			pptInfos.addCell(cell);
		}
		cell.setPhrase(new Phrase(id.codePostal+" "+id.ville, fontAdrSociete));		
		pptInfos.addCell(cell);

		String telfax = "";

		if (id.tel.length()>0) {
			telfax = "T\u00E9l: "+ id.tel;
			if (id.fax.length()>0) {
				telfax += " - Fax: "+ id.fax;
			}
		}
		else if (id.fax.length()>0) {
			telfax = "Fax: "+ id.fax;
		}		

		if (telfax.length()>0) {
			cell.setPhrase(new Phrase(telfax, fontAdrSociete));		
			pptInfos.addCell(cell);
		}

		if (!id.email.equals("")) {
			cell.setPhrase(new Phrase("e-mail: "+ id.email, fontAdrSociete));		
			pptInfos.addCell(cell);
		}
		if (!id.web.equals("")) {
			cell.setPhrase(new Phrase(id.web, fontWeb));		
			pptInfos.addCell(cell);
		}
		
		cell.setPhrase(new Phrase(""));		
		pptInfos.addCell(cell);

		return pptInfos;	
	}
	


	private PdfPTable makeCourrier1() throws DocumentException {

		PdfPTable pptCourrier = new PdfPTable(1);
		pptCourrier.setWidthPercentage(100);
		
		PdfPTable pptCadreClient = new PdfPTable(2);
		pptCadreClient.setWidthPercentage(100);
		int[] widths = {50,50};
		pptCadreClient.setWidths(widths);		
		PdfPCell cellClient = new PdfPCell(pptCadreClient.getDefaultCell());
		cellClient.setPaddingLeft(0);
		cellClient.setPaddingRight(0);
		cellClient.setBorder(PdfPCell.NO_BORDER);
		cellClient.setPhrase(new Phrase("Soci\u00E9t\u00E9 : " + id.societeClient, fontLine));
		pptCadreClient.addCell(cellClient);
		cellClient.setPhrase(new Phrase("A l'attention de : " + id.interlocuteurClient, fontLine));
		pptCadreClient.addCell(cellClient);
		cellClient.setPhrase(new Phrase("", fontLine));
		cellClient.setFixedHeight(5);
		cellClient.setColspan(2);
		pptCadreClient.addCell(cellClient);	
		cellClient.setColspan(1);
		cellClient.setMinimumHeight(0);
		cellClient.setPhrase(new Phrase("Fax : " + id.faxClient, fontLine));
		pptCadreClient.addCell(cellClient);
		cellClient.setPhrase(new Phrase("Date : " + id.dateCourrier, fontLine));
		pptCadreClient.addCell(cellClient);
		cellClient.setPhrase(new Phrase("", fontLine));
		cellClient.setFixedHeight(5);
		cellClient.setColspan(2);
		pptCadreClient.addCell(cellClient);	
		cellClient.setColspan(1);
		cellClient.setMinimumHeight(0);
		cellClient.setPhrase(new Phrase("T\u00E9l : " + id.telClient, fontLine));
		pptCadreClient.addCell(cellClient);
		cellClient.setPhrase(new Phrase("Nbre de pages : 2", fontLine));
		pptCadreClient.addCell(cellClient);
		cellClient.setPhrase(new Phrase("", fontLine));
		cellClient.setFixedHeight(5);
		cellClient.setColspan(2);
		pptCadreClient.addCell(cellClient);	
		PdfPCell cell = new PdfPCell(pptCadreClient);
		cell.setPaddingLeft(40);
		cell.setPaddingRight(40);
		pptCourrier.addCell(cell);

		cell = new PdfPCell(pptCourrier.getDefaultCell());
		cell.setPaddingLeft(40);
		cell.setPaddingRight(40);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPhrase(new Phrase("", fontLine));
		cell.setFixedHeight(10);
		pptCourrier.addCell(cell);
		cell.setMinimumHeight(0);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setPhrase(new Phrase("OBJET : NOTIFICATION DE RAPPEL DE PRODUIT", fontObjet));
		pptCourrier.addCell(cell);
		cell.setPhrase(new Phrase("ACTION IMMEDIATE NECESSAIRE", fontObjet));
		pptCourrier.addCell(cell);
		cell.setPhrase(new Phrase("", fontLine));
		cell.setFixedHeight(10);
		pptCourrier.addCell(cell);
		cell.setMinimumHeight(0);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cell.setPhrase(new Phrase("Madame, Monsieur,", fontLine));
		pptCourrier.addCell(cell);
		cell.setPhrase(new Phrase("", fontLine));
		cell.setFixedHeight(15);
		pptCourrier.addCell(cell);
		cell.setMinimumHeight(0);
		cell.setPhrase(new Phrase("Dans le cadre de nos proc\u00E9dures de contr\u00F4le nous avons identifi\u00E9 une anomalie qui affecte certains de nos produits.", fontLine));
		pptCourrier.addCell(cell);
		cell.setPhrase(new Phrase("", fontLine));
		cell.setFixedHeight(10);
		pptCourrier.addCell(cell);
		
		PdfPTable pptCadreAnomalies = new PdfPTable(5);
		pptCadreAnomalies.setWidthPercentage(100);
		int[] widthsAnomalies = {22,18,20,32,8};
		pptCadreAnomalies.setWidths(widthsAnomalies);		
		PdfPCell cellAnomalie = new PdfPCell(pptCadreAnomalies.getDefaultCell());
		cellAnomalie.setPaddingLeft(5);
		cellAnomalie.setPaddingRight(5);
		cellAnomalie.setBackgroundColor(new Color(175,175,175));
		cellAnomalie.setMinimumHeight(15);
		cellAnomalie.setPhrase(new Phrase("REFERENCE DOC", fontLine));
		pptCadreAnomalies.addCell(cellAnomalie);
		cellAnomalie.setPhrase(new Phrase("N\u00B0 LOT", fontLine));
		pptCadreAnomalies.addCell(cellAnomalie);
		cellAnomalie.setPhrase(new Phrase("REF ARTICLE", fontLine));
		pptCadreAnomalies.addCell(cellAnomalie);
		cellAnomalie.setPhrase(new Phrase("DESIGNATION", fontLine));
		pptCadreAnomalies.addCell(cellAnomalie);
		cellAnomalie.setPhrase(new Phrase("QTE", fontLine));
		pptCadreAnomalies.addCell(cellAnomalie);
		cellAnomalie.setBackgroundColor(Color.WHITE);
		int nbElementsATraiter = id.getNbLignes();
		// pour ne pas planter la mise en page, on a convenu de lister au maximum 10 lignes de num lot bloqus
		if (nbElementsATraiter>10) nbElementsATraiter=10;
		for (int i=0; i<nbElementsATraiter; i++) {
			LigneCourrierLot lcl = id.lignes.get(i);
			cellAnomalie.setPhrase(new Phrase(lcl.reference, fontLine));
			pptCadreAnomalies.addCell(cellAnomalie);
			cellAnomalie.setPhrase(new Phrase(lcl.numLot, fontLine));
			pptCadreAnomalies.addCell(cellAnomalie);
			cellAnomalie.setPhrase(new Phrase(lcl.refArticle, fontLine));
			pptCadreAnomalies.addCell(cellAnomalie);
			cellAnomalie.setPhrase(new Phrase(lcl.designationArticle, fontLine));
			pptCadreAnomalies.addCell(cellAnomalie);
			cellAnomalie.setPhrase(new Phrase(numFormatCap.format(lcl.qte), fontLine));
			pptCadreAnomalies.addCell(cellAnomalie);
		}
		cell = new PdfPCell(pptCadreAnomalies);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPaddingLeft(40);
		cell.setPaddingRight(40);
		pptCourrier.addCell(cell);
		
		cell = new PdfPCell(pptCourrier.getDefaultCell());
		cell.setPaddingLeft(40);
		cell.setPaddingRight(40);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPhrase(new Phrase("", fontLine));
		cell.setFixedHeight(10);
		pptCourrier.addCell(cell);		
		cell.setMinimumHeight(0);
		cell.setPhrase(new Phrase("Nos dossiers d'exp\u00E9dition indiquent que votre \u00E9tablissement a re\u00E7u l'un des produits figurant sur la liste.", fontLine));
		pptCourrier.addCell(cell);
		cell.setPhrase(new Phrase("", fontLine));
		cell.setFixedHeight(10);
		pptCourrier.addCell(cell);		
		cell.setMinimumHeight(0);
		cell.setPhrase(new Phrase("Veuillez faire v\u00E9rifier par vos services concern\u00E9s si vous avez en stock l'un des produits sus-mentionn\u00E9s.", fontLine));
		pptCourrier.addCell(cell);
		cell.setPhrase(new Phrase("", fontLine));
		cell.setFixedHeight(10);
		pptCourrier.addCell(cell);
		cell.setMinimumHeight(0);
		Chunk c1 = new Chunk("Si vous avez ces produits en stock, ", fontLine);
		Chunk c2 = new Chunk("veuillez isoler les lots concern\u00E9s afin qu'ils ne soient plus utilis\u00E9s, et retourner le formulaire de v\u00E9rification ci-joint.", fontLineGras);
		Phrase p1 = new Phrase();
		p1.add(c1); p1.add(c2);
		cell.setPhrase(p1);
		pptCourrier.addCell(cell);
		cell.setPhrase(new Phrase("", fontLine));
		cell.setFixedHeight(10);
		pptCourrier.addCell(cell);
		cell.setMinimumHeight(0);
		cell.setPhrase(new Phrase("Veuillez remplir ces formulaires, m\u00EAme si vous n'\u00EAtes en possession d'aucun des produits.", fontLine));
		pptCourrier.addCell(cell);
		cell.setPhrase(new Phrase("", fontLine));
		cell.setFixedHeight(10);
		pptCourrier.addCell(cell);
		cell.setMinimumHeight(0);
		cell.setPhrase(new Phrase("Veuillez inscrire \u00E0 l'ext\u00E9rieur du conditionnement de retour des produits, la mention RETOUR ALE.", fontLine));
		pptCourrier.addCell(cell);
		cell.setPhrase(new Phrase("", fontLine));
		cell.setFixedHeight(10);
		pptCourrier.addCell(cell);
		cell.setMinimumHeight(0);
		cell.setPhrase(new Phrase("Les produits retourn\u00E9s feront l'objet d'un avoir commercial.", fontLine));
		pptCourrier.addCell(cell);
		cell.setPhrase(new Phrase("", fontLine));
		cell.setFixedHeight(10);
		pptCourrier.addCell(cell);
		cell.setMinimumHeight(0);
		cell.setPhrase(new Phrase("Nous vous sommes reconnaissants de comprendre que nous ne prenons ces mesures que pour assurer la s\u00E9curit\u00E9 des consommateurs et la satisfaction de nos clients.", fontLine));
		pptCourrier.addCell(cell);		
		cell.setPhrase(new Phrase("", fontLine));
		cell.setFixedHeight(10);
		pptCourrier.addCell(cell);		
		
		PdfPTable pptCadreSignature = new PdfPTable(2);
		pptCadreSignature.setWidthPercentage(100);
		int[] widthsSignature = {50,50};
		pptCadreSignature.setWidths(widthsSignature);		
		PdfPCell cellSignature = new PdfPCell(pptCadreSignature.getDefaultCell());
		cellSignature.setPaddingLeft(0);
		cellSignature.setPaddingRight(0);
		cellSignature.setBorder(PdfPCell.NO_BORDER);
		cellSignature.setPhrase(new Phrase("La direction", fontLine));
		pptCadreSignature.addCell(cellSignature);
		cellSignature.setPhrase(new Phrase("Avec nos sinc\u00E8res salutations,", fontLine));
		pptCadreSignature.addCell(cellSignature);
		cell = new PdfPCell(pptCadreSignature);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPaddingLeft(40);
		cell.setPaddingRight(40);
		pptCourrier.addCell(cell);
		
		cell = new PdfPCell(pptCourrier.getDefaultCell());
		cell.setPaddingLeft(40);
		cell.setPaddingRight(40);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPhrase(new Phrase("", fontLine));
		cell.setFixedHeight(10);
		pptCourrier.addCell(cell);		
		cell.setMinimumHeight(0);
		cell.setPhrase(new Phrase("Pi\u00E8ces jointes : 1 Formulaire de v\u00E9rification", fontLineGras));
		pptCourrier.addCell(cell);
		
		return pptCourrier;	
	}
	
	
	private PdfPTable makeCourrier2() throws DocumentException {
		PdfPTable pptCourrier = new PdfPTable(1);
		pptCourrier.setWidthPercentage(100);
		
		PdfPCell cell = new PdfPCell(pptCourrier.getDefaultCell());
		cell.setPaddingLeft(40);
		cell.setPaddingRight(40);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setPhrase(new Phrase("MEME SI VOUS N'AVEZ PAS DE PRODUITS EN STOCK,", fontAlerte));
		pptCourrier.addCell(cell);
		if (!id.fax.equals("")) {
			cell.setPhrase(new Phrase("VEUILLEZ COMPLETER CE FORMULAIRE ET LE RENVOYER PAR TELECOPIE", fontAlerte));
			pptCourrier.addCell(cell);
			cell.setPhrase(new Phrase("AU : "+ id.fax, fontAlerte));
			pptCourrier.addCell(cell);
		} else {
			cell.setPhrase(new Phrase("VEUILLEZ COMPLETER CE FORMULAIRE ET LE RENVOYER PAR COURRIER", fontAlerte));
			pptCourrier.addCell(cell);
		}
		cell.setPhrase(new Phrase("", fontLine));
		cell.setFixedHeight(20);
		pptCourrier.addCell(cell);		
		cell.setMinimumHeight(0);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		Chunk c1 = new Chunk("SOCIETE : ", fontObjet);
		Chunk c2 = new Chunk("" + id.societeClient, fontLine);
		Phrase p1 = new Phrase();
		p1.add(c1); p1.add(c2);
		cell.setPhrase(p1);
		pptCourrier.addCell(cell);
		Chunk c3 = new Chunk("Adresse : ", fontObjet);
		Chunk c4 = new Chunk("" + id.adresse1Client + (id.adresse2Client.equals("")?"":" "+id.adresse2Client) + (id.adresse3Client.equals("")?"":" "+id.adresse3Client)+ " - "+id.codePostalClient+" "+id.villeClient+" - "+id.paysClient, fontLine);
		Phrase p2 = new Phrase();
		p2.add(c3); p2.add(c4);
		cell.setPhrase(p2);
		pptCourrier.addCell(cell);
		cell.setPhrase(new Phrase("", fontLine));
		cell.setFixedHeight(15);
		pptCourrier.addCell(cell);		
		cell.setMinimumHeight(0);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setPhrase(new Phrase("FORMULAIRE DE VERIFICATION", fontObjet));
		pptCourrier.addCell(cell);
		cell.setPhrase(new Phrase("RAPPEL DE PRODUIT VOLONTAIRE", fontObjet));
		pptCourrier.addCell(cell);
		cell.setPhrase(new Phrase("", fontLine));
		cell.setFixedHeight(15);
		pptCourrier.addCell(cell);
		cell.setMinimumHeight(0);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cell.setPhrase(new Phrase("JE RECONNAIS AVOIR RE\u00C7U DU CENTRE DE NEGOCE ALIMENTAIRE (CNA) UNE NOTIFICATION DE RAPPEL DE PRODUIT.", fontLine));
		pptCourrier.addCell(cell);
		cell.setPhrase(new Phrase("", fontLine));
		cell.setFixedHeight(10);
		pptCourrier.addCell(cell);
		cell.setMinimumHeight(0);
		cell.setPhrase(new Phrase("J'ai v\u00E9rifi\u00E9 que mes stocks ont \u00E9t\u00E9 contr\u00F4l\u00E9s :", fontLine));
		pptCourrier.addCell(cell);
		cell.setPhrase(new Phrase("", fontLine));
		cell.setFixedHeight(10);
		pptCourrier.addCell(cell);
		
		PdfPTable pptPuces = new PdfPTable(2);
		pptPuces.setWidthPercentage(100);
		int[] widthsPuces = {5,95};
		pptPuces.setWidths(widthsPuces);
		
		PdfPCell cellPuce = new PdfPCell(pptPuces.getDefaultCell());
		Chunk c5;
		try {
			c5 = new Chunk(Image.getInstance(id.urlCaseACocher), 0, 0);
		} catch (IOException e) {
			c5 = new Chunk("");
		}
		Phrase p3 = new Phrase();
		p3.add(c5);
		cellPuce.setBorder(PdfPCell.NO_BORDER);
		cellPuce.setPhrase(p3);
		pptPuces.addCell(cellPuce);
		cellPuce.setPhrase(new Phrase("NOUS N'AVONS AUCUN PRODUIT DE CE TYPE EN STOCK", fontLine));
		pptPuces.addCell(cellPuce);
		cellPuce.setColspan(2);
		cellPuce.setPhrase(new Phrase("", fontLine));
		cellPuce.setFixedHeight(10);
		pptPuces.addCell(cellPuce);
		cellPuce.setColspan(1);
		cellPuce.setMinimumHeight(0);
		cellPuce.setPhrase(p3);
		pptPuces.addCell(cellPuce);
		cellPuce.setPhrase(new Phrase("NOUS AVONS CE PRODUIT EN STOCK ET NOUS AVONS INDIQUE CI-DESSOUS LA QUANTITE DE PRODUITS RETOURNEE", fontLine));
		pptPuces.addCell(cellPuce);
		cellPuce.setColspan(2);
		cellPuce.setPhrase(new Phrase("", fontLine));
		cellPuce.setFixedHeight(10);
		pptPuces.addCell(cellPuce);
		cellPuce.setColspan(1);
		cellPuce.setMinimumHeight(0);
		cellPuce.setPhrase(p3);
		pptPuces.addCell(cellPuce);
		cellPuce.setPhrase(new Phrase("NOUS ATTESTONS PAR LA PRESENTE AVOIR PROCEDE A LA DESTRUCTION DES PRODUITS SUIVANTS", fontLine));
		pptPuces.addCell(cellPuce);
		cell = new PdfPCell(pptPuces);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPaddingLeft(40);
		cell.setPaddingRight(40);
		pptCourrier.addCell(cell);		
		cell = new PdfPCell(pptCourrier.getDefaultCell());
		cell.setPaddingLeft(40);
		cell.setPaddingRight(40);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPhrase(new Phrase("", fontLine));
		cell.setFixedHeight(10);
		pptCourrier.addCell(cell);
		
		PdfPTable pptTableau = new PdfPTable(4);
		pptTableau.setWidthPercentage(100);
		int[] widthsTableau = {25,25,25,25};
		pptTableau.setWidths(widthsTableau);
		PdfPCell cellTableau = new PdfPCell(pptTableau.getDefaultCell());
		cellTableau.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellTableau.setPhrase(new Phrase("DENOMINATION", fontObjet));
		pptTableau.addCell(cellTableau);
		cellTableau.setPhrase(new Phrase("QTE DE PIECES", fontObjet));
		pptTableau.addCell(cellTableau);
		cellTableau.setPhrase(new Phrase("N\u00B0 LOT", fontObjet));
		pptTableau.addCell(cellTableau);
		cellTableau.setPhrase(new Phrase("DLC", fontObjet));
		pptTableau.addCell(cellTableau);
		cellTableau.setPhrase(new Phrase("", fontLine));
		cellTableau.setFixedHeight(15);
		for (int i=0; i<10; i++) {
			for (int j=0; j<widthsTableau.length; j++) {
				pptTableau.addCell(cellTableau);
			}
		}
		cell = new PdfPCell(pptTableau);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPaddingLeft(40);
		cell.setPaddingRight(40);
		pptCourrier.addCell(cell);
		
		cell = new PdfPCell(pptCourrier.getDefaultCell());
		cell.setPaddingLeft(40);
		cell.setPaddingRight(40);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPhrase(new Phrase("", fontLine));
		cell.setFixedHeight(15);
		pptCourrier.addCell(cell);
		
		PdfPTable pptFormulaire = new PdfPTable(4);
		pptFormulaire.setWidthPercentage(100);
		int[] widthsFormulaire1 = {17,28,5,50};
		pptFormulaire.setWidths(widthsFormulaire1);
		PdfPCell cellFormulaire = new PdfPCell(pptFormulaire.getDefaultCell());
		cellFormulaire.setBorder(PdfPCell.NO_BORDER);
		cellFormulaire.setPhrase(new Phrase("NOM et TITRE :", fontLine));
		pptFormulaire.addCell(cellFormulaire);
		cellFormulaire.setBorder(PdfPCell.BOTTOM);
		cellFormulaire.setPhrase(new Phrase("", fontLine));
		pptFormulaire.addCell(cellFormulaire);
		cellFormulaire.setBorder(PdfPCell.NO_BORDER);
		pptFormulaire.addCell(cellFormulaire);
		cellFormulaire.setPhrase(new Phrase("SIGNATURE DE LA PERSONNE AUTORISEE", fontLine));
		cellFormulaire.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		pptFormulaire.addCell(cellFormulaire);
		cell = new PdfPCell(pptFormulaire);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPaddingLeft(40);
		cell.setPaddingRight(40);
		pptCourrier.addCell(cell);
		
		pptFormulaire = new PdfPTable(3);
		pptFormulaire.setWidthPercentage(100);
		int[] widthsFormulaire2 = {8,37,55};
		pptFormulaire.setWidths(widthsFormulaire2);
		cellFormulaire = new PdfPCell(pptFormulaire.getDefaultCell());
		cellFormulaire.setBorder(PdfPCell.NO_BORDER);
		cellFormulaire.setPhrase(new Phrase("DATE :", fontLine));
		pptFormulaire.addCell(cellFormulaire);
		cellFormulaire.setBorder(PdfPCell.BOTTOM);
		cellFormulaire.setPhrase(new Phrase("", fontLine));
		pptFormulaire.addCell(cellFormulaire);
		cellFormulaire.setBorder(PdfPCell.NO_BORDER);
		pptFormulaire.addCell(cellFormulaire);
		cell = new PdfPCell(pptFormulaire);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPaddingLeft(40);
		cell.setPaddingRight(40);
		pptCourrier.addCell(cell);
		
		pptFormulaire = new PdfPTable(4);
		pptFormulaire.setWidthPercentage(100);
		int[] widthsFormulaire3 = {25,20,5,50};
		pptFormulaire.setWidths(widthsFormulaire3);
		cellFormulaire = new PdfPCell(pptFormulaire.getDefaultCell());
		cellFormulaire.setBorder(PdfPCell.NO_BORDER);
		cellFormulaire.setPhrase(new Phrase("TELEPHONE DIRECT :", fontLine));
		pptFormulaire.addCell(cellFormulaire);
		cellFormulaire.setBorder(PdfPCell.BOTTOM);
		cellFormulaire.setPhrase(new Phrase("", fontLine));
		pptFormulaire.addCell(cellFormulaire);
		cellFormulaire.setBorder(PdfPCell.NO_BORDER);
		pptFormulaire.addCell(cellFormulaire);
		cellFormulaire.setPhrase(new Phrase("TAMPON SOCIETE", fontLine));
		cellFormulaire.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		pptFormulaire.addCell(cellFormulaire);
		cell = new PdfPCell(pptFormulaire);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPaddingLeft(40);
		cell.setPaddingRight(40);
		pptCourrier.addCell(cell);
		
		return pptCourrier;
	}
	
	
	private PdfPTable makeInfosLegales() {
		
		PdfPTable pptLegales = new PdfPTable(1);
		pptLegales.setWidthPercentage(100);
		
		PdfPCell cell = new PdfPCell(pptLegales.getDefaultCell());		
		
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPhrase(new Phrase(id.raisonSociale +" - "+ id.typeSociete + (id.capital>0?" au capital de "+ numFormatCap.format(id.capital) +" Euros":"") +" - immatricul\u00E9e au RCS "+ id.rcs +" "+ id.siren +" - N\u00B0 TVA : "+ id.tvaIntra, fontLegale));
		
		pptLegales.addCell(cell);
		
		return pptLegales;	
	}


	// mthodes de paramtrage

	public void setMultiEx(boolean multi) {

		this.multi = multi;
	}


} // fin CourrierLotStd
