/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un bon de picking au format standard
 */

package org.opensi.facturation.actions.documents.modeles;


import java.awt.Color;
import java.io.IOException;
import java.sql.Date;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;

import org.opensi.util.pdf.MultiPagesDocument;
import org.opensi.util.pdf.PdfWidths;
import org.opensi.util.pdf.TableBuilder;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;


public class BonPickingStd extends MultiPagesDocument {


private static final Font fontCritere = new Font(Font.HELVETICA, 11, Font.BOLD);
private static final Font fontAdrSociete = new Font(Font.HELVETICA, 10, Font.NORMAL);
private static final Font fontAdrSocieteGras = new Font(Font.HELVETICA, 11, Font.BOLD);
private static final Font fontTitre = new Font(Font.HELVETICA , 16, Font.BOLD, Color.WHITE);
private static final Font fontWeb = new Font(Font.HELVETICA, 10, Font.ITALIC);
private static final Font fontEnteteColonne = new Font(Font.HELVETICA, 9, Font.BOLD);
private static final Font fontInfosFact = new Font(Font.HELVETICA , 10, Font.NORMAL);
private static final Font fontLegale = new Font(Font.HELVETICA , 8, Font.NORMAL);
private static final Font fontLine = new Font(Font.HELVETICA , 8, Font.NORMAL);
private static final Font fontArtNom = new Font(Font.HELVETICA, 9, Font.ITALIC);


private DecimalFormat numFormat = new DecimalFormat("0.00");
private DecimalFormat numFormatCap = new DecimalFormat("0.##");
private SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy HH:mm");


private DataBonPicking id;	// les donnes dynamiques du bon de picking

private float[] widthsCols;
private int nbCols;

private boolean referenceFabricant;
private boolean coul;
private boolean tail;
private boolean nbPieces;
private boolean numLot;
private boolean datePeremption;
private boolean unite;
private boolean stockReel;
private boolean stockDispo;
private boolean montantTTC;

private Image logo;


	public BonPickingStd(String tempdir, DataBonPicking id) throws Exception {

		super(tempdir);
		
		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator('.');
		dfs.setGroupingSeparator(' ');
		
		numFormat.setDecimalFormatSymbols(dfs);
		numFormat.setNegativeSuffix("");
		numFormat.setNegativePrefix("-");
		numFormat.setPositiveSuffix(" ");
		numFormat.setGroupingUsed(true);
		numFormat.setGroupingSize(3);
		
		numFormatCap.setDecimalFormatSymbols(dfs);
		numFormatCap.setGroupingUsed(true);
		numFormatCap.setGroupingSize(3);
		
		
		this.id = id;
		
		try {
			logo = Image.getInstance(id.urlLogo);
			if (logo.getDpiX()!=0 && logo.getDpiY()!=0)
      	logo.scaleAbsolute(logo.getPlainWidth() * 72 / logo.getDpiX(), logo.getPlainHeight() * 72 / logo.getDpiY());
		}
		catch (IOException e) {
			logo = null;
		}
		
		referenceFabricant = id.referenceFabricant;
		tail = id.tail;
		coul = id.coul;
		nbPieces = id.nbPieces;
		numLot = id.numLot;
		datePeremption = id.datePeremption;
		unite = id.unite;
		stockReel = id.stockReel;
		stockDispo = id.stockDispo;
		montantTTC = id.montantTTC;
		
		PdfWidths pw = new PdfWidths();
		
		pw.addColonneVariableMinMax(2, 13, 20);
		pw.addColonneVariableMinMax(2, 13, 20);
		if (referenceFabricant) pw.addColonneVariableMinMax(2, 13, 20);
		pw.addColonneVariableMin(4,20);
		pw.addColonneVariableMin(1, 7);
		if (coul) pw.addColonneVariableMin(1, 7);
		if (tail) pw.addColonneVariableMin(1, 7);
		if (numLot) pw.addColonneVariableMinMax(2, 6, 9);
		if (nbPieces) pw.addColonneFixe(5);
		if (datePeremption) pw.addColonneFixe(8);
		pw.addColonneVariableMin(1, 8);
		if (unite) pw.addColonneFixe(5);
		if (stockReel) pw.addColonneVariableMinMax(1, 8, 12);
		if (stockDispo) pw.addColonneVariableMinMax(1, 8, 12);
		pw.addColonneVariableMinMax(1, 8, 12);
		if (montantTTC) pw.addColonneVariableMinMax(1, 8, 12);
		
		nbCols = pw.getNbCols();
		widthsCols = pw.getWidthsCols();
	}


	
	/* implmentation des fonctions de MultiPagesDocument */
	
	public PdfPTable firstHeader() throws DocumentException {
		
		TableBuilder tb = new TableBuilder();
		
		tb.add(makeEntete());
		tb.add(makeSpace(10));
		tb.add(makeTitre());
		tb.add(makeSpace(5));
		tb.add(makeCritere());
		tb.add(makeSpace(5));
		tb.add(makeEntetesColonnes());		
		
		return tb.getTable();	
	}
	
	
	public PdfPTable middleHeader(int lastLine) throws DocumentException {
		
		TableBuilder tb = new TableBuilder();
		
		tb.add(makeEntete());
		tb.add(makeSpace(10));
		tb.add(makeTitre());
		tb.add(makeSpace(5));
		tb.add(makeEntetesColonnes());
		
		return tb.getTable();
	}
	
	
	public PdfPTable lastFooter() throws DocumentException {
		
		TableBuilder tb = new TableBuilder();
		
		tb.add(emptyLine(10));
		tb.add(makeFinTableau());
		tb.add(makeSpace(3));
		tb.add(makeInfosLegales());
		
		return tb.getTable();
	}
	
	
	public PdfPTable middleFooter(int nbLinesPage, int lastLine) throws DocumentException {
		
		TableBuilder tb = new TableBuilder();
		
		tb.add(emptyLine(10));
		tb.add(makeFinTableau());
		tb.add(makeSpace(3));
		tb.add(makeInfosLegales());		
		
		return tb.getTable();		
	}	
	
	
	public PdfPTable bodyLine(int numLine) throws DocumentException {
	
		LigneBonPicking lbp = id.lignes.get(numLine);
	
		switch (lbp.type) {			
			case 'A':	return makeLineArticle(lbp);
			default:
			case 'N': return makeLineNomenclature(lbp);
		}		
	}
	
	
	public PdfPTable emptyLine(float emptyHeight) throws DocumentException {
		
		PdfPTable pptSpace = new PdfPTable(nbCols);
		pptSpace.setWidthPercentage(100);
		pptSpace.setWidths(widthsCols);
		
		PdfPCell cell = new PdfPCell(pptSpace.getDefaultCell());
		cell.setBorder(PdfPCell.LEFT+PdfPCell.RIGHT);
		cell.setPaddingBottom(0);
		cell.setPaddingTop(0);
		cell.setFixedHeight(emptyHeight);		
		cell.setPhrase(new Phrase(""));		
	
		for (int i=0; i<nbCols; i++) {
			pptSpace.addCell(cell);
		}
	
		return pptSpace;
	}
	
	
	public int nbLines() {
	
		return id.getNbLignes();
	}
	
	
	public int nbEx() {
	
		return 1;
	}


	public Image imageFond() {
		return null;
	}


	/* mthodes internes */

	private PdfPTable makeSpace(int space) {
	
		PdfPTable pptSpace = new PdfPTable(1);
		PdfPCell cell = new PdfPCell(pptSpace.getDefaultCell());
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setFixedHeight(space);
		cell.setPhrase(new Phrase(""));
	
		pptSpace.addCell(cell);
	
		return pptSpace;
	}
	

	private PdfPTable makeEntete() throws DocumentException {
	
		PdfPTable pptEntete = new PdfPTable(2);
		pptEntete.setWidthPercentage(100);
		int[] widths = {50,50};
		pptEntete.setWidths(widths);
		PdfPCell cellSociete = new PdfPCell(makeInfosSociete());
		cellSociete.setBorder(PdfPCell.NO_BORDER);
		
		PdfPCell cellFacture = new PdfPCell(makeInfosBon());
		cellFacture.setBorder(PdfPCell.NO_BORDER);
		
		pptEntete.addCell(cellSociete);		
		pptEntete.addCell(cellFacture);
			
		
		return pptEntete;		
	}


	private PdfPTable makeInfosBon() throws DocumentException {

		PdfPTable pptInfosBon = new PdfPTable(2);
		
		int[] widths = {50,50};
		pptInfosBon.setWidths(widths);
		
		PdfPCell cell = new PdfPCell(pptInfosBon.getDefaultCell());
		
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setPaddingLeft(4);
		cell.setPaddingBottom(4);
		
		cell.setPhrase(new Phrase("", fontInfosFact));
		cell.setBorder(PdfPCell.NO_BORDER);
		pptInfosBon.addCell(cell);
		
		cell.setPhrase(new Phrase("Date : "+ formatDate.format(new Date(id.dateEditionLot)), fontInfosFact));
		cell.setBorder(PdfPCell.BOX);
		pptInfosBon.addCell(cell);
		
		cell.setColspan(2);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPhrase(new Phrase("", fontLine));
		cell.setFixedHeight(5);
		pptInfosBon.addCell(cell);
		cell.setMinimumHeight(0);
		
		cell.setPhrase(new Phrase("Page "+currentPage+" / "+totalPages, fontInfosFact));
		cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		pptInfosBon.addCell(cell);

		cell.setPhrase(new Phrase("", fontLine));
		cell.setFixedHeight(65);
		pptInfosBon.addCell(cell);
		cell.setMinimumHeight(0);

		cell.setPhrase(new Phrase("", fontLine));
		pptInfosBon.addCell(cell);

		return pptInfosBon;
	}


	
	private PdfPTable makeInfosSociete() {
	
		PdfPTable pptInfos = new PdfPTable(1);
		
		PdfPCell cell;
				
		if (logo != null) {
			cell = new PdfPCell(logo, false);

			cell.setBorder(PdfPCell.NO_BORDER);
			cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

			pptInfos.addCell(cell);

			cell.setImage(null);

			cell.setMinimumHeight(5);
			cell.setPhrase(new Phrase("", fontAdrSociete));
			pptInfos.addCell(cell);
			cell.setMinimumHeight(0);
		}
		else {
			cell = new PdfPCell(pptInfos.getDefaultCell());
			cell.setBorder(PdfPCell.NO_BORDER);
			cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		}	
		
		if (!id.logoAdr) {
			cell.setPhrase(new Phrase(id.raisonSociale, fontAdrSocieteGras));		
			pptInfos.addCell(cell);
			cell.setPhrase(new Phrase(id.adresse1, fontAdrSociete));		
			pptInfos.addCell(cell);
			if (!id.adresse2.equals("")) {
				cell.setPhrase(new Phrase(id.adresse2, fontAdrSociete));
				pptInfos.addCell(cell);
			}
			if (!id.adresse3.equals("")) {
				cell.setPhrase(new Phrase(id.adresse3, fontAdrSociete));
				pptInfos.addCell(cell);
			}
			cell.setPhrase(new Phrase(id.codePostal+" "+id.ville, fontAdrSociete));		
			pptInfos.addCell(cell);

			String telfax = "";

			if (id.tel.length()>0) {
				telfax = "T\u00E9l: "+ id.tel;
				if (id.fax.length()>0) {
					telfax += " - Fax: "+ id.fax;
				}
			}
			else if (id.fax.length()>0) {
				telfax = "Fax: "+ id.fax;
			}		

			if (telfax.length()>0) {
				cell.setPhrase(new Phrase(telfax, fontAdrSociete));		
				pptInfos.addCell(cell);
			}

			if (!id.email.equals("")) {
				cell.setPhrase(new Phrase("e-mail: "+ id.email, fontAdrSociete));		
				pptInfos.addCell(cell);
			}
			if (!id.web.equals("")) {
				cell.setPhrase(new Phrase(id.web, fontWeb));		
				pptInfos.addCell(cell);
			}
		}
		
		cell.setPhrase(new Phrase(""));		
		pptInfos.addCell(cell);
		
		return pptInfos;	
	}


	private PdfPTable makeTitre() {
	
		PdfPTable pptTitre = new PdfPTable(1);
		pptTitre.setWidthPercentage(100);
		
		PdfPCell cell = new PdfPCell(pptTitre.getDefaultCell());		
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setBackgroundColor(new Color(175,175,175));
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setFixedHeight(30);
		cell.setPaddingBottom(5);
		cell.setPhrase(new Phrase("B  O  N     D  E     P  I  C  K  I  N  G", fontTitre));
		
		pptTitre.addCell(cell);
		
		return pptTitre;	
	}
	
	
	private PdfPTable makeCritere() throws DocumentException {
		
		
		PdfPTable pptCritere = new PdfPTable(1);
		pptCritere.setWidthPercentage(100);

		PdfPCell cell = new PdfPCell(pptCritere.getDefaultCell());
		cell.setPaddingLeft(5);
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setPhrase(new Phrase("Marque : "+ id.marque, fontCritere));
		cell.setMinimumHeight(30);
		pptCritere.addCell(cell);

		return pptCritere;
	}	
	
	
	
	private PdfPTable makeEntetesColonnes() throws DocumentException {

		PdfPTable pptCols = new PdfPTable(nbCols);
		pptCols.setWidthPercentage(100);
		pptCols.setWidths(widthsCols);

		PdfPCell cell = new PdfPCell(pptCols.getDefaultCell());

		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setPaddingBottom(4);
		cell.setMinimumHeight(40);

		cell.setPhrase(new Phrase("Localisation", fontEnteteColonne));
		pptCols.addCell(cell);
		cell.setPhrase(new Phrase("R\u00E9f\u00E9rence", fontEnteteColonne));
		pptCols.addCell(cell);
		
		if (referenceFabricant) {
			cell.setPhrase(new Phrase("R\u00E9f\u00E9rence\nfabricant", fontEnteteColonne));
			pptCols.addCell(cell);			
		}
		
		cell.setPhrase(new Phrase("D\u00E9signation", fontEnteteColonne));
		pptCols.addCell(cell);
		
		cell.setPhrase(new Phrase("Marque", fontEnteteColonne));
		pptCols.addCell(cell);

		if (coul) {
			cell.setPhrase(new Phrase("Coul.", fontEnteteColonne));
			pptCols.addCell(cell);
		}

		if (tail) {
			cell.setPhrase(new Phrase("Taille", fontEnteteColonne));
			pptCols.addCell(cell);
		}
		
		if (numLot) {
			cell.setPhrase(new Phrase("N\u00B0 Lot", fontEnteteColonne));
			pptCols.addCell(cell);
		}
		if (nbPieces) {
			cell.setPhrase(new Phrase("Nb Pc", fontEnteteColonne));
			pptCols.addCell(cell);
		}
		if (datePeremption) {
			cell.setPhrase(new Phrase("DLC", fontEnteteColonne));
			pptCols.addCell(cell);
		}

		cell.setPhrase(new Phrase("Qt\u00E9", fontEnteteColonne));
		pptCols.addCell(cell);
		
		if (unite) {
			cell.setPhrase(new Phrase("Unit\u00E9", fontEnteteColonne));
			pptCols.addCell(cell);
		}
		
		if (stockReel) {
			cell.setPhrase(new Phrase("Stock\nr\u00E9el", fontEnteteColonne));
			pptCols.addCell(cell);
		}
		if (stockDispo) {
			cell.setPhrase(new Phrase("Stock\ndispo", fontEnteteColonne));
			pptCols.addCell(cell);
		}
		
		cell.setPhrase(new Phrase("PU TTC", fontEnteteColonne));
		pptCols.addCell(cell);
		
		if (montantTTC) {
			cell.setPhrase(new Phrase("Montant TTC", fontEnteteColonne));
			pptCols.addCell(cell);
		}

		return pptCols;
	}	
	
	
	private PdfPTable makeLineArticle(LigneBonPicking lb) throws DocumentException {
	
		PdfPTable pptLine = new PdfPTable(nbCols);
		pptLine.setWidthPercentage(100);
		pptLine.setWidths(widthsCols);

		PdfPCell cell = new PdfPCell(pptLine.getDefaultCell());

		cell.setBorder(PdfPCell.RIGHT+PdfPCell.LEFT);
		
		if (lb.commentaireAvant.length()>0) {
			cell.setPaddingLeft(5);
			cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
			cell.setPaddingRight(0);
			cell.setPhrase(new Phrase("", fontLine));
			pptLine.addCell(cell);
			pptLine.addCell(cell);
			if (referenceFabricant) pptLine.addCell(cell);
			cell.setPhrase(new Phrase(lb.commentaireAvant, fontLine));
			pptLine.addCell(cell);
			cell.setPhrase(new Phrase("", fontLine));
			pptLine.addCell(cell);
			if (coul) pptLine.addCell(cell);
			if (tail) pptLine.addCell(cell);
			if (numLot) pptLine.addCell(cell);
			if (nbPieces) pptLine.addCell(cell);
			if (datePeremption) pptLine.addCell(cell);
			pptLine.addCell(cell);
			if (unite) pptLine.addCell(cell);
			if (stockReel) pptLine.addCell(cell);
			if (stockDispo) pptLine.addCell(cell);
			pptLine.addCell(cell);
			if (montantTTC) pptLine.addCell(cell);
		}

		cell.setPaddingLeft(5);
		cell.setPhrase(new Phrase(lb.localisation, fontLine));
		pptLine.addCell(cell);
		cell.setPhrase(new Phrase(lb.reference, fontLine));
		pptLine.addCell(cell);
		if (referenceFabricant) {
			cell.setPhrase(new Phrase(lb.refFabricant, fontLine));
			pptLine.addCell(cell);
		}	
		cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cell.setPhrase(new Phrase(lb.designation, fontLine));
		pptLine.addCell(cell);
		
		cell.setPhrase(new Phrase(lb.marque, fontLine));
		pptLine.addCell(cell);

		if (coul) {
			cell.setPhrase(new Phrase(lb.couleur, fontLine));
			pptLine.addCell(cell);
		}
		if (tail) {
			cell.setPhrase(new Phrase(lb.taille, fontLine));
			pptLine.addCell(cell);
		}
		
		cell.setPaddingLeft(0);
		cell.setPaddingRight(0);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		
		if (numLot) {
			cell.setPhrase(new Phrase((lb.num_lot), fontLine));
			pptLine.addCell(cell);
		}
		if (nbPieces) {
			if (lb.nb_pieces != 0)
				cell.setPhrase(new Phrase(""+numFormatCap.format(lb.nb_pieces), fontLine));
			else
				cell.setPhrase(new Phrase("", fontLine));			
			pptLine.addCell(cell);
		}
		if (datePeremption) {
			if (lb.date_peremption != 0)
				cell.setPhrase(new Phrase(""+ formatDate.format(new Date(lb.date_peremption)), fontLine));
			else
				cell.setPhrase(new Phrase("", fontLine));
			pptLine.addCell(cell);
		}

		cell.setPhrase(new Phrase(""+numFormatCap.format(lb.quantite), fontLine));
		pptLine.addCell(cell);
		
		if (unite) {
			cell.setPhrase(new Phrase(lb.unite, fontLine));
			pptLine.addCell(cell);
		}
		
		if (stockReel) {
			cell.setPhrase(new Phrase(""+numFormatCap.format(lb.stockReel), fontLine));
			pptLine.addCell(cell);
		}
		if (stockDispo) {
			cell.setPhrase(new Phrase(""+numFormatCap.format(lb.stockDispo), fontLine));
			pptLine.addCell(cell);
		}
		
		cell.setPhrase(new Phrase(""+numFormat.format(lb.puTTC), fontLine));
		pptLine.addCell(cell);
		
		if (montantTTC) {
			cell.setPhrase(new Phrase(""+numFormat.format(lb.montantTTC), fontLine));
			pptLine.addCell(cell);
		}


		if (lb.commentaireApres.length()>0) {
			cell.setPaddingLeft(5);
			cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
			cell.setPaddingRight(0);
			cell.setPhrase(new Phrase("", fontLine));
			pptLine.addCell(cell);
			pptLine.addCell(cell);
			if (referenceFabricant) pptLine.addCell(cell);
			cell.setPhrase(new Phrase(lb.commentaireApres, fontLine));
			pptLine.addCell(cell);
			cell.setPhrase(new Phrase("", fontLine));
			pptLine.addCell(cell);
			if (coul) pptLine.addCell(cell);
			if (tail) pptLine.addCell(cell);
			if (numLot) pptLine.addCell(cell);
			if (nbPieces) pptLine.addCell(cell);
			if (datePeremption) pptLine.addCell(cell);
			pptLine.addCell(cell);
			if (unite) pptLine.addCell(cell);
			if (stockReel) pptLine.addCell(cell);
			if (stockDispo) pptLine.addCell(cell);
			pptLine.addCell(cell);
			if (montantTTC) pptLine.addCell(cell);
		}

		if (lb.detail_1.length()>0) {
			cell.setPaddingLeft(5);
			cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
			cell.setPaddingRight(0);
			cell.setPhrase(new Phrase("", fontLine));
			pptLine.addCell(cell);
			pptLine.addCell(cell);
			if (referenceFabricant) pptLine.addCell(cell);
			cell.setPhrase(new Phrase(lb.detail_1, fontLine));
			pptLine.addCell(cell);
			cell.setPhrase(new Phrase("", fontLine));
			pptLine.addCell(cell);
			if (coul) pptLine.addCell(cell);
			if (tail) pptLine.addCell(cell);
			if (numLot) pptLine.addCell(cell);
			if (nbPieces) pptLine.addCell(cell);
			if (datePeremption) pptLine.addCell(cell);
			pptLine.addCell(cell);
			if (unite) pptLine.addCell(cell);
			if (stockReel) pptLine.addCell(cell);
			if (stockDispo) pptLine.addCell(cell);
			pptLine.addCell(cell);
			if (montantTTC) pptLine.addCell(cell);
		}

		if (lb.detail_2.length()>0) {
			cell.setPaddingLeft(5);
			cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
			cell.setPaddingRight(0);
			cell.setPhrase(new Phrase("", fontLine));
			pptLine.addCell(cell);
			pptLine.addCell(cell);
			if (referenceFabricant) pptLine.addCell(cell);
			cell.setPhrase(new Phrase(lb.detail_2, fontLine));
			pptLine.addCell(cell);
			cell.setPhrase(new Phrase("", fontLine));
			pptLine.addCell(cell);
			if (coul) pptLine.addCell(cell);
			if (tail) pptLine.addCell(cell);
			if (numLot) pptLine.addCell(cell);
			if (nbPieces) pptLine.addCell(cell);
			if (datePeremption) pptLine.addCell(cell);
			pptLine.addCell(cell);
			if (unite) pptLine.addCell(cell);
			if (stockReel) pptLine.addCell(cell);
			if (stockDispo) pptLine.addCell(cell);
			pptLine.addCell(cell);
			if (montantTTC) pptLine.addCell(cell);
		}		

		return pptLine;	
	}
	
	
	private PdfPTable makeLineNomenclature(LigneBonPicking lb) throws DocumentException {
	
		PdfPTable pptLine = new PdfPTable(nbCols);
		pptLine.setWidthPercentage(100);
		pptLine.setWidths(widthsCols);

		PdfPCell cell = new PdfPCell(pptLine.getDefaultCell());

		cell.setBorder(PdfPCell.RIGHT+PdfPCell.LEFT);
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

		cell.setPhrase(new Phrase("", fontLine));
		pptLine.addCell(cell);
		pptLine.addCell(cell);
		if (referenceFabricant) pptLine.addCell(cell);

		PdfPTable pptArtNom = new PdfPTable(unite?3:2);
		pptArtNom.setWidthPercentage(100);
		int[] widths = {10,90};
		int[] widthsUnite = {10,10,80};
		pptArtNom.setWidths(unite?widthsUnite:widths);
		PdfPCell cellArtNom = new PdfPCell(pptArtNom.getDefaultCell());
		cellArtNom.setBorder(PdfPCell.NO_BORDER);
		cellArtNom.setPhrase(new Phrase(numFormatCap.format(lb.quantite), fontArtNom));
		pptArtNom.addCell(cellArtNom);
		if (unite) {
			cellArtNom.setPhrase(new Phrase(lb.unite, fontArtNom));
			pptArtNom.addCell(cellArtNom);
		}
		cellArtNom.setPhrase(new Phrase(lb.designation, fontArtNom));
		pptArtNom.addCell(cellArtNom);
		PdfPCell cellDesc = new PdfPCell(pptArtNom);
		cellDesc.setBorder(PdfPCell.NO_BORDER);
		cellDesc.setPaddingLeft(10);
		pptLine.addCell(cellDesc);
		
		cell.setPhrase(new Phrase("", fontLine));
		pptLine.addCell(cell);
		if (coul) pptLine.addCell(cell);
		if (tail) pptLine.addCell(cell);
		if (numLot) pptLine.addCell(cell);
		if (nbPieces) pptLine.addCell(cell);
		if (datePeremption) pptLine.addCell(cell);
		pptLine.addCell(cell);
		if (unite) pptLine.addCell(cell);
		if (stockReel) pptLine.addCell(cell);
		if (stockDispo) pptLine.addCell(cell);
		pptLine.addCell(cell);
		if (montantTTC) pptLine.addCell(cell);

		return pptLine;
	}
	
	
	private PdfPTable makeFinTableau() throws DocumentException {
	
		PdfPTable pptFin = new PdfPTable(1);
		pptFin.setWidthPercentage(100);

		PdfPCell cell = new PdfPCell(pptFin.getDefaultCell());
		cell.setPhrase(new Phrase(""));
		cell.setFixedHeight(1);
		cell.setBorder(PdfPCell.TOP);
		cell.setPadding(0);
		pptFin.addCell(cell);
		
		return pptFin;
	}
	
	
	private PdfPTable makeInfosLegales() {
	
		PdfPTable pptLegales = new PdfPTable(1);
		pptLegales.setWidthPercentage(100);
		
		PdfPCell cell = new PdfPCell(pptLegales.getDefaultCell());		
		
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPhrase(new Phrase(id.raisonSociale +" - "+ id.typeSociete + (id.capital>0?" au capital de "+ numFormatCap.format(id.capital) +" Euros":"") +" - immatricul\u00E9e au RCS "+ id.rcs +" "+ id.siren +" - N\u00B0 TVA : "+ id.tvaIntra, fontLegale));
		
		pptLegales.addCell(cell);
		
		return pptLegales;	
	}
	

} // fin BonPickingStd
