/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation.actions.documents;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;


public class GenPdfEtatAbonnement extends Action {


	class MyPageEvent implements PdfPageEvent {

	private String dateCourante;

	private String dossierId;
	private String raisonSociale;
	private String adresse1;
	private String adresse2;
	private String adresse3;
	private String codePostal;
	private String ville;

		public MyPageEvent(String dossierId) throws SQLException {

			this.dossierId = dossierId;

			Statement stt = con.createStatement();
			ResultSet rset = stt.executeQuery("select * from "+ base +".SOCIETE");

			rset.next();

			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");

			rset.close();

			stt.close();

			SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
			this.dateCourante = formatDate.format(new Date(System.currentTimeMillis()));
     }


    public void onStartPage(PdfWriter writer, Document document) {

    	try {

				// Entete G\u00E9n\u00E9rale


				PdfPTable bandeau = new PdfPTable(1);

				bandeau.setWidthPercentage(100);

				PdfPTable entete = new PdfPTable(3);

				PdfPCell cellEntete = new PdfPCell(entete.getDefaultCell());

				cellEntete.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
				cellEntete.setBorderWidth(0);
				cellEntete.setMinimumHeight(10);

				cellEntete.setPhrase(new Phrase("Dossier : " + this.dossierId, fontGen));
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(raisonSociale, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("Date : " + this.dateCourante, fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(adresse1, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("", fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(adresse2, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("Page : "+ document.getPageNumber(), fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);
				
				if (!adresse3.equals("")) {
					cellEntete.setPhrase(new Phrase(adresse3, fontGen));
					cellEntete.setColspan(2);
					cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
					entete.addCell(cellEntete);
					cellEntete.setColspan(1);
					
					cellEntete.setPhrase(new Phrase("", fontGen));
					cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
					entete.addCell(cellEntete);
				}

				cellEntete.setPhrase(new Phrase(codePostal + " " + ville, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase("Etat des abonnements au : " + this.dateCourante, new Font(Font.HELVETICA, 16, Font.BOLD)));
				cellEntete.setColspan(3);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(""));
				cellEntete.setFixedHeight(10);
				entete.addCell(cellEntete);

				PdfPCell cellBandeau = new PdfPCell(entete);
				cellBandeau.setPadding(10);

				bandeau.addCell(cellBandeau);

				document.add(bandeau);

				// fin Entete G\u00E9n\u00E9rale
				PdfPTable bande;
				bande = new PdfPTable(1);
				bande.setWidthPercentage(100);

				PdfPCell cellBande = new PdfPCell(bande.getDefaultCell());


				cellBande.setFixedHeight(6);
				cellBande.setBorder(PdfPCell.NO_BORDER);
				cellBande.setPhrase(new Phrase(""));
				cellBande.setPhrase(new Phrase(""));

				bande.addCell(cellBande);

				document.add(bande);


				// Titres de colonnes
				PdfPTable titresColonnes;

				titresColonnes = new PdfPTable(9);
				titresColonnes.setWidthPercentage(100);
				titresColonnes.setWidths(widths);

				PdfPCell cellTitre = new PdfPCell(titresColonnes.getDefaultCell());

				cellTitre.setFixedHeight(6);
				cellTitre.setBorder(PdfPCell.NO_BORDER);
				cellTitre.setPhrase(new Phrase(""));
				cellTitre.setPhrase(new Phrase(""));

				cellTitre.setFixedHeight(20);
				cellTitre.setBackgroundColor(Color.LIGHT_GRAY);
				cellTitre.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

				cellTitre.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);
				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				cellTitre.setPhrase(new Phrase("NUMERO ABT", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				cellTitre.setBorder(PdfPCell.BOX);
				cellTitre.setPhrase(new Phrase("LIBELLE", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setBorder(PdfPCell.BOX - PdfPCell.LEFT);
				cellTitre.setColspan(2);
				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				cellTitre.setPhrase(new Phrase("CLIENT", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setColspan(1);
				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				cellTitre.setBorder(PdfPCell.BOX);
				cellTitre.setPhrase(new Phrase("DATE DE DEBUT", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				cellTitre.setBorder(PdfPCell.BOX);
				cellTitre.setPhrase(new Phrase("DATE DE FIN", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				cellTitre.setBorder(PdfPCell.BOX);
				cellTitre.setPhrase(new Phrase("PERIODICITE", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				cellTitre.setBorder(PdfPCell.BOX);
				cellTitre.setPhrase(new Phrase("TYPE DE CONTRAT", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				cellTitre.setBorder(PdfPCell.BOX);
				cellTitre.setPhrase(new Phrase("ETAT", fontLine));
				titresColonnes.addCell(cellTitre);

				document.add(titresColonnes);

				// fin Titres de colonnes

			} catch(DocumentException de) {
        de.printStackTrace();
			}
		}

		public void onEndPage(PdfWriter writer, Document document) {}
		public void onOpenDocument(PdfWriter writer, Document document) {}
    public void onCloseDocument(PdfWriter writer, Document document) {}
    public void onParagraph(PdfWriter writer, Document document, float paragraphPosition) {}
    public void onParagraphEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onChapter(PdfWriter writer,Document document,float paragraphPosition, Paragraph title) {}
    public void onChapterEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onSection(PdfWriter writer,Document document,float paragraphPosition, int depth, Paragraph title) {}
    public void onSectionEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onGenericTag(PdfWriter writer, Document document, Rectangle rect, String text) {}

	}


private static final Font fontGen = new Font(Font.HELVETICA , 10, Font.NORMAL);		// font pour lignes d'entete
private static final Font fontLine = new Font(Font.HELVETICA , 8, Font.NORMAL);		// font pour lignes de listing
private DecimalFormat numFormat = new DecimalFormat("0.00");

private int widths[] = {13,14,7,9,10,10,11,15,11}; // largeurs des colonnes du listing

private Connection con;
private String base;

  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {

		try {
		con = s.getConnection(null);


		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator('.');
		dfs.setGroupingSeparator(' ');

		numFormat.setDecimalFormatSymbols(dfs);
		numFormat.setNegativeSuffix("-");
		numFormat.setNegativePrefix("");
		numFormat.setPositiveSuffix(" ");
		numFormat.setGroupingUsed(true);
		numFormat.setGroupingSize(3);


		String dossierId = s.getCookie().get("Dossier_Id");
		String id = r.getParameter("id");
		int nbAbonnement = Integer.parseInt(r.getParameter("nbAbonnement"));
		String[] Liste_Abonnement_Id = r.getParameter("Liste_Abonnement").split(",");
		base = s.getCookie().get("BaseDossier");


		PdfPTable listing;
		PdfPTable footer;

		Document document = new Document(PageSize.A4, 20, 20, 20, 20);

		String chemin = s.getAppConfiguration().get("opensi.absdir") + "/pdf/";

		String fichierPdf = "etatAbonnement_"+ id +".pdf";

		PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(chemin + fichierPdf));

   	listing = new PdfPTable(9);
   	listing.setWidthPercentage(100);
		listing.setWidths(widths);

    footer = new PdfPTable(1);
		footer.setWidthPercentage(100);

		MyPageEvent event = new MyPageEvent(dossierId);
    writer.setPageEvent(event);

		String nbClient = "select count(distinct Denomination) as nbrClient from "+ base + ".ABONNEMENT";

		for(int i=0;i<nbAbonnement;i++) {
			int Abonnement_Id = Integer.parseInt(Liste_Abonnement_Id[i]);
			String infoAbonnement = "select * from "+ base +".ABONNEMENT where Abonnement_Id="+ Abonnement_Id;
			Statement stt1 = con.createStatement();
    	ResultSet rset = stt1.executeQuery(infoAbonnement);
			if (i==0)
				nbClient += " where Abonnement_Id="+  Abonnement_Id;
			else
				nbClient += " or Abonnement_Id="+  Abonnement_Id;

			if (rset.next()) {

				String num_abonnement = rset.getString("Num_Entier");
				String libelle = rset.getString("Libelle");
				String RaisonSociale = rset.getString("Denomination");
				long DateDebut = rset.getLong("Date_debut_abonnement");
				long DateFin = rset.getLong("Date_fin_abonnement");
				int periodicite = rset.getInt("Periodicite");
				int TypePeriodicite = rset.getInt("Type_periodicite");
				int TypeContrat  = rset.getInt("Type_contrat");
				String etatStr = rset.getString("Etat");
				char etatChar = etatStr.charAt(0);
				String Client_Id = rset.getString("Client_Id");

				putLigneAbonnements(listing,
														num_abonnement,
														Client_Id,
														libelle,
														RaisonSociale,
														DateDebut,
														DateFin,
														periodicite,
														TypePeriodicite,
														TypeContrat,
														etatChar);

			}
		}
		Statement stt2 = con.createStatement();
    ResultSet rset2 = stt2.executeQuery(nbClient);
		int nombreClient = 0;
		if (rset2.next()){
			nombreClient  = rset2.getInt("nbrClient");
		}

    if (!document.isOpen()) {
      document.open();
    }

		document.add(listing);

		makeFooter(footer,nbAbonnement,nombreClient);
		document.add(footer);

		s.closeConnection(con, null);


		if (document.isOpen()) {
    	document.close();
		}

		try {
			File filePdf = new File(chemin, fichierPdf);
			filePdf.deleteOnExit();
		}
		catch(SecurityException se) {
			s.trace("Impossible d'enregistrer le fichier \u00E0 supprimer");
			se.printStackTrace();
		}

    } catch (Exception e) {
      e.printStackTrace();
    }
		return true;


	} // fin service


	private void putLigneAbonnements(PdfPTable listing,
                                   String num_abonnement,
																	 String Client_Id,
																	 String libelle,
																	 String RaisonSociale,
																	 long DateDebut,
																	 long DateFin,
																	 int periodicite,
																	 int TypePeriodicite,
																	 int TypeContrat,
																	 char etat) {

		SimpleDateFormat formatDatePoint = new SimpleDateFormat("dd.MM.yy");

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

		cellListing.setPaddingRight(0);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPhrase(new Phrase(num_abonnement, fontLine));
		listing.addCell(cellListing);

		cellListing.setPaddingRight(0);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPhrase(new Phrase(libelle, fontLine));
		listing.addCell(cellListing);

		cellListing.setBorder(PdfPCell.LEFT+PdfPCell.TOP+PdfPCell.BOTTOM);

		cellListing.setPaddingRight(0);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setPhrase(new Phrase(Client_Id, fontLine));
		listing.addCell(cellListing);

		cellListing.setBorder(PdfPCell.RIGHT+PdfPCell.TOP+PdfPCell.BOTTOM);

		cellListing.setPhrase(new Phrase(RaisonSociale, fontLine));
		listing.addCell(cellListing);

		cellListing.setBorder(PdfPCell.RIGHT+PdfPCell.TOP+PdfPCell.BOTTOM);

		cellListing.setPaddingRight(0);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPhrase(new Phrase(formatDatePoint.format(new Date(DateDebut)), fontLine));
		listing.addCell(cellListing);

		cellListing.setPaddingRight(0);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPhrase(new Phrase(formatDatePoint.format(new Date(DateFin)), fontLine));
		listing.addCell(cellListing);

		String TypePerio = "jour(s)";
		switch(TypePeriodicite) {
			case 2:TypePerio = "semaine(s)";break;
			case 3:TypePerio = "mois";break;
			case 4:TypePerio = "ann\u00E9e(s)";break;
		}

		cellListing.setPaddingRight(0);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPhrase(new Phrase(periodicite+" "+TypePerio, fontLine));
		listing.addCell(cellListing);

		String typeCon = "sans reconduction";
		if (TypeContrat == 2) {
			typeCon = "reconduction tacite";
		}
		else if (TypeContrat == 3) {
			typeCon = "reconduction sur demande";
		}
		cellListing.setPaddingRight(0);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPhrase(new Phrase(typeCon, fontLine));
		listing.addCell(cellListing);

		String Etat = "en attente";
		switch(etat) {
			case 'C':Etat = "en cours";break;
			case 'T':Etat = "termin\u00E9";break;
			case 'R':Etat = "r\u00E9sili\u00E9";break;
		}
		cellListing.setPaddingRight(0);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPhrase(new Phrase(Etat, fontLine));
		listing.addCell(cellListing);
	}
	
	
	private void makeFooter(PdfPTable footer,int nbAbonnement,int nbrClient) {

		PdfPTable infoFooter = new PdfPTable(2);

		PdfPCell cellfooter = new PdfPCell(infoFooter.getDefaultCell());

		cellfooter.setPaddingLeft(120);
		cellfooter.setBorder(PdfPCell.NO_BORDER);
		cellfooter.setBackgroundColor(Color.LIGHT_GRAY);
		cellfooter.setPaddingRight(0);
		cellfooter.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellfooter.setPhrase(new Phrase("", fontLine));
		infoFooter.addCell(cellfooter);

		cellfooter.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellfooter.setPhrase(new Phrase("Nombre d'abonnements affich\u00E9s : "+ nbAbonnement,fontLine));
		infoFooter.addCell(cellfooter);


		cellfooter.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellfooter.setPhrase(new Phrase("", fontLine));
		infoFooter.addCell(cellfooter);

		cellfooter.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellfooter.setPhrase(new Phrase("Nombre de clients abonn\u00E9s : "+ nbrClient,fontLine));
		infoFooter.addCell(cellfooter);

		PdfPCell cellBarre = new PdfPCell(infoFooter);

		footer.addCell(cellBarre);
	}
	

} // fin GenPdfEtatAbonnement
