/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation.actions.documents;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;


public class GenImprimerAbonnement extends Action {

	private Connection con;

	class MyPageEvent implements PdfPageEvent {

	private String dateCourante;

	private String dossierId;
	private String raisonSociale;
	private String adresse1;
	private String adresse2;
	private String adresse3;
	private String codePostal;
	private String ville;


		public MyPageEvent(String dossierId) throws SQLException {

			this.dossierId = dossierId;

			Statement stt = con.createStatement();
			ResultSet rset = stt.executeQuery("select * from "+ base +".SOCIETE");

			rset.next();

			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");

			rset.close();

			stt.close();

			SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
			this.dateCourante = formatDate.format(new Date(System.currentTimeMillis()));
     }


    public void onStartPage(PdfWriter writer, Document document) {

    	try {

				// Entete G\u00E9n\u00E9rale

				PdfPTable bandeau = new PdfPTable(1);

				bandeau.setWidthPercentage(100);

				PdfPTable entete = new PdfPTable(3);

				PdfPCell cellEntete = new PdfPCell(entete.getDefaultCell());

				cellEntete.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
				cellEntete.setBorderWidth(0);
				cellEntete.setMinimumHeight(10);

				cellEntete.setPhrase(new Phrase("Dossier : " + this.dossierId, fontGen));
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(raisonSociale, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("Date : " + this.dateCourante, fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(adresse1, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("", fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(adresse2, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);
				
				if (!adresse3.equals("")) {
					cellEntete.setPhrase(new Phrase("", fontGen));
					cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
					entete.addCell(cellEntete);
					
					cellEntete.setPhrase(new Phrase(adresse3, fontGen));
					cellEntete.setColspan(2);
					cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
					entete.addCell(cellEntete);
					cellEntete.setColspan(1);
				}

				cellEntete.setPhrase(new Phrase("Page : "+ document.getPageNumber(), fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(codePostal + " " + ville, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase("ABONNEMENT"));
				cellEntete.setColspan(3);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(""));
				cellEntete.setColspan(3);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);

				String ReqAbonnement = "select Libelle from "+ base + ".ABONNEMENT where Abonnement_Id="+Abonnement_Id;
				Statement stt1 = con.createStatement();
				ResultSet rset = stt1.executeQuery(ReqAbonnement);

				rset.next();
				cellEntete.setPhrase(new Phrase(rset.getString("Libelle")));
				cellEntete.setColspan(3);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);


				PdfPCell cellBandeau = new PdfPCell(entete);
				cellBandeau.setPadding(10);

				bandeau.addCell(cellBandeau);

				document.add(bandeau);

				// fin Entete G\u00E9n\u00E9rale

				PdfPTable bande;
				bande = new PdfPTable(1);
				bande.setWidthPercentage(100);

				PdfPCell cellBande = new PdfPCell(bande.getDefaultCell());


				cellBande.setFixedHeight(6);
				cellBande.setBorder(PdfPCell.NO_BORDER);
				cellBande.setPhrase(new Phrase(""));
				cellBande.setPhrase(new Phrase(""));

				bande.addCell(cellBande);

				document.add(bande);

				//informations sur l'abonnement

					PdfPTable infoAbonnement = new PdfPTable(1);
					infoAbonnement.setWidthPercentage(100);

					putAbonnements(infoAbonnement);
					document.add(infoAbonnement);


				PdfPTable bande2;
				bande2 = new PdfPTable(1);
				bande2.setWidthPercentage(100);

				PdfPCell cellBande2 = new PdfPCell(bande2.getDefaultCell());


				cellBande2.setFixedHeight(6);
				cellBande2.setBorder(PdfPCell.NO_BORDER);
				cellBande2.setPhrase(new Phrase(""));
				cellBande2.setPhrase(new Phrase(""));

				bande2.addCell(cellBande2);

				document.add(bande2);

				// Titres de colonnes
				PdfPTable titresColonnes;

				titresColonnes = new PdfPTable(6);
				titresColonnes.setWidthPercentage(100);
				titresColonnes.setWidths(widthsListe);

				PdfPCell cellTitre = new PdfPCell(titresColonnes.getDefaultCell());

				cellTitre.setBackgroundColor(Color.LIGHT_GRAY);
				cellTitre.setColspan(6);
				cellTitre.setBorder(PdfPCell.BOX);
				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				cellTitre.setPhrase(new Phrase("ETAT DES ECHEANCES", fontGen));
				titresColonnes.addCell(cellTitre);

				cellTitre.setColspan(1);
				cellTitre.setBorder(PdfPCell.BOX);
				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				cellTitre.setPhrase(new Phrase("Num\u00E9ro Ech\u00E9ance", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				cellTitre.setBorder(PdfPCell.BOX);
				cellTitre.setPhrase(new Phrase("P\u00E9riode factur\u00E9e", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setBorder(PdfPCell.BOX);
				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				cellTitre.setPhrase(new Phrase("N\u00B0 Facture", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				cellTitre.setBorder(PdfPCell.BOX);
				cellTitre.setPhrase(new Phrase("Total HT", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				cellTitre.setBorder(PdfPCell.BOX);
				cellTitre.setPhrase(new Phrase("Montant TTC", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				cellTitre.setBorder(PdfPCell.BOX);
				cellTitre.setPhrase(new Phrase("Etat", fontLine));
				titresColonnes.addCell(cellTitre);

				document.add(titresColonnes);

				// fin Titres de colonnes

			} catch(DocumentException de) {
        de.printStackTrace();
			} catch(SQLException se) {
        se.printStackTrace();
			}
		}
		
		//ajoute les informations de l'abonnement
	private void putAbonnements(PdfPTable infoAbonnement) throws SQLException {
	try {

				String ReqAbonnement = "select a.*, mr.Libelle as Mode_Reglement, m.Reference_Modele, p.Nom_FR, u1.Login as Login_Createur, u2.Login as Login_Maj, coalesce(u3.Login,'') as Login_Resp from "+ base + ".ABONNEMENT a left join UTILISATEUR u3 on a.Util_R=u3.Utilisateur_Id,";
				ReqAbonnement += base +".MODELE m, "+ base +".MODE_REGLEMENT mr, PAYS p, UTILISATEUR u1, UTILISATEUR u2";
				ReqAbonnement += " where a.Modele_Id=m.Modele_Id and a.Mode_Reg_Id=mr.Mode_Reg_Id and a.Util_C=u1.Utilisateur_Id and a.Util_M=u2.Utilisateur_Id and a.Code_Pays=p.Code_Pays and a.Abonnement_Id="+Abonnement_Id;
				Statement stt1 = con.createStatement();
				ResultSet rset = stt1.executeQuery(ReqAbonnement);

				if (rset.next()) {

				String Num_Entier = rset.getString("Num_Entier");
				String Reference_modele = rset.getString("Reference_modele");
				String Libelle = rset.getString("Libelle");
				int Type_contrat = rset.getInt("Type_contrat");
				long Date_debut_abonnement = rset.getLong("Date_debut_abonnement");
				long Date_fin_abonnement = rset.getLong("Date_fin_abonnement");
				String Mode_reglement = rset.getString("Mode_Reglement");
				String etatStr = rset.getString("Etat");
				char Etat = etatStr.charAt(0);
				String Denomination = rset.getString("Denomination");
				String Adresse = rset.getString("Adresse_1");
				String Comp_Adresse = rset.getString("Adresse_2");
				String codePostal = rset.getString("Code_Postal");
				String Ville = rset.getString("Ville");
				String Pays = rset.getString("Nom_FR");
				String Client_Id = rset.getString("Client_Id");

		SimpleDateFormat formatDatePoint = new SimpleDateFormat("dd/MM/yyyy");

		PdfPTable infoAbo = new PdfPTable(2);
		infoAbo.setWidths(widthsAbo);

		PdfPCell cellinfoAbonnement = new PdfPCell(infoAbo.getDefaultCell());

		cellinfoAbonnement.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

		cellinfoAbonnement.setBorder(PdfPCell.BOX);
		cellinfoAbonnement.setPaddingRight(0);
		cellinfoAbonnement.setBackgroundColor(Color.LIGHT_GRAY);
		cellinfoAbonnement.setColspan(2);
		cellinfoAbonnement.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellinfoAbonnement.setPhrase(new Phrase("RECAPITULATIF ABONNEMENT ", fontGen));
		infoAbo.addCell(cellinfoAbonnement);

		cellinfoAbonnement.setBorder(PdfPCell.NO_BORDER);
		cellinfoAbonnement.setPaddingLeft(10);
		cellinfoAbonnement.setBackgroundColor(Color.WHITE);
		cellinfoAbonnement.setColspan(1);

		cellinfoAbonnement.setPaddingRight(0);
		cellinfoAbonnement.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellinfoAbonnement.setPhrase(new Phrase("N\u00B0 Abonnement : " +Num_Entier, fontLine));
		infoAbo.addCell(cellinfoAbonnement);

		cellinfoAbonnement.setPhrase(new Phrase(!Client_Id.equals("")?"Client N\u00B0 " + Client_Id:"", fontLine));
		infoAbo.addCell(cellinfoAbonnement);

		cellinfoAbonnement.setPhrase(new Phrase("R\u00E9f\u00E9rence mod\u00E8le : "+ Reference_modele, fontLine));
		infoAbo.addCell(cellinfoAbonnement);

		cellinfoAbonnement.setPhrase(new Phrase("Raison sociale : " + Denomination, fontLine));
		infoAbo.addCell(cellinfoAbonnement);

		cellinfoAbonnement.setPhrase(new Phrase("Libell\u00E9 : " +Libelle, fontLine));
		infoAbo.addCell(cellinfoAbonnement);

		cellinfoAbonnement.setPhrase(new Phrase("Adresse : " + Adresse, fontLine));
		infoAbo.addCell(cellinfoAbonnement);

		cellinfoAbonnement.setPhrase(new Phrase("Date d\u00E9but : "+ formatDatePoint.format(new Date(Date_debut_abonnement)), fontLine));
		infoAbo.addCell(cellinfoAbonnement);

		cellinfoAbonnement.setPhrase(new Phrase(Comp_Adresse, fontLine));
		infoAbo.addCell(cellinfoAbonnement);

		cellinfoAbonnement.setPhrase(new Phrase("Date fin : "+formatDatePoint.format(new Date(Date_fin_abonnement)), fontLine));
		infoAbo.addCell(cellinfoAbonnement);

		cellinfoAbonnement.setPhrase(new Phrase(codePostal + " " + Ville, fontLine));
		infoAbo.addCell(cellinfoAbonnement);

		String EtatAbo = "En attente";
		switch(Etat){
			case 'C':EtatAbo="En cours";break;
			case 'T':EtatAbo="Termin\u00E9";break;
			case 'R':EtatAbo="R\u00E9sili\u00E9";break;
		}

		cellinfoAbonnement.setPhrase(new Phrase("Etat : "+EtatAbo, fontLine));
		infoAbo.addCell(cellinfoAbonnement);

		cellinfoAbonnement.setPhrase(new Phrase(Pays, fontLine));
		infoAbo.addCell(cellinfoAbonnement);

		String TypeContrat = "Sans reconduction";
		if (Type_contrat == 2) {
			TypeContrat="Reconduction tacite";
		}
		else if (Type_contrat == 3) {
			TypeContrat="Reconduction sur demande";
		}

		cellinfoAbonnement.setPhrase(new Phrase("Type de contrat  : " + TypeContrat, fontLine));
		infoAbo.addCell(cellinfoAbonnement);

		cellinfoAbonnement.setPhrase(new Phrase("Mode de r\u00E8glement : " + Mode_reglement, fontLine));
		infoAbo.addCell(cellinfoAbonnement);

		PdfPCell cellInfo = new PdfPCell(infoAbo);
		infoAbonnement.addCell(cellInfo);

		}

	}
	catch (Exception e) {
    e.printStackTrace();
  }
}

		public void onEndPage(PdfWriter writer, Document document) {}
		public void onOpenDocument(PdfWriter writer, Document document) {}
    public void onCloseDocument(PdfWriter writer, Document document) {}
    public void onParagraph(PdfWriter writer, Document document, float paragraphPosition) {}
    public void onParagraphEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onChapter(PdfWriter writer,Document document,float paragraphPosition, Paragraph title) {}
    public void onChapterEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onSection(PdfWriter writer,Document document,float paragraphPosition, int depth, Paragraph title) {}
    public void onSectionEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onGenericTag(PdfWriter writer, Document document, Rectangle rect, String text) {}

	}



private static final Font fontGen = new Font(Font.HELVETICA , 10, Font.NORMAL);		// font pour lignes d'entete
private static final Font fontLine = new Font(Font.HELVETICA , 8, Font.NORMAL);		// font pour lignes de listing
private DecimalFormat numFormat = new DecimalFormat("0.00");
private DecimalFormat intFormat = new DecimalFormat("");
private SimpleDateFormat formatDatePoint = new SimpleDateFormat("dd.MM.yy");


private String base;
private int Abonnement_Id;

private int nbEcheanceEnAttente=0;
private int nbEcheanceGenere=0;


private int widthsAbo[] = {60,30};
private int widthsListe[] = {12,20,12,12,12,12}; // largeurs des colonnes du listing

// parametres dynamiques pour l'entete

  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {

		try {
		con = s.getConnection(null);

		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator('.');
		dfs.setGroupingSeparator(' ');

		numFormat.setDecimalFormatSymbols(dfs);
		numFormat.setNegativeSuffix("-");
		numFormat.setNegativePrefix("");
		numFormat.setPositiveSuffix(" ");
		numFormat.setGroupingUsed(true);
		numFormat.setGroupingSize(3);

		String dossierId = s.getCookie().get("Dossier_Id");
		base = s.getCookie().get("BaseDossier");
		String id = r.getParameter("id");

		Abonnement_Id = Integer.parseInt(r.getParameter("Abonnement_Id"));
		

		PdfPTable listing;
		PdfPTable footer;

		Document document = new Document(PageSize.A4, 20, 20, 20, 20);

		String chemin = s.getAppConfiguration().get("opensi.absdir") + "/pdf/";

		String fichierPdf = "Abonnement_"+ id +".pdf";

		PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(chemin + fichierPdf));

   	listing = new PdfPTable(6);
   	listing.setWidthPercentage(100);
		listing.setWidths(widthsListe);

		footer = new PdfPTable(1);
		footer.setWidthPercentage(100);


		MyPageEvent event = new MyPageEvent(dossierId);
    writer.setPageEvent(event);


		String Echeances = "select ea.*, coalesce(f.Num_Entier,'') as Num_Entier_Facture from "+ base + ".ECHEANCE_ABONNEMENT ea";
		Echeances += " left join "+ base +".FACTURE f on ea.Facture_Id=f.Facture_Id where ea.Abonnement_Id="+ Abonnement_Id +" order by ea.NumEcheance";
		Statement stt2 = con.createStatement();
    ResultSet rset2 = stt2.executeQuery(Echeances);

		while(rset2.next()) {
			int 		NumEcheance = rset2.getInt("NumEcheance");
			long 		Date_Debut = rset2.getLong("Date_Debut");
			long 		Date_Fin = rset2.getLong("Date_Fin");
			String 	Num_Entier_Facture = rset2.getString("Num_Entier_Facture");
			double 	Total_HT = rset2.getDouble("Total_HT");
			double 	MontantTTC = rset2.getDouble("MontantTTC");
			String etatStrEcheance = rset2.getString("Etat");
			char EtatEcheance = etatStrEcheance.charAt(0);
			String TypeStr = rset2.getString("Type");
			char Type = TypeStr.charAt(0);
			putLigneEcheance(listing,NumEcheance,Date_Debut,Date_Fin,Num_Entier_Facture,Total_HT,MontantTTC,EtatEcheance,Type);

		}

    if (!document.isOpen()) {
      document.open();
    }
		document.add(listing);
		makeFooter(footer);
		document.add(footer);

		if (document.isOpen()) {
    	document.close();
		}
		s.closeConnection(con, null);

		try {
			File filePdf = new File(chemin, fichierPdf);
			filePdf.deleteOnExit();
		}
		catch(SecurityException se) {
			s.trace("Impossible d'enregistrer le fichier \u00E0 supprimer");
			se.printStackTrace();
		}

    } catch (Exception e) {
      e.printStackTrace();
    }
		return true;


	} // fin service



	private void putLigneEcheance(PdfPTable listing,int NumEcheance,long Date_Debut,long Date_Fin,
																String Num_Entier,double Total_HT,double MontantTTC,char Etat,char Type) {


		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

		cellListing.setPaddingLeft(5);
		cellListing.setPaddingRight(5);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPhrase(new Phrase(intFormat.format(NumEcheance), fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);

		if (Type=='N')
			cellListing.setPhrase(new Phrase(formatDatePoint.format(new Date(Date_Debut))+" - "+
																					formatDatePoint.format(new Date(Date_Fin)),fontLine));
		else
			cellListing.setPhrase(new Phrase("Rachat de l'article le : "+
																					formatDatePoint.format(new Date(Date_Fin)),fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPhrase(new Phrase(Num_Entier, fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase(numFormat.format(Total_HT), fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase(numFormat.format(MontantTTC), fontLine));
		listing.addCell(cellListing);

		String EtatComp = "annul\u00E9";
		if (Etat == 'E') {
			EtatComp="en attente";
			nbEcheanceEnAttente++;
		}
		else if (Etat == 'G') {
			EtatComp="g\u00E9n\u00E9r\u00E9";
			nbEcheanceGenere++;
		}
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPhrase(new Phrase(EtatComp, fontLine));
		listing.addCell(cellListing);
	}
	

	private void makeFooter(PdfPTable footer) {

		PdfPTable infoFooter = new PdfPTable(2);

		PdfPCell cellfooter = new PdfPCell(infoFooter.getDefaultCell());

		cellfooter.setPaddingLeft(120);
		cellfooter.setBorder(PdfPCell.NO_BORDER);
		cellfooter.setBackgroundColor(Color.LIGHT_GRAY);
		cellfooter.setPaddingRight(0);
		cellfooter.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellfooter.setPhrase(new Phrase("", fontLine));
		infoFooter.addCell(cellfooter);

		cellfooter.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		if (nbEcheanceGenere!=1)
			cellfooter.setPhrase(new Phrase(nbEcheanceGenere+" \u00E9ch\u00E9ances ont \u00E9t\u00E9 g\u00E9n\u00E9r\u00E9es", fontLine));
		else
			cellfooter.setPhrase(new Phrase(nbEcheanceGenere+" \u00E9ch\u00E9ance a \u00E9t\u00E9 g\u00E9n\u00E9r\u00E9e", fontLine));
		infoFooter.addCell(cellfooter);


		cellfooter.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellfooter.setPhrase(new Phrase("", fontLine));
		infoFooter.addCell(cellfooter);

		cellfooter.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		if (nbEcheanceGenere!=1)
			cellfooter.setPhrase(new Phrase(intFormat.format(nbEcheanceEnAttente)+" \u00E9ch\u00E9ances sont en attente", fontLine));
		else
			cellfooter.setPhrase(new Phrase(intFormat.format(nbEcheanceEnAttente)+" \u00E9ch\u00E9ance est en attente", fontLine));
		infoFooter.addCell(cellfooter);

		PdfPCell cellBarre = new PdfPCell(infoFooter);

		footer.addCell(cellBarre);
	}
	

} // fin GenImprimerAbonnement
