/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un bon de reliquats
 */

package org.opensi.facturation.actions.documents;


import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.facturation.actions.documents.modeles.BonReliquatsStd;
import org.opensi.facturation.actions.documents.modeles.DataBonReliquats;
import org.opensi.util.pdf.GlobalDocument;


public class GenBonReliquats extends Action {


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {
	
	  	String fichierPdf = r.getParameter("FichierPdf");
		String absdir = s.getAppConfiguration().get("opensi.absdir");
		String base = s.getCookie().get("BaseDossier");
		
		String repPdf = absdir +"/pdf/";
		String repTemp = repPdf;
		
		GlobalDocument gd = new GlobalDocument(repPdf, fichierPdf);
		
		boolean bonChiffre = (r.getParameter("Chiffre").equals("1"));
		String fournisseurId = r.getParameter("Fournisseur_Id");
		if (fournisseurId.equals("T")) {
			// parcourir tous les fournisseurs concerns
			
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			
			String reqFournisseurs = "select distinct Fournisseur_Id from";
			reqFournisseurs += " (select c.Fournisseur_Id, sum(ac.Quantite)- BON.BR as Quantite";
			reqFournisseurs += " from (select ac.Reference, ac.Prix, c.Num_Entier, coalesce(sum(abr.Quantite),0) as BR";
			reqFournisseurs += " from "+ base +".COMMANDE_FOURNISSEUR c, "+ base +".LIGNE_COMMANDE_FOURNISSEUR ac";
			reqFournisseurs += " left join "+ base +".LIGNE_BON_RECEPTION abr on ac.ligne_Id=abr.Ref_Ligne";
			reqFournisseurs += " left join "+ base +".BON_RECEPTION br on br.BR_Id=abr.BR_Id and br.Etat='V'";
			reqFournisseurs += " where ac.Commande_Id=c.Commande_Id and c.Etat='V' and ac.Type_Ligne='S'";
			reqFournisseurs += " group by ac.Reference, ac.Prix, c.Num_Entier) as BON,";
			reqFournisseurs += " "+ base +".COMMANDE_FOURNISSEUR c, "+ base +".LIGNE_COMMANDE_FOURNISSEUR ac";
			reqFournisseurs += " where ac.Commande_Id=c.Commande_Id and c.Etat='V' and ac.Type_Ligne='S'";
			reqFournisseurs += " and BON.Reference=ac.Reference and BON.Num_Entier=c.Num_Entier";
			reqFournisseurs += " group by ac.Reference, ac.Prix, c.Num_Entier";
			reqFournisseurs += " having Quantite>0) as t order by Fournisseur_Id";
			
			ResultSet rset = stt.executeQuery(reqFournisseurs);
			while (rset.next()) {
				BonReliquatsStd bon = new BonReliquatsStd(repTemp, new DataBonReliquats(s, rset.getString("Fournisseur_Id")), bonChiffre);
				gd.addInternal(bon);
			}
			rset.close();
			stt.close();
			s.closeConnection(con, null);
		} else {
			BonReliquatsStd bon = new BonReliquatsStd(repTemp, new DataBonReliquats(s, fournisseurId), bonChiffre);
			gd.addInternal(bon);
		}
		
		gd.close(GlobalDocument.ON_EXIT);
	
		return true;
		
	} // fin service


} // fin GenBonReliquats
