/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un bon de prparation
 */

package org.opensi.facturation.actions.documents;


import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.facturation.actions.documents.modeles.BonPreparationPDF;
import org.opensi.facturation.actions.documents.modeles.BonPreparationStd;
import org.opensi.facturation.actions.documents.modeles.DataBonPreparation;
import org.opensi.util.pdf.GlobalDocument;


public class GenBonPreparation extends Action {


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {
	
		String fichierPdf = "bp_"+ r.getParameter("Document_Id") +".pdf";
		String absdir = s.getAppConfiguration().get("opensi.absdir");
		String base = s.getCookie().get("BaseDossier");
		
		String repPdf = absdir +"/pdf/";
		String repTemp = repPdf;
		
		String reqModele = "select mbp.Modele_Id, mbp.Class from "+ base +".MODELE_BON_PREPARATION mbp, "+ base +".PARAM_DOSSIER d";
		reqModele += " where mbp.Modele_Id=d.Modele_Pdf_BP";
		Connection con = s.getConnection(null);
		Statement stt = con.createStatement();
		ResultSet rset = stt.executeQuery(reqModele);
		rset.next();
		String modele = rset.getString("Modele_Id");
		String chemin = rset.getString("Class");
		rset.close();
		stt.close();
		s.closeConnection(con, null);
		
		GlobalDocument gd = new GlobalDocument(repPdf, fichierPdf);
		
		String bonId = r.getParameter("Bon_Id");
		
		//boolean multi = r.getParameter("MultiEx")!=null;
		//String[] factures = r.getParameter("Liste_Facture").split(",");
		
		//for (int z=0;z<factures.length;z++) {
		
			BonPreparationPDF bonPreparation;
			DataBonPreparation dbp = new DataBonPreparation(s, bonId);
			if (modele.equals("STD01")) {
				bonPreparation = new BonPreparationStd(repTemp, dbp);
			}
			else {
				Object[] o = {repTemp, dbp};
				Class<?> cl = Class.forName(chemin);
				Constructor<?> c = cl.getConstructors()[0];
				bonPreparation = (BonPreparationPDF)c.newInstance(o);
			}
			//facture.setMultiEx(multi);
	
			gd.addInternal(bonPreparation);
		//}	
		
		gd.close(GlobalDocument.ON_EXIT);
	
		return true;
		
	} // fin service


} // fin GenBonPreparation
