/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.dbm.exercice;


import java.sql.*;

import org.opensi.api.*;

import org.opensi.data.exercice.SoldeCompte;


public class DBM_SoldeCompte implements DBM_Object {

	private Connection con;
	private String baseExo;

	private PreparedStatement psNewSC;
	

	public DBM_SoldeCompte(Connection con, String baseExo) {
	
		this.con = con;
		this.baseExo = baseExo;
	}
		
	
	public void insert(SoldeCompte soldeCompte) throws SQLException {
	
		if (psNewSC==null) {
			psNewSC = con.prepareStatement("insert into "+ baseExo +".SOLDE_COMPTE (Numero_Compte,Lettre,Total_Debit,Total_Credit,Solde) values (?,?,?,?,Total_Debit-Total_Credit)");
		}
					
		psNewSC.setString(1, soldeCompte.getNumeroCompte());
		psNewSC.setString(2, soldeCompte.getLettre());
		psNewSC.setDouble(3, soldeCompte.getTotalDebit());
		psNewSC.setDouble(4, soldeCompte.getTotalCredit());
		
		psNewSC.executeUpdate();
	}
	
	
	public void delete(String numeroCompte) throws SQLException {
	
		PreparedStatement psSupSolde = con.prepareStatement("delete from "+ baseExo +".SOLDE_COMPTE where Numero_Compte=?");
			
		psSupSolde.setString(1, numeroCompte);
		psSupSolde.executeUpdate();			
		psSupSolde.close();
	}
	
	
	public String getLettre(String numeroCompte) throws SQLException {
	
		PreparedStatement psGetLet = con.prepareStatement("select Lettre from "+ baseExo +".SOLDE_COMPTE where Numero_Compte=?");
		psGetLet.setString(1, numeroCompte);
		ResultSet rsL = psGetLet.executeQuery();
		rsL.next();
		String lettre = rsL.getString(1); 
		psGetLet.close();
		
		return lettre;
	}
	
	
	public void setLettre(String numeroCompte, String lettre) throws SQLException {
		
		PreparedStatement psSetLet = con.prepareStatement("update "+ baseExo +".SOLDE_COMPTE set Lettre=? where Numero_Compte=?");
		psSetLet.setString(1, lettre);
		psSetLet.setString(2, numeroCompte);
		psSetLet.executeUpdate();
		psSetLet.close();
	}
	
	
	protected void finalize() throws SQLException {
		
		if (psNewSC!=null) psNewSC.close();
	}
	
	
} // fin DBM_SoldeCompte
