/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.dbm.dossier;


import java.sql.*;

import org.opensi.api.*;

import org.opensi.data.dossier.Journal;


public class DBM_Journal implements DBM_Object {

	private Connection con;
	private String baseDossier;

	
	public DBM_Journal(Connection con, String baseDossier) {
		
		this.baseDossier = baseDossier;
		this.con = con;		
	}

	
	public boolean exist(String codeJournal) throws SQLException {
		
		PreparedStatement psExJournal = con.prepareStatement("select 1 from "+ baseDossier +".JOURNAL where Code_Journal=?");
			
		psExJournal.setString(1, codeJournal);
		ResultSet rsEJ = psExJournal.executeQuery();
		
		boolean exist = rsEJ.next();
		
		psExJournal.close();
		
		return exist;
	}


	public Journal load(String codeJournal) throws SQLException {
	
		Journal journal = null;
	
		PreparedStatement psLoad = con.prepareStatement("select * from "+ baseDossier +".JOURNAL where Code_Journal=?");
		
		psLoad.setString(1, codeJournal);
		ResultSet rset = psLoad.executeQuery();
		
		if (rset.next()) {			
			journal = new Journal();
			
			journal.setCodeJournal(rset.getString("Code_Journal"));
			journal.setIntitule(rset.getString("Intitule"));
			journal.setTypeJournal(rset.getString("Type_Journal"));
			journal.setContrepartie(rset.getString("Contrepartie"));																
		}
		
		return journal;
	}
	
	
	public void insert(Journal journal) throws SQLException {
	
		PreparedStatement psNewJournal = con.prepareStatement("insert into "+ baseDossier +".JOURNAL (Code_Journal, Intitule, Type_Journal, Contrepartie) values (?,?,?,?)");
				
		psNewJournal.setString(1, journal.getCodeJournal());
		psNewJournal.setString(2, journal.getIntitule());
		psNewJournal.setString(3, journal.getTypeJournal());
		psNewJournal.setString(4, journal.getContrepartie());
		psNewJournal.executeUpdate();
		psNewJournal.close();
	}
	
	
	public void update(Journal journal) throws SQLException {
	
		PreparedStatement psMajJournal = con.prepareStatement("update "+ baseDossier +".JOURNAL set Intitule=?, Type_Journal=?, Contrepartie=? where Code_Journal=?");				
				
		psMajJournal.setString(1, journal.getIntitule());
		psMajJournal.setString(2, journal.getTypeJournal());
		psMajJournal.setString(3, journal.getContrepartie());
		psMajJournal.setString(4, journal.getCodeJournal());
		psMajJournal.executeUpdate();
		psMajJournal.close();
	}
	
	
	public void delete(String codeJournal) throws SQLException {
	
		PreparedStatement psSupJournal = con.prepareStatement("delete from "+ baseDossier +".JOURNAL where Code_Journal=?");
		
		psSupJournal.setString(1, codeJournal);
		psSupJournal.executeUpdate();
		psSupJournal.close();
	}
	
	
	public String getTypeJournal(String codeJournal) throws SQLException {
		
		String typeJournal = null;
		
		PreparedStatement psTJ = con.prepareStatement("select Type_Journal from "+ baseDossier +".JOURNAL where Code_Journal=?");
		
		psTJ.setString(1, codeJournal);
		ResultSet rset = psTJ.executeQuery();
		if (rset.next()) {
			typeJournal = rset.getString(1);
		}
		
		psTJ.close();
		
		return typeJournal;
	} 
	

} // fin DBM_Journal
