/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.data.exercice;


import java.util.HashMap;
import java.util.Iterator;

import org.opensi.util.tools.Arrondi;
import org.opensi.util.tools.DateTime;


public class Ecriture implements org.opensi.api.DataOSI {


	private String codeJournal;
	private long dateEcriture = 0;
	private int ecritureId = 0;
	private int numero = 0;
	private Arrondi rd = new Arrondi(2);

	private HashMap<Integer, Operation> operations = new HashMap<Integer, Operation>(3);


	public Ecriture() {}


	public String getCodeJournal() { return codeJournal; }
	public long getDateEcriture() { return dateEcriture; }
	public int getEcritureId() { return ecritureId;	}
	public int getNumero() { return numero; }


	public void setDateEcriture(long dateEcriture) { this.dateEcriture = normalisePeriode(dateEcriture); }
	public void setCodeJournal(String codeJournal) { this.codeJournal = codeJournal; }
	public void setEcritureId(int ecritureId) {	this.ecritureId = ecritureId; if (ecritureId==0) this.numero = 0; }
	public void setNumero(int numero) {	this.numero = numero; }



	public HashMap<Integer, Operation> getOperations() { return operations; }

	public int getSize() { return operations.size(); }


	public Operation getOp(int index) {

		return operations.get(new Integer(index));
	}

	public void addOperation(Operation operation) {

		if (operation.getNumLigne() == 0 || operations.containsKey(operation.getNumLigne())) {
			int i = operations.size();
			while (operations.containsKey(new Integer(i))) {
				i++;
			}
			operation.setNumLigne(i);
		}
		operations.put(new Integer(operation.getNumLigne()), operation);
	}


	private long normalisePeriode(long date) {
		
		DateTime dt = new DateTime(date);
		dt.setDay(1);
		return dt.getDateInMillis();
	}	


	public double totalCredit() {

		double credit = 0;
		
		Iterator i = operations.keySet().iterator();
		
		while (i.hasNext()) {
			Operation op = operations.get(i.next());
			credit += op.getMontantC();
		}
		return rd.round(credit);
	}
	
	
	public double totalDebit() {

		double debit = 0;
		
		Iterator i = operations.keySet().iterator();
		
		while (i.hasNext()) {
			Operation op = operations.get(i.next());
			debit += op.getMontantD();
		}
		return rd.round(debit);
	}


	public boolean isValid() {

		double debit = 0;
		double credit = 0;
		
		Iterator i = operations.keySet().iterator();
		
		while (i.hasNext()) {
			Operation op = operations.get(i.next());
			if (!op.isValid()) {
				return false;
			}
			debit = rd.round(op.getMontantD() + debit);
			credit = rd.round(op.getMontantC() + credit);
		}

		return (debit==credit) && (codeJournal!=null) && (dateEcriture>0) && operations.size()>1;
		// (dateEcriture>0) --> isPeriode ?? isCodeJournal ???
	}


	


	// pour debugger
	public void printEcriture() {

		System.out.println("Ecriture\n");
		
		Iterator i = operations.keySet().iterator();

		while (i.hasNext()) {
			Operation op = operations.get(i.next());
			op.printOperation();
		}
	}


} // fin Ecriture
