/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.data.dossier;

import java.util.HashMap;

import org.opensi.util.tools.DateTime;


public class LigneCommandeClient {


	private int ligneId;
	private int rank;
	private String typeLigne;
	private String reference;
	private String designation;
	private String codeStats;
	private String numLot;
	private String libelle;
	private double quantite;
	private String unite;
	private int nbPieces;
	private long datePeremption;
	private double prix;
	private double ristourne;
	private int codeTVA;
	private double tauxTVA;
	private double commission;
	private double prixAchat;
	private double montantLigne;
	private boolean soldee;
	private String commentaireAvant;
	private String commentaireApres;
	private int articleWebId;
	private String statut;
	private double margeLigne;


	public LigneCommandeClient() {
		this.ligneId = 0;
		this.rank = 0;
		this.typeLigne = "I";
		this.reference = "";
		this.designation = "";
		this.codeStats = "";
		this.numLot = "";
		this.libelle = "";
		this.quantite = 0;
		this.unite = "U";
		this.nbPieces = 0;
		this.datePeremption = 0;
		this.ristourne = 0;
		this.codeTVA = 1;
		this.tauxTVA = 0;
		this.commission = 0;
		this.prixAchat = 0;
		this.montantLigne = 0;
		this.soldee = false;
		this.commentaireAvant = "";
		this.commentaireApres = "";
		this.statut = "V";
		this.articleWebId = 0;
		this.margeLigne = 0;
	}

	public LigneCommandeClient(int ligneId,
			int rank,
			String typeLigne,
			String reference,
			String designation,
			String codeStats,
			String numLot,
			String libelle,
			double quantite,
			String unite,
			int nbPieces,
			long datePeremption,
			double prix,
			double ristourne,
			int codeTVA,
			double tauxTVA,
			double commission,
			double prixAchat,
			double montantLigne,
			boolean soldee,
			String commentaireAvant,
			String commentaireApres,
			String statut,
			int articleWebId,
			double margeLigne) {

		this.ligneId = ligneId;
		this.rank = rank;
		this.typeLigne = typeLigne;
		this.reference = reference;
		this.designation = designation;
		this.codeStats = codeStats;
		this.numLot = numLot;
		this.libelle = libelle;
		this.quantite = quantite;
		this.unite = unite;
		this.nbPieces = nbPieces;
		this.datePeremption = datePeremption;
		this.prix = prix;
		this.ristourne = ristourne;
		this.codeTVA = codeTVA;
		this.tauxTVA = tauxTVA;
		this.commission = commission;
		this.prixAchat = prixAchat;
		this.montantLigne = montantLigne;
		this.soldee = soldee;
		this.commentaireAvant = commentaireAvant;
		this.commentaireApres = commentaireApres;
		this.statut = statut;
		this.articleWebId = articleWebId;
		this.margeLigne = margeLigne;
	}

	public boolean isValid() {

		return true;
	}

	public HashMap<String, String> diff(LigneCommandeClient ligneCommandeClient) {
		HashMap<String, String> diff = new HashMap<String, String>();

		if (this.equals(ligneCommandeClient)) {
			return diff;
		}
		if (getRank()!=ligneCommandeClient.getRank()) {
			String valeur = "Numro de Ligne modifi de "+ligneCommandeClient.getRank()+"  "+getRank();
			diff.put("Rank",valeur); 
		}
		if (!getTypeLigne().equals(ligneCommandeClient.getTypeLigne())) {
			String valeur = "Type de ligne modifi de "+(ligneCommandeClient.getTypeLigne().equals("S")?"gestion de stock":"hors stock")+"  "+(getTypeLigne().equals("S")?"gestion de stock":"hors stock");
			diff.put("TypeLigne", valeur); 
		}	
		if (!getReference().equals(ligneCommandeClient.getReference())) {
			String valeur = "Rfrence modifi de "+ligneCommandeClient.getReference()+"  "+getReference();
			diff.put("Reference",valeur); 
		}	
		if (!getDesignation().equals(ligneCommandeClient.getDesignation())) {
			String valeur = "Dsignation modifi de "+ligneCommandeClient.getDesignation()+"  "+getDesignation();
			diff.put("Designation",valeur); 
		}	
		if (!getCodeStats().equals(ligneCommandeClient.getCodeStats())) {
			String valeur = "Code statistique modifi de "+ligneCommandeClient.getCodeStats()+"  "+getCodeStats();
			diff.put("CodeStats",valeur); 
		}	
		if (!getNumLot().equals(ligneCommandeClient.getNumLot())) {
			String valeur = "Numro de lot modifi de "+ligneCommandeClient.getNumLot()+"  "+getNumLot();
			diff.put("NumLot",valeur); 
		}	
		if (!getLibelle().equals(ligneCommandeClient.getLibelle())) {
			String valeur = "libell modifi de "+ligneCommandeClient.getLibelle()+"  "+getLibelle();
			diff.put("Libelle",valeur); 
		}	
		if (getQuantite()!=ligneCommandeClient.getQuantite()) {
			String valeur = "Quantit modifi de "+ligneCommandeClient.getQuantite()+"  "+getQuantite();
			diff.put("Quantite",valeur); 
		}
		if (!getUnite().equals(ligneCommandeClient.getUnite())) {
			//String valeur = "Unit modifi de "+ligneCommandeClient.getUnite().getUnit()+"  "+getUnite().getUnit();
			//diff.put("Unite",valeur); 
		}
		if (getNbPieces()!=ligneCommandeClient.getNbPieces()) {
			String valeur = "Nombre de pices modifi de "+ligneCommandeClient.getNbPieces()+"  "+getNbPieces();
			diff.put("NbPieces",valeur); 
		}
		if (getDatePeremption()!=ligneCommandeClient.getDatePeremption()) {
			String valeur = "Date de premption modifi de "+ DateTime.formatTime(ligneCommandeClient.getDatePeremption(), "dd/MM/yyyy") +"  "+DateTime.formatTime(getDatePeremption(), "dd/MM/yyyy");
			diff.put("DatePeremption",valeur); 
		}
		if (getPrix()!=ligneCommandeClient.getPrix()) {
			String valeur = "Prix modifi de "+ligneCommandeClient.getPrix()+"  "+getPrix();
			diff.put("Prix",valeur); 
		}
		if (getRistourne()!=ligneCommandeClient.getRistourne()) {
			String valeur = "Ristourne modifi de "+ligneCommandeClient.getRistourne()+"  "+getRistourne();
			diff.put("Ristourne",valeur); 
		}
		if (getTauxTVA()!=ligneCommandeClient.getTauxTVA()) {
			String valeur = "Taux TVA modifi de "+ligneCommandeClient.getTauxTVA()+"  "+getTauxTVA();
			diff.put("TauxTVA",valeur); 
		}
		if (getCommission()!=ligneCommandeClient.getCommission()) {
			String valeur = "Taux de commission modifi de "+ligneCommandeClient.getCommission()+"  "+getCommission();
			diff.put("Commission",valeur); 
		}
		if (!getCommentaireAvant().equals(ligneCommandeClient.getCommentaireAvant())) {
			String valeur = "Commentaire avant modifi de "+ligneCommandeClient.getCommentaireAvant()+"  "+getCommentaireAvant();
			diff.put("CommentaireAvant",valeur); 
		}
		if (!getCommentaireApres().equals(ligneCommandeClient.getCommentaireApres())) {
			String valeur = "Commentaire aprs modifi de "+ligneCommandeClient.getCommentaireApres()+"  "+getCommentaireApres();
			diff.put("CommentaireApres",valeur); 
		}

		return diff;
	}


	public int getLigneId() { return ligneId; }
	public int getRank() { return rank; }
	public String getTypeLigne() { return typeLigne; }
	public String getReference() { return reference; }
	public String getDesignation() { return designation; }
	public String getCodeStats() { return codeStats; }
	public String getNumLot() { return numLot; }
	public String getLibelle() { return libelle; }
	public double getQuantite() { return quantite; }
	public String getUnite() { return unite; }
	public int getNbPieces() { return nbPieces; }
	public long getDatePeremption() { return datePeremption; }
	public double getPrix() { return prix; }
	public double getRistourne() { return ristourne; }
	public int getCodeTVA() { return codeTVA; }
	public double getTauxTVA() { return tauxTVA; }
	public double getCommission() { return commission; }
	public double getPrixAchat() { return prixAchat; }
	public double getMontantLigne() { return montantLigne; }
	public boolean getSoldee() { return soldee; }
	public String getCommentaireAvant() { return commentaireAvant; }
	public String getCommentaireApres() { return commentaireApres; }
	public String getStatut() { return statut; }
	public int getArticleWebId() { return articleWebId; }
	public double getMargeLigne() { return margeLigne; }


	public void setLigneId(int ligneId) {this.ligneId = ligneId;}
	public void setRank(int rank) {this.rank = rank;}
	public void setTypeLigne(String typeLigne) {this.typeLigne = typeLigne;}
	public void setReference(String reference) {this.reference = reference;}
	public void setDesignation(String designation) {this.designation = designation;}
	public void setCodeStats(String codeStats) {this.codeStats = codeStats;}
	public void setNumLot(String numLot) {this.numLot = numLot;}
	public void setLibelle(String libelle) {this.libelle = libelle;}
	public void setQuantite(double quantite) {this.quantite = quantite;}
	public void setUnite(String unite) {this.unite = unite;}
	public void setNbPieces(int nbPieces) {this.nbPieces = nbPieces;}
	public void setDatePeremption(long datePeremption) {this.datePeremption = datePeremption;}
	public void setPrix(double prix) {this.prix = prix;}
	public void setRistourne(double ristourne) {this.ristourne = ristourne;}
	public void setCodeTVA(int codeTVA) {this.codeTVA = codeTVA;}
	public void setTauxTVA(double tauxTVA) {this.tauxTVA = tauxTVA;}
	public void setCommission(double commission) {this.commission = commission;}
	public void setPrixAchat(double prixAchat) {this.prixAchat = prixAchat;}
	public void setMontantLigne(double montantLigne) {this.montantLigne = montantLigne;}
	public void setSoldee(boolean soldee) {this.soldee = soldee;}
	public void setCommentaireAvant(String commentaireAvant) {this.commentaireAvant = commentaireAvant;}
	public void setCommentaireApres(String commentaireApres) {this.commentaireApres = commentaireApres;}
	public void setArticleWebId(int articleWebId) {this.articleWebId = articleWebId;}
	public void setStatut(String statut) {this.statut = statut;}


} // fin LigneCommandeClient
