/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.data.dossier;

import java.util.HashMap;
import java.sql.Connection;

import org.opensi.dbm.general.DBM_Civilite;

public class Contact implements org.opensi.api.DataOSI {

	private int civilite;
	private String nom;
	private String prenom;
	private String tel;
	private String fax;
	private String email;

	public Contact(int civilite,
					String nom,
					String prenom,
					String tel,
					String fax,
					String email) {
		
		this.civilite = civilite;
		this.nom = nom;
		this.prenom = prenom;
		this.tel = tel;
		this.fax = fax;
		this.email = email;
	}
	
	
	public boolean isValid() {
	
		return true;
	}
	
	public HashMap<String, String> diff(Contact contact,String prefixe, Connection con) {
		HashMap<String, String> diff = new HashMap<String, String>();

		try {
		
			DBM_Civilite dbm_civ = new DBM_Civilite(con);
			
			if (this.equals(contact)) {
				return diff;
			}
			if (getCivilite()!=contact.getCivilite()) {
				String valeur = prefixe+"Civilit modifi de "+	dbm_civ.getCivCourte(contact.getCivilite())  +"  "+dbm_civ.getCivCourte(getCivilite());
				diff.put("Civilite",valeur); 
			}
			if (!getNom().equals(contact.getNom())) {
				String valeur = prefixe+"Nom modifi de "+contact.getNom()+"  "+getNom();
				diff.put("Nom",valeur); 
			}	
			if (!getPrenom().equals(contact.getPrenom())) {
				String valeur = prefixe+"Prnom modifi de "+contact.getPrenom()+"  "+getPrenom();
				diff.put("Prenom",valeur); 
			}			
			if (!getTel().equals(contact.getTel())) {
				String valeur = prefixe+"Tlphone modifi de "+contact.getTel()+"  "+getTel();
				diff.put("Tel",valeur); 
			}			
			if (!getFax().equals(contact.getFax())) {
				String valeur = prefixe+"Fax modifi de "+contact.getFax()+"  "+getFax();
				diff.put("Fax",valeur); 
			}
			if (!getEmail().equals(contact.getEmail())) {
				String valeur = prefixe+"Email modifi de "+contact.getEmail()+"  "+getEmail();
				diff.put("Email",valeur); 
			}
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		return diff;
	}
	
	public int getCivilite() { return civilite; }
	public String getNom() { return nom; }
	public String getPrenom() { return prenom; }
	public String getTel() { return tel; }
	public String getFax() { return fax; }
	public String getEmail() { return email; }
	

} // fin Contact
