/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.data.dossier;

import java.util.HashMap;

import org.opensi.data.dossier.Adresse;
import org.opensi.data.dossier.Contact;


public class CommandeFournisseur implements org.opensi.api.DataOSI {

	
	private int commandeId;
	private int numero;
	private String numEntier;
	private int utilC;
	private int utilM;
	private int utilR;
	private long dateCommande;
	private long dateC;
	private long dateM;
	private String fournisseurId;
	private double totalHT;
	private double totalTTC;
	private double remise;
	private double escompte;
	private double fraisPort;
	private double tauxTVAPort;
	private int codeTVAPort;
	private double acompte;
	private String commentairesFin;
	private String commentairesInt;
	private String etat;
	private boolean soldee;
	private String intitule;
	private String typeAchat;
	private Adresse adresseFact;
	private Contact contactFact;
	private Adresse adresseLiv;
	private String mentions;
	private int versCalc;

	private HashMap<Integer, LigneCommandeFournisseur> lignesCommandeFournisseur;

	
	public CommandeFournisseur(int commandeId,
								int numero,
								String numEntier,
								int utilC,
								int utilM,
								int utilR,
								long dateCommande,
								long dateC,
								long dateM,
								String fournisseurId,
								double totalHT,
								double totalTTC,
								double remise,
								double escompte,
								double fraisPort,
								double tauxTVAPort,
								int codeTVAPort,
								double acompte,
								String commentairesFin,
								String commentairesInt,
								String etat,
								boolean soldee,
								String intitule,
								String typeAchat,
								Adresse adresseFact,
								Contact contactFact,
								Adresse adresseLiv,
								String mentions,
								int versCalc) {
		
		this.commandeId = commandeId;
		this.numero = numero;
		this.numEntier = numEntier;
		this.utilC = utilC;
		this.utilM = utilM;
		this.utilR = utilR;
		this.dateCommande = dateCommande;
		this.dateC = dateC;
		this.dateM = dateM;
		this.fournisseurId = fournisseurId;
		this.totalHT = totalHT;
		this.totalTTC = totalTTC;
		this.remise = remise;
		this.escompte = escompte;
		this.fraisPort = fraisPort;
		this.tauxTVAPort = tauxTVAPort;
		this.codeTVAPort = codeTVAPort;
		this.acompte = acompte;
		this.commentairesFin = commentairesFin;
		this.commentairesInt = commentairesInt;
		this.etat = etat;
		this.soldee = soldee;
		this.intitule = intitule;
		this.typeAchat = typeAchat;
		this.adresseFact = adresseFact;
		this.contactFact = contactFact;
		this.adresseLiv = adresseLiv;
		this.mentions = mentions;
		this.versCalc = versCalc;
		
	}


	public boolean isValid() {
	
		return true;
	}
	
	
	public void addLigne(int ligneId, LigneCommandeFournisseur ligneCommandeFournisseur) { this.lignesCommandeFournisseur.put(ligneId, ligneCommandeFournisseur); }
	
	public int getCommandeId() { return commandeId; }
	public int getNumero() { return numero; }
	public String getNumEntier() { return numEntier; }
	public int getUtilC() { return utilC; }
	public int getUtilM() { return utilM; }
	public int getUtilR() { return utilR; }
	public long getDateCommande() { return dateCommande; }
	public long getDateC() { return dateC; }
	public long getDateM() { return dateM; }
	public String getFournisseurId() { return fournisseurId; }
	public double getTotalHT() { return totalHT; }
	public double getTotalTTC() { return totalTTC; }
	public double getRemise() { return remise; }
	public double getEscompte() { return escompte; }
	public double getFraisPort() { return fraisPort; }
	public double getTauxTVAPort() { return tauxTVAPort; }
	public int getCodeTVAPort() { return codeTVAPort; }
	public double getAcompte() { return acompte; }
	public String getCommentairesFin() { return commentairesFin; }
	public String getCommentairesInt() { return commentairesInt; }
	public String getEtat() { return etat; }
	public boolean getSoldee() { return soldee; }
	public String getIntitule() { return intitule; }
	public String getTypeAchat() { return typeAchat; }
	public Adresse getAdresseFact() { return adresseFact; }
	public Contact getContactFact() { return contactFact; }
	public Adresse getAdresseLiv() { return adresseLiv; }
	public String getMentions() { return mentions; }
	public int getVersCalc() { return versCalc; }
	public HashMap<Integer, LigneCommandeFournisseur> getLignesCommandeFournisseur() { return lignesCommandeFournisseur; }
	

} // fin CommandeFournisseur
