/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.control;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

/*
 * Classe Version :
 *  Traite les information concernant la version d'OpenSi
 */
 
public class Version {

  Properties prop;

  public Version(String fileName) {
    try {
      
      prop = new Properties();
      prop.load(new FileInputStream(fileName));
			
    } catch(IOException ioe) {
      ioe.printStackTrace();
    }
  }

  public String getVersion() {
    return prop.getProperty("releasename");
  }

  public String getUrlUpdate() {
    return prop.getProperty("urlupdate");
  }
	
	public String getVTest() {
    return prop.getProperty("vtest");
  }

} // Version
