package org.opensi.compta.actions.transferts;


import org.opensi.bo.BO_Journaux;
import org.opensi.bo.BO_Comptes;

import java.util.Calendar;


public class CheckCompta {

	
	private ErrorLog elog;
	private boolean useLog = false;
	
	
	private int line = 0;
	
	
	private long debutExercice;
	private long finExercice;
	private long periodeDebutExercice;
	

	public CheckCompta(long debutExercice, long finExercice, long periodeDebutExercice) {
	
		this.debutExercice = debutExercice;
		this.finExercice = finExercice;
		this.periodeDebutExercice = periodeDebutExercice;
	}
	
	
	public void setErrorLog(ErrorLog elog) {
	
		this.elog = elog;
		
		useLog = !(elog==null);
	}
	

	
	public boolean checkCodeJournal(String codeJournal) {	
		
		if (!BO_Journaux.checkStxCodeJournal(codeJournal)) {
			
			putError("Code journal incorrect");
			return false;
		}
		
		return true;		
	}
	
	
	public boolean checkPeriode(long periode) {
		
		if (periode == -1 || !isPeriode(periode)) {
			
			putError("Date d'criture incorrecte");
			return false;
		}
		else if (periode > finExercice || periode < periodeDebutExercice) {
		
			putError("Date d'criture hors exercice");
			return false;
		}
		
		return true;
	}
	
	
	public boolean checkTypeCompte(String type) {
		
		if (!BO_Comptes.isTypeCompte(type)) {
		
			putError("Type de compte incorrect");
			return false;
		}
		
		return true;
	}
	
	
	public boolean checkIntituleCompte(String intitule) {
		
		if (intitule.isEmpty()) {
		
			putWarn("Intitul de compte vide");
			return false;
		}
		
		return true;
	}		
		
		
	public boolean checkNumeroCompte(String numero, String type) {
		
		if (type.equals("G") && !BO_Comptes.checkStxCpteG(numero)) {
		
			putError("Compte gnral incorrect");
			return false;
		}
		else if (!type.equals("G") && !BO_Comptes.checkStxCpteCFA(numero)) {
			
			putError("Compte de tiers incorrect");
			return false;
		}
		
		return true;
	}
	
	public boolean checkNumeroCompte(String numero) {
	
		if (!BO_Comptes.checkStxCpteG(numero) && !BO_Comptes.checkStxCpteCFA(numero)) {
		
			putError("Numro de compte incorrect");
			return false;
		}
		
		return true;
	}
	
	
	public boolean checkMontantOp(double montant) {
	
		if (montant<=0) {
		
			putError("Montant d'opration <= 0");
			return false;
		}
	
		return true;
	}
	
	
	public boolean checkLibelleOp(String libelle) {
	
		if (libelle.isEmpty()) {
		
			putWarn("Libell d'opration vide");
			return false;
		}
	
		return true;
	}
	
	
	public boolean checkDateOp(long date) {
	
		if (!isDateOp(date)) {
		
			putError("Date d'opration incorrecte");
			return false;
		}
		else if (date > finExercice) {
		
			putError("Date d'opration ultrieure  la fin de l'exercice");
			return false;
		}
	
		return true;
	}
	

	public boolean checkDate(long date) {
	
		if (!isDateOp(date)) {
		
			putError("Date d'opration incorrecte");
			return false;
		}
		else if (date < debutExercice) {
		
			putError("Date d'opration infrieure au dbut de l'exercice");
			return false;
		}
		else if (date > finExercice) {
		
			putError("Date d'opration ultrieure  la fin de l'exercice");
			return false;
		}
	
		return true;
	}


	public boolean checkEmpty(String valeur,String text) {
	
		if (valeur.isEmpty()) {
		
			putError(text);
			return false;
		}
	
		return true;
	}
	
	
	public void setLine(int line) {
	
		this.line = line;
	}
	
	
	public void incLine() {
	
		line += 1;
	}
	
	
	private void putError(String error) {
		
		if (useLog) {
			elog.addError(line, error);
		}
		else {
			System.out.println("Erreur ligne "+ line +"\t --> "+ error);
		}
	}
	
	private void putWarn(String warn) {
	
		if (useLog) {
			elog.addWarn(line, warn);
		}
		else {
			System.out.println("Warning ligne "+ line +"\t --> "+ warn);
		}
	}
	
	/* obsolete - ne pas utiliser */
	public boolean isPeriode(long periode) {	
		
		Calendar cal = Calendar.getInstance();
		
		cal.clear();
		cal.setTimeInMillis(periode);
		
		return cal.get(Calendar.DAY_OF_MONTH)==1 && cal.get(Calendar.HOUR_OF_DAY)==0 && cal.get(Calendar.MINUTE)==0 && cal.get(Calendar.SECOND)==0;
	}
	
	/* obsolete - ne pas utiliser */
	public boolean isDateOp(long dateOp) {
		
		Calendar cal = Calendar.getInstance();
		
		cal.clear();
		cal.setTimeInMillis(dateOp);
		
		return cal.get(Calendar.HOUR_OF_DAY)==0 && cal.get(Calendar.MINUTE)==0 && cal.get(Calendar.SECOND)==0;
	}
	
	
	
} // fin CheckCompta
