/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.compta.actions.suiviActivite;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

import org.experlog.openeas.api.Session;
import org.opensi.util.tools.DateTime;

public class reqComptaCA {

	private long dateDebut, dateFin;
	private Connection con;
	private Session session ;
	
	public static final int VM=0;
	public static final int CMV=1;
	public static final int PV=2;
	public static final int PS=3;
	public static final int PI=4;
	public static final int MA=5;
	public int nbLignes=6;

	
	// Rcupration des donnes
	Compte[] tabFinal; //indic par les valeurs cf ci-dessus: VM, CMV...etc
	Vector<String> lesBases;
	String baseDossier;
	

	public reqComptaCA(int moisDebut, int anneeDebut, int moisFin, int anneeFin, String leDossierId, String sessionId) throws Exception {

		
		session = Session.findClient(sessionId);		
		con = session.getConnection(null);
		
		this.baseDossier = session.getCookie().get("BaseDossier");
		
		//Les dates....
		DateTime transfo=new DateTime(1, moisDebut, anneeDebut);
		dateDebut=transfo.getDateInMillis();
		transfo=new DateTime(transfo.currentMaxDay(), moisFin, anneeFin);
		dateFin=transfo.getDateFullTime();
		
		
		//Recupration des bases sur lesquelles on va requeter
		lesBases=listeBases(leDossierId);
		
		
		//variables pour le tant que
		String requete;
		Statement stt;
		ResultSet rset;
		Compte unCompte;
		long sommeD, sommeC;
		
		String debutRequete;
		String whereRequete;
		String finRequete=" ) GROUP BY c.Numero_Compte";
		
		tabFinal=new Compte[nbLignes];
		
		for(int g=0; g<nbLignes;g++)
		{
			tabFinal[g]=new Compte(0,0);
		}
		
		String baseCourante;
		// S'il y a d'autres bases, il ne faut ajouter les valeurs des libells identiques 
		for (int i=0; i<lesBases.size();i++)
		{
			baseCourante=(lesBases.elementAt(i));
			
			debutRequete="SELECT SUM(o.Montant_D) as debit, SUM(o.Montant_C) as credit";
			debutRequete+=" FROM "+baseDossier+".COMPTE c, "+baseCourante+".OPERATION o";
			debutRequete+=" WHERE c.Numero_Compte=o.Numero_Compte AND o.Date_Op>"+dateDebut+" AND o.Date_Op<"+dateFin+" AND( ";

			for (int a=0; a<nbLignes;a++)
			{
				whereRequete=whereRequete(a);
				
				requete=debutRequete+whereRequete+finRequete;

				
				stt = con.createStatement();
				rset = stt.executeQuery(requete);
				
				sommeD=0;
				sommeC=0;
				while (rset.next())	{
					sommeD+=rset.getLong("debit");
					sommeC+=rset.getLong("credit");
				}

				unCompte=new Compte(sommeC,sommeD);
				unCompte.ajouterCompte(tabFinal[a]);
				tabFinal[a]=unCompte;
			}
		}

		session.closeConnection(con, null);
	}


	
	public String whereRequete(int typeCompte)
	{
		conditionsComptes cond= new conditionsComptes();
		String resultat="";
		
		switch (typeCompte)
		{
			case VM:
				resultat=cond.venteDeMarch("c.");
				break;
			
			case CMV:
				resultat=cond.coutAchatMarchVendues("c.");
				break;
				
			case PV:
				resultat=cond.productionVendue("c.");
				break;
			
			case PS:
				resultat=cond.prodStockeeOuDestock("c.");
				break;
				
			case PI:
				resultat=cond.productionImmo("c.");
				break;

			case MA:
				resultat=cond.matPremiereApproConso("c.")+" and "+cond.sousTraitDirecte("c.");
				break;
			default: 
				//TODO: Implement 'default' statement
				break;

		}
		
		return resultat;
	
	}
	
	
	public Vector<String> listeBases(String dossierId) throws SQLException {
		
		Vector<String> resultat=new Vector<String>();

		Statement stt = con.createStatement();
		String req ="select Debut_Exercice,Fin_Exercice,Nom_Base from "+ baseDossier +".EXERCICE";

		ResultSet rset = stt.executeQuery(req);

		long debutCourant, finCourant;
		String base;
		while (rset.next())	{
			debutCourant=rset.getLong("Debut_Exercice");
			finCourant=rset.getLong("Fin_Exercice");
			if ( dateFin>debutCourant && dateDebut<finCourant)
			{//faut prendre la base;
				base = new String(rset.getString("Nom_Base"));
				resultat.addElement(base);
			}
		}
		rset.close();
		stt.close();
		
		return resultat;
	}

/* ************************** */
/* ** RECUP DES DONNEES    ** */
/* ************************** */


public long getDebit(int index)
{
	long resultat=0;
	
	resultat=tabFinal[index].getDebit();
	
	return resultat;
}

public long getCredit(int index)
{
	long resultat=0;
	
	resultat=tabFinal[index].getCredit();
	
	return resultat;
}





/**
*    CLASSE PRIVEE
**/

private class Compte
{

	long credit, debit;
	
	public Compte(long leCredit, long leDebit)
	{
	
		credit=leCredit;
		debit=leDebit;
	}

	public long getCredit()
	{
		return credit;
	}
	
	public long getDebit()
	{
		return debit;
	}
	
	/*
	* Somme le dbit et le crdit des deux comptes
	* Prerequis: les numro de comptes sont identiques
	*/
	public void ajouterCompte(Compte autre)
	{
		this.credit+=autre.getCredit();
		this.debit+=autre.getDebit();
	}
}

}
