/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/
  
/**
 *  Cre le tableau en Ooo
 */

package org.opensi.compta.actions.suiviActivite;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.openoffice.CreateurOpenOffice;
import org.opensi.util.openoffice.OooCellule;
import org.opensi.util.openoffice.OooLigne;
import org.opensi.util.openoffice.OooStyleCellule;
import org.opensi.util.openoffice.OooStyleLigne;


public class exportCAVersOoo extends Action {

	
	Connection con;
	String chemin;
	String nomFichier;
	String base;
	String baseDossier;
	String choix;
	int nbMois, moisDebut, anneeDebut, dureeExo;
	
	long totalVM, totalCMV, totalPV, totalPS, totalPIM, totalMA;
	lesTrois tab_VM, tab_CMV, tab_PV, tab_PS, tab_PIM, tab_MA, tab_CA, tab_MC, tab_MBP, tab_MBG, tab_PE; // de taille nbMois. Null si pas d'actu, l'actu si actu
	Long[] tab_MC_pc,tab_MBP_pc;
	String listeVM, listeCMV, listePV, listePS, listePIM, listeMA,listePC_MC,listePC_MBP;
	
	CreateurOpenOffice renoir;
	OooStyleCellule titreStyle, petitePolice, chiffreTitreStyle, rienStyle, caseStyle;
	OooStyleLigne ligneStyle;
	
  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {
			
		chemin = s.getAppConfiguration().get("opensi.absdir") ;
		con = s.getConnection(null);
		
		this.baseDossier = s.getCookie().get("BaseDossier");
		
		nomFichier=r.getParameter("fichierSxc");
		base=r.getParameter("baseBD");
		nbMois=Integer.parseInt(r.getParameter("nbMois"));
		moisDebut=Integer.parseInt(r.getParameter("moisDebut"));
		anneeDebut=Integer.parseInt(r.getParameter("anneeDebut"));
		dureeExo=Integer.parseInt(r.getParameter("dureeExo"));
		choix=r.getParameter("choix");
		 
		listeVM=r.getParameter("listeVM");		 
		listeCMV=r.getParameter("listeCMV");		 
		listePV=r.getParameter("listePV");		 
		listePS=r.getParameter("listePS");		 
		listePIM=r.getParameter("listePIM");		 
		listeMA=r.getParameter("listeMA");		 
		listePC_MC=r.getParameter("pcMC");		 
		listePC_MBP=r.getParameter("pcMBP");			 
		 
		lisTotaux();		 
		faireLesCalculs();		 
		initOoo();		 
		ecrireEntetes();		
		creerLignes();	
		 
		renoir.changerLargeurColonne(0,11.0f);
		renoir.changerLargeurColonne(1,2.50f);
		 
		File truc = renoir.genererDocument(nomFichier);
		truc.deleteOnExit();
		
		return true;	
	}
	

	
	public void initOoo()
	{
		renoir=new CreateurOpenOffice(chemin+"/openoffice");
		
		titreStyle=renoir.creerNewStyleCellule();
		titreStyle.setGras(true); 
		titreStyle.setCouleurFond("#FCD9AF");
		titreStyle.setBordure(true);
		titreStyle.setAlignement(OooStyleCellule.H_CENTRE,OooStyleCellule.V_MILIEU);
		titreStyle.setFormatNombre(OooStyleCellule.FORMAT_NOMBRE_ENTIER);
		
		chiffreTitreStyle=renoir.creerNewStyleCellule();
		chiffreTitreStyle.setGras(true); 
		chiffreTitreStyle.setCouleurFond("#FCD9AF");
		chiffreTitreStyle.setBordure(true);
		chiffreTitreStyle.setFormatNombre(OooStyleCellule.FORMAT_NOMBRE_ENTIER);
		
		caseStyle=renoir.creerNewStyleCellule();
		caseStyle.setBordure(true);
		caseStyle.setFormatNombre(OooStyleCellule.FORMAT_NOMBRE_ENTIER);
		
		petitePolice=renoir.creerNewStyleCellule();
		petitePolice.setTaillePolice(10);
		
		rienStyle=renoir.getStyleCelluleParDefaut();
		ligneStyle=renoir.getStyleLigneParDefaut();
	}
	
	
	
	
	
	public void ecrireEntetes()
	{
		OooCellule celVide=new OooCellule("",rienStyle);
		OooLigne ligne =new OooLigne(ligneStyle);
		
		OooCellule celMois;
		
		//Ligne des mois
		ligne.ajouterCellule(celVide);
		ligne.ajouterCellule(celVide);
		int vraiMois;
		String mois;
		
		for (int u=1; u<=nbMois;u++)
		{
			ligne.ajouterCellule(celVide);
			vraiMois=u+moisDebut-1;	
			mois=leMois(vraiMois);
			
			celMois=new OooCellule(mois,titreStyle);
			celMois.setFusion(1,3);
			ligne.ajouterCellule(celMois);
		}
		
		renoir.ajouterLigne(ligne);
		
		
		//Ligne des prev actu realis
		ligne=new OooLigne(ligneStyle);
		
		OooCellule exoClosCel=new OooCellule("Exercice clos le 14/07/2005", titreStyle);
		exoClosCel.setFusion(1,2);
		
		ligne.ajouterCellule(exoClosCel);
		
		//les mois
		for (int k=1; k<=nbMois; k++)
		{
			ligne.ajouterCellule(celVide);
			ligne.ajouterCellule(new OooCellule("Prev",titreStyle));
			ligne.ajouterCellule(new OooCellule("Actu",titreStyle ));
			ligne.ajouterCellule(new OooCellule("Ralise",titreStyle ));
		}
		
		renoir.ajouterLigne(ligne);
	
	}
	
	/* ***************************** CALCULS *********************************** */
	
	public void faireLesCalculs()	{
	
		 tab_VM=new lesTrois(nbMois);
		 tab_CMV=new lesTrois(nbMois);
		 tab_PV=new lesTrois(nbMois);
		 tab_PS=new lesTrois(nbMois);
		 tab_PIM=new lesTrois(nbMois);
		 tab_PE=new lesTrois(nbMois);
		 tab_MA=new lesTrois(nbMois);
		 tab_CA=new lesTrois(nbMois);
		 tab_MC=new lesTrois(nbMois);
		 tab_MBP=new lesTrois(nbMois);
		 tab_MBG=new lesTrois(nbMois);
	
		//1. Rcupration des actus d'aprs les listes
		tab_VM.setActuTab(listeStringVersTab(listeVM));
		tab_CMV.setActuTab(listeStringVersTab(listeCMV));
		tab_PV.setActuTab(listeStringVersTab(listePV));
		tab_PS.setActuTab(listeStringVersTab(listePS));
		tab_PIM.setActuTab(listeStringVersTab(listePIM));
		tab_MA.setActuTab(listeStringVersTab(listeMA));
		tab_MC_pc=listeStringVersTab(listePC_MC);
		tab_MBP_pc=listeStringVersTab(listePC_MBP);

		//2. calcul des prev avec les pourcentages
		long moyVM=totalVM/dureeExo;
		long moyPV=totalPV/dureeExo;
		long moyPS=totalPS/dureeExo;
		long moyPIM=totalPIM/dureeExo;
		long moyCMV, moyMA, moyPE, moyMC, moyMBP, moyMBG;
		
		for(int a=0; a<nbMois;a++)
		{
		
			//Les prvus
			moyCMV=moyVM*(100-(tab_MC_pc[a].longValue()))/100;
			moyPE=moyPV+moyPS+moyPIM;
			moyMA=moyPE*(100-(tab_MBP_pc[a].longValue()))/100;
			moyMC=moyCMV-moyVM;
			moyMBP=moyPE-moyMA;
			moyMBG=moyMC+moyMBP;
			
			tab_VM.setPrev(moyVM,a);
			tab_PV.setPrev(moyPV,a);
			tab_PS.setPrev(moyPS,a);
			tab_PIM.setPrev(moyPIM,a);
			tab_CMV.setPrev(moyCMV,a);
			tab_PE.setPrev(moyPE,a);
			tab_MA.setPrev(moyMA,a);
			tab_MC.setPrev(moyMC,a);
			tab_MBP.setPrev(moyMBP,a);
			tab_MBG.setPrev(moyMBG,a);
			
			//Les retenus
			if (tab_VM.getActu(a)!=null)
			{tab_VM.setRetenu(tab_VM.getActu(a),a);}
			else
			{tab_VM.setRetenu(tab_VM.getPrev(a),a);}
			
			if (tab_CMV.getActu(a)!=null)
			{tab_CMV.setRetenu(tab_CMV.getActu(a),a);}
			else
			{tab_CMV.setRetenu(tab_CMV.getPrev(a),a);}
			
			if (tab_PV.getActu(a)!=null)
			{tab_PV.setRetenu(tab_PV.getActu(a),a);}
			else
			{tab_PV.setRetenu(tab_PV.getPrev(a),a);}
			
			if (tab_PS.getActu(a)!=null)
			{tab_PS.setRetenu(tab_PS.getActu(a),a);}
			else
			{tab_PS.setRetenu(tab_PS.getPrev(a),a);}
			
			if (tab_PIM.getActu(a)!=null)
			{tab_PIM.setRetenu(tab_PIM.getActu(a),a);}
			else
			{tab_PIM.setRetenu(tab_PIM.getPrev(a),a);}
			
			moyCMV=tab_VM.getRetenu(a).longValue()*(100-(tab_MC_pc[a].longValue()))/100;
			moyPE=tab_PV.getRetenu(a).longValue()+tab_PS.getRetenu(a).longValue()+tab_PIM.getRetenu(a).longValue();
			tab_PE.setRetenu(moyPE,a);
			
			moyMA=tab_PE.getRetenu(a).longValue()*(100-(tab_MBP_pc[a].longValue()))/100;
			tab_MA.setRetenu(moyMA,a);
			
			moyMC=moyCMV-moyVM;
			tab_MC.setRetenu(moyMC,a);
			
			moyMBP=moyPE-moyMA;
			tab_MBP.setRetenu(moyMBP,a);
			
			moyMBG=moyMC+moyMBP;
			tab_MBG.setRetenu(moyMBG,a);
			

			
		}	
			
			
	}
	
	
	
	/* ****************************** LIGNES ************************************** */
	
	public void creerLignes()
	{
		/*OooCellule cel;
		OooCellule celVide=new OooCellule("",rienStyle);
		OooLigne ligne;
		long cumul, parMois;
		Integer[] tab_MC, tab_MBP, tab_PE;
		
		//pour les calculs des prevs:
		long[] prev_VM=new long[nbMois];
		long[] prev_CMV=new long[nbMois];
		long[] prev_PV=new long[nbMois];
		long[] prev_PS=new long[nbMois];
		long[] prev_PIM=new long[nbMois];
		long[] prev_PE=new long[nbMois];
		long[] prev_MA=new long[nbMois];

		
		// -------------- CA ---------------------------
			cel=new OooCellule("Ventes de marchandises + production", titreStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			cel=new OooCellule(totalPV+totalVM, chiffreTitreStyle);
			ligne.ajouterCellule(cel);
			
			long lePVParMois=totalPV/dureeExo;
			long leVMParMois=totalVM/dureeExo;
			boolean yaActu;
			long lePV, leVM,actuCA;
			for (int n=1; n<=nbMois;n++)
			{
				yaActu=false;
				actuCA=0;
				lePV=lePVParMois;
				leVM=leVMParMois;
				
				
				ligne.ajouterCellule(celVide);
				
				// Prev
				cel=new OooCellule(lePVParMois+leVMParMois, chiffreTitreStyle);
				ligne.ajouterCellule(cel);
				
				if(tab_PV[n-1]!=null)
				{
					lePV=tab_PV[n-1].intValue();
					yaActu=true;
					actuCA=lePV;
				}
				
				if(tab_VM[n-1]!=null)
				{
					leVM=tab_VM[n-1].intValue();
					yaActu=true;
					actuCA+=leVM;
				}
				
				// Actu
				if(yaActu)
				{
					cel=new OooCellule(actuCA, chiffreTitreStyle);
					
				}
				else
				{
					cel=new OooCellule("", chiffreTitreStyle);
				}
				
				ligne.ajouterCellule(cel);
				
				//retenu
				cel=new OooCellule(leVM+lePV, chiffreTitreStyle);
				ligne.ajouterCellule(cel);
				
				
				
				
			}
	
			renoir.ajouterLigne(ligne);
			
			
			// ---------------------- VM ---------------------------------
			cel=new OooCellule("Ventes de marchandises", caseStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			cel=new OooCellule(totalVM, caseStyle);
			ligne.ajouterCellule(cel);
			
			parMois=totalVM/dureeExo;
			for (int n=1; n<=nbMois;n++)
			{
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(parMois, caseStyle);
				ligne.ajouterCellule(cel);
				
				if(tab_VM[n-1]!=null)
				{//y a un actu
					cel=new OooCellule(tab_VM[n-1].intValue(), caseStyle);
					ligne.ajouterCellule(cel);
					cel=new OooCellule(tab_VM[n-1].intValue(), caseStyle);
					ligne.ajouterCellule(cel);
					prev_VM[n-1]=tab_VM[n-1].intValue();
				}
				else
				{
					cel=new OooCellule("", caseStyle);
					ligne.ajouterCellule(cel);
					cel=new OooCellule(parMois, caseStyle);
					ligne.ajouterCellule(cel);
					prev_VM[n-1]=parMois;
				}
				
				
			}
	
			renoir.ajouterLigne(ligne);
		
		// ------------------------------ CMV ----------------------------------
		
			cel=new OooCellule("Cout d'achat des marchandises vendues", caseStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			cel=new OooCellule(totalCMV, caseStyle);
			ligne.ajouterCellule(cel);
	
			long leCMV;

			for (int n=1; n<=nbMois;n++)
			{
				
				leCMV=(totalVM/dureeExo)*(100-tab_MC_pc[n-1].intValue())/100;
			
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(leCMV, caseStyle);
				ligne.ajouterCellule(cel);
				
				if(tab_CMV[n-1]!=null)
				{//y a un actu
					cel=new OooCellule(tab_CMV[n-1].intValue(), caseStyle);
					ligne.ajouterCellule(cel);
					cel=new OooCellule(tab_CMV[n-1].intValue(), caseStyle);
					ligne.ajouterCellule(cel);
					prev_CMV[n-1]=tab_CMV[n-1].intValue();
			
				}
				else
				{
					cel=new OooCellule("", caseStyle);
					ligne.ajouterCellule(cel);
					cel=new OooCellule(leCMV, caseStyle);
					ligne.ajouterCellule(cel);
					prev_CMV[n-1]=leCMV;
			
				}
				
				
				
			}
	
			renoir.ajouterLigne(ligne);
			
			// ------------------------ MC --------------------------------
			
			tab_MC=new Integer[nbMois];
			cel=new OooCellule("Marge commerciale", titreStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			long totalMC=totalCMV-totalVM;
			cel=new OooCellule(totalMC, chiffreTitreStyle);
			ligne.ajouterCellule(cel);
			

			long actuMC,leMC;
			
			for (int n=1; n<=nbMois;n++)
			{
				yaActu=false;
				actuMC=0;
				leMC=(totalVM/dureeExo)*tab_MC_pc[n-1].intValue()/100;
			
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(leMC, chiffreTitreStyle);
				ligne.ajouterCellule(cel);
				
				if(tab_CMV[n-1]!=null)
				{
					leCMV=tab_CMV[n-1].intValue();
					yaActu=true;
					actuMC=leCMV;
				}
				
				if(tab_VM[n-1]!=null)
				{
					leVM=tab_VM[n-1].intValue();
					yaActu=true;
					actuMC-=leVM;
				}
				
				if(yaActu)
				{
					cel=new OooCellule(actuMC, chiffreTitreStyle);
					tab_MC[n-1]=new Integer(""+actuMC);
					
				}
				else
				{
					cel=new OooCellule("", chiffreTitreStyle);
					tab_MC[n-1]=null;
		
				}
				ligne.ajouterCellule(cel);
					cel=new OooCellule(prev_CMV[n-1]-prev_VM[n-1], chiffreTitreStyle);
					ligne.ajouterCellule(cel);
				
			}
	
			renoir.ajouterLigne(ligne);
			
			// ------------------------- PV ------------------------------
			cel=new OooCellule("Production vendue", caseStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			cel=new OooCellule(totalPV, caseStyle);
			ligne.ajouterCellule(cel);
			
			parMois=totalPV/dureeExo;
			for (int n=1; n<=nbMois;n++)
			{
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(parMois, caseStyle);
				ligne.ajouterCellule(cel);
				
				if(tab_PV[n-1]!=null)
				{//y a un actu
					cel=new OooCellule(tab_PV[n-1].intValue(), caseStyle);
					ligne.ajouterCellule(cel);
					cel=new OooCellule(tab_PV[n-1].intValue(), caseStyle);
					ligne.ajouterCellule(cel);
					prev_PV[n-1]=tab_PV[n-1].intValue();
				}
				else
				{
					cel=new OooCellule("", caseStyle);
					ligne.ajouterCellule(cel);
					cel=new OooCellule(parMois, caseStyle);
					ligne.ajouterCellule(cel);
					prev_PV[n-1]=parMois;
				}
				
				
			}
	
			renoir.ajouterLigne(ligne);
			
			// -------------------------------- PS ----------------------------------
			cel=new OooCellule("Production stocke ou dstockage", caseStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			cel=new OooCellule(totalPS, caseStyle);
			ligne.ajouterCellule(cel);
			
			parMois=(totalPS/dureeExo);
			for (int n=1; n<=nbMois;n++)
			{
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(parMois, caseStyle);
				ligne.ajouterCellule(cel);
				
				if(tab_PS[n-1]!=null)
				{//y a un actu
					cel=new OooCellule(tab_PS[n-1].intValue(), caseStyle);
					ligne.ajouterCellule(cel);
					cel=new OooCellule(tab_PS[n-1].intValue(), caseStyle);
					ligne.ajouterCellule(cel);
					prev_PS[n-1]=tab_PS[n-1].intValue();
				}
				else
				{
					cel=new OooCellule("", caseStyle);
					ligne.ajouterCellule(cel);
					cel=new OooCellule(parMois, caseStyle);
					ligne.ajouterCellule(cel);
					prev_PS[n-1]=parMois;
					
				}
				
				
			}
	
			renoir.ajouterLigne(ligne);
			
			// ------------------------------ PIM ---------------------------------
			cel=new OooCellule("Production immobilise", caseStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			cel=new OooCellule(totalPIM, caseStyle);
			ligne.ajouterCellule(cel);
			
			parMois=(totalPIM/dureeExo);
			for (int n=1; n<=nbMois;n++)
			{
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(parMois, caseStyle);
				ligne.ajouterCellule(cel);
				
				if(tab_PIM[n-1]!=null)
				{//y a un actu
					cel=new OooCellule(tab_PIM[n-1].intValue(), caseStyle);
					ligne.ajouterCellule(cel);
					cel=new OooCellule(tab_PIM[n-1].intValue(), caseStyle);
					ligne.ajouterCellule(cel);
					prev_PIM[n-1]=tab_PIM[n-1].intValue();
				}
				else
				{
					cel=new OooCellule("", caseStyle);
					ligne.ajouterCellule(cel);
					cel=new OooCellule(parMois, caseStyle);
					ligne.ajouterCellule(cel);
					prev_PIM[n-1]=parMois;
				}
				
				
			}
	
			renoir.ajouterLigne(ligne);
			
			// ---------------------------- PE ---------------------------------
			tab_PE=new Integer[nbMois];
			cel=new OooCellule("Production de l'exercice", titreStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			long totalPE=totalPV+totalPS+totalPIM;
			cel=new OooCellule(totalPE, chiffreTitreStyle);
			ligne.ajouterCellule(cel);
			
			long lePIM, lePS, actuPE;
			long lePIMParMois=totalPIM/dureeExo;
			long lePSParMois=totalPS/dureeExo;
			
			for (int n=1; n<=nbMois;n++)
			{
				yaActu=false;
				actuPE=0;
				lePIM=lePIMParMois;
				lePS=lePSParMois;
				lePV=lePVParMois;
			
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(lePIMParMois+lePSParMois+lePVParMois, chiffreTitreStyle);
				ligne.ajouterCellule(cel);
				
				
				if(tab_PIM[n-1]!=null)
				{
					lePIM=tab_PIM[n-1].intValue();
					yaActu=true;
					actuPE=lePIM;
				}
				
				if(tab_PS[n-1]!=null)
				{
					lePS=tab_PS[n-1].intValue();
					yaActu=true;
					actuPE+=lePS;
				}
				
				if(tab_PV[n-1]!=null)
				{
					lePV=tab_PV[n-1].intValue();
					yaActu=true;
					actuPE+=lePV;
				}
				
				if(yaActu)
				{
					cel=new OooCellule(actuPE, chiffreTitreStyle);
					tab_PE[n-1]=new Integer(""+actuPE);
					
				}
				else
				{
					cel=new OooCellule("", chiffreTitreStyle);
					tab_PE[n-1]=null;
					
				}
				ligne.ajouterCellule(cel);
				cel=new OooCellule(prev_PIM[n-1]+prev_PS[n-1]+prev_PV[n-1], chiffreTitreStyle);
				prev_PE[n-1]=prev_PIM[n-1]+prev_PS[n-1]+prev_PV[n-1];
				ligne.ajouterCellule(cel);
				
			}
	
			renoir.ajouterLigne(ligne);
			
			// --------------------------------------- MA ---------------------------------------------------
			// ATTENTION  faire en fonction des %
			cel=new OooCellule("Matires premires, appro consomms + sous traitance directe", caseStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			cel=new OooCellule(totalMA, caseStyle);
			ligne.ajouterCellule(cel);
			
			parMois=totalMA/dureeExo;
			for (int n=1; n<=nbMois;n++)
			{
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(parMois, caseStyle);
				ligne.ajouterCellule(cel);
				
				if(tab_MA[n-1]!=null)
				{//y a un actu
					cel=new OooCellule(tab_MA[n-1].intValue(), caseStyle);
					ligne.ajouterCellule(cel);
					cel=new OooCellule(tab_MA[n-1].intValue(), caseStyle);
					ligne.ajouterCellule(cel);
					prev_MA[n-1]=tab_MA[n-1].intValue();
				}
				else
				{
					cel=new OooCellule("", caseStyle);
					ligne.ajouterCellule(cel);
					cel=new OooCellule(parMois, caseStyle);
					ligne.ajouterCellule(cel);
					prev_MA[n-1]=parMois;
					
				}
				
				
			}
	
			renoir.ajouterLigne(ligne);
			
			// ------------------------------------ MBP -----------------------------------
			tab_MBP=new Integer[nbMois];
			cel=new OooCellule("Marge brute de production", titreStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			long totalMBP=totalPE+totalMA;
			cel=new OooCellule(totalMBP, chiffreTitreStyle);
			ligne.ajouterCellule(cel);
			
			long lePE, leMA, actuMBP;
			long leMAParMois=totalMA/dureeExo;
			long lePEParMois=totalPE/dureeExo;
			for (int n=1; n<=nbMois;n++)
			{
				yaActu=false;
				actuMBP=0;
				leMA=leMAParMois;
				lePE=lePEParMois;
				
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(lePE-leMA, chiffreTitreStyle);
				ligne.ajouterCellule(cel);
				
				if(tab_PE[n-1]!=null)
				{
					lePE=tab_PE[n-1].intValue();
					yaActu=true;
					actuMBP=lePE;
				}
				
				if(tab_MA[n-1]!=null)
				{
					leMA=tab_MA[n-1].intValue();
					yaActu=true;
					actuMBP-=leMA;
				}
				
				if(yaActu)
				{
					cel=new OooCellule(actuMBP, chiffreTitreStyle);
					tab_MBP[n-1]=new Integer(""+actuMBP);
					
				}
				else
				{
					cel=new OooCellule("", chiffreTitreStyle);
					tab_MBP[n-1]=null;
				}
				ligne.ajouterCellule(cel);
				cel=new OooCellule(prev_PE[n-1]-prev_MA[n-1], chiffreTitreStyle);
				ligne.ajouterCellule(cel);
				
			}
	
			renoir.ajouterLigne(ligne);
			
			// ---------------------------------------- MBG -----------------------------------
			cel=new OooCellule("Marge commerciale", titreStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			cel=new OooCellule(totalMC+totalMBP, chiffreTitreStyle);
			ligne.ajouterCellule(cel);
			
			parMois=(totalMC/dureeExo)-(totalMBP/dureeExo);
			
			long leMBP, actuMBG;
			long leMCParMois=totalMC/dureeExo;
			long leMBPParMois=totalMBP/dureeExo;
			
			for (int n=1; n<=nbMois;n++)
			{
				yaActu=false;
				actuMBG=0;
				leMC=leMCParMois;
				leMBP=leMBPParMois;
			
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(leMC-leMBP, chiffreTitreStyle);
				ligne.ajouterCellule(cel);
				
				if(tab_MC[n-1]!=null)
				{
					leMC=tab_MC[n-1].intValue();
					yaActu=true;
					actuMBG=leMC;
				}
				
				if(tab_MBP[n-1]!=null)
				{
					leMBP=tab_MBP[n-1].intValue();
					yaActu=true;
					actuMBG-=leMBP;
				}
				
				if(yaActu)
				{
					cel=new OooCellule(actuMBG, chiffreTitreStyle);
					
				}
				else
				{
					cel=new OooCellule("", chiffreTitreStyle);
				}
				ligne.ajouterCellule(cel);
				cel=new OooCellule((prev_CMV[n-1]-prev_VM[n-1])+(prev_PE[n-1]-prev_MA[n-1]), chiffreTitreStyle);
				ligne.ajouterCellule(cel);
				
			}
	
			renoir.ajouterLigne(ligne);
			
	*/
	
	}
	
	
	
	
	
	
	
	
	
	public void lisTotaux() throws SQLException	{
		
		String requete="";
		conditionsComptes cond=new conditionsComptes();
		double debit, credit;
		Statement stt1 = con.createStatement();
		ResultSet resultatReq;
		
		//Vente de marchandises
		requete= "SELECT SUM(o.Montant_D) as debit, SUM(o.Montant_C) as credit FROM "+baseDossier+".COMPTE c, "+base+".OPERATION o ";
		requete+=" WHERE c.Numero_Compte=o.Numero_Compte AND ( "+cond.venteDeMarch("c.")+" ) GROUP BY c.Numero_Compte";
		
		resultatReq=stt1.executeQuery(requete);
		debit=0;
		credit=0;
		while (resultatReq.next()) {
			debit+=resultatReq.getDouble("debit");
			credit+=resultatReq.getDouble("credit");
		}
		totalVM=(long)(debit-credit);
	
		
		
		//Cout d'achat des marchandises vendues
		requete= "SELECT SUM(o.Montant_D) as debit, SUM(o.Montant_C) as credit FROM "+baseDossier+".COMPTE c, "+base+".OPERATION o ";
		requete+=" WHERE c.Numero_Compte=o.Numero_Compte AND ( "+cond.coutAchatMarchVendues("c.")+" ) GROUP BY c.Numero_Compte";
		
		resultatReq=stt1.executeQuery(requete);
		debit=0;
		credit=0;
		while (resultatReq.next()) {
			debit+=resultatReq.getDouble("debit");
			credit+=resultatReq.getDouble("credit");
		}
		totalCMV=(long)(debit-credit);
	
		
		//Production vendue
		requete= "SELECT SUM(o.Montant_D) as debit, SUM(o.Montant_C) as credit FROM "+baseDossier+".COMPTE c, "+base+".OPERATION o ";
		requete+=" WHERE c.Numero_Compte=o.Numero_Compte AND ( "+cond.productionVendue("c.")+" ) GROUP BY c.Numero_Compte";
		
		resultatReq=stt1.executeQuery(requete);
		debit=0;
		credit=0;
		while (resultatReq.next()) {
			debit+=resultatReq.getDouble("debit");
			credit+=resultatReq.getDouble("credit");
		}
		totalPV=(long)(debit-credit);
	
	
		
		//Production stocke
		requete= "SELECT SUM(o.Montant_D) as debit, SUM(o.Montant_C) as credit FROM "+baseDossier+".COMPTE c, "+base+".OPERATION o ";
		requete+=" WHERE c.Numero_Compte=o.Numero_Compte AND ( "+cond.prodStockeeOuDestock("c.")+" ) GROUP BY c.Numero_Compte";
		
		resultatReq=stt1.executeQuery(requete);
		debit=0;
		credit=0;
		while (resultatReq.next()) {
			debit+=resultatReq.getDouble("debit");
			credit+=resultatReq.getDouble("credit");
		}
		totalPS=(long)(debit-credit);
	
		
		
		//Production immobilise
		requete= "SELECT SUM(o.Montant_D) as debit, SUM(o.Montant_C) as credit FROM "+baseDossier+".COMPTE c, "+base+".OPERATION o ";
		requete+=" WHERE c.Numero_Compte=o.Numero_Compte AND ( "+cond.productionImmo("c.")+" ) GROUP BY c.Numero_Compte";
		
		resultatReq=stt1.executeQuery(requete);
		debit=0;
		credit=0;
		while (resultatReq.next()) {
			debit+=resultatReq.getDouble("debit");
			credit+=resultatReq.getDouble("credit");
		}
		totalPIM=(long)(debit-credit);
	
	
		
		//Matieres premires appro consomms
		requete= "SELECT SUM(o.Montant_D) as debit, SUM(o.Montant_C) as credit FROM "+baseDossier+".COMPTE c, "+base+".OPERATION o ";
		requete+=" WHERE c.Numero_Compte=o.Numero_Compte AND ( "+cond.matPremiereApproConso("c.")+" ) GROUP BY c.Numero_Compte";
		
		resultatReq=stt1.executeQuery(requete);
		debit=0;
		credit=0;
		while (resultatReq.next()) {
			debit+=resultatReq.getDouble("debit");
			credit+=resultatReq.getDouble("credit");
		}
		totalMA=(long)(debit-credit);
	
	}
	
	
	
	
	
	
	
	
	
	public Long[] listeStringVersTab(String liste)
	{
		Long[] listeFinale=new Long[nbMois];
		
				
				if(liste.length()>0)
				{
				
					//on enlve la premire ','
					liste=liste.substring(1);

					String[] touteLaListe=liste.split(",",0);


					
					int parcourant=0;


					for(int h=0; h<nbMois;h++)
					{
						if( parcourant<touteLaListe.length && Long.parseLong(touteLaListe[parcourant])== h+1)
						{

							listeFinale[h]=new Long(touteLaListe[parcourant+1]);
							parcourant+=2;
						}
						else
						{
		
							listeFinale[h]=null;
						}
					}
				}
				else
				{
					for (int u=0; u<nbMois;u++)
					{
						listeFinale[u]=null;
					}
				}

		
				return listeFinale;
		
	}
	
	
	
	
	
	
	
	
	
	
	
	public String leMois(int lemois)
	{
		String resultat="";
		
		switch (lemois)
		{
			case 1: resultat="Janvier";break;
			case 2: resultat="Fvrier";break;
			case 3: resultat="Mars";break;
			case 4: resultat="Avril";break;
			case 5: resultat="Mai";break;
			case 6: resultat="Juin";break;
			case 7: resultat="Juillet";break;
			case 8: resultat="Aout";break;
			case 9: resultat="Septembre";break;
			case 10: resultat="Octobre";break;
			case 11: resultat="Novembre";break;
			case 12: resultat="Dcembre";break;
			default: resultat="";
		
		}
		
		return resultat;
	}
	
	
	
	
	private class lesTrois
	{
		private Long[] prev, actu, retenu; //peut tre null si absent
		
		public lesTrois(int nbMois)
		{
			prev=new Long[nbMois];
			actu=new Long[nbMois];
			retenu=new Long[nbMois];
		}
		
		//avec le type long
		public void setActu(long actu, int numMois)
		{
			this.actu[numMois]=new Long(actu);
		}
		
		public void setPrev(long prev, int numMois)
		{
			this.prev[numMois]=new Long(prev);
		}
		
		public void setRetenu(long retenu, int numMois)
		{
			this.retenu[numMois]=new Long(retenu);
		}
		
		// avec la classe Long
		public void setActu(Long actu, int numMois)
		{
			this.actu[numMois]=actu;
		}
		
		public void setPrev(Long prev, int numMois)
		{
			this.prev[numMois]=prev;
		}
		
		public void setRetenu(Long retenu, int numMois)
		{
			this.retenu[numMois]=retenu;
		}
		
		
		//Les gets
		public Long getActu(int numMois)
		{
			return actu[numMois];
		}
		
		public Long getPrev(int numMois)
		{
			return prev[numMois];
		}
		
		public Long getRetenu(int numMois)
		{
			return retenu[numMois];
		}
		
		public void setActuTab(Long[] actu)
		{
			this.actu=actu;
		}
		
		public String toString()
		{
			String resultat="";
			resultat+="\n  PREV:";
			for (int g=0; g<prev.length;g++)
			{
				resultat+=" | "+prev[g]; 
			}
			
			resultat+="\n  ACTU:";
			for (int g=0; g<actu.length;g++)
			{
				resultat+=" | "+actu[g]; 
			}
			
			resultat+="\nRETENU:";
			for (int g=0; g<retenu.length;g++)
			{
				resultat+=" | "+retenu[g]; 
			}
			
			return resultat;
		}
	
	}
	
	
	
}



		
			
			










