/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.compta.actions.suiviActivite;

public class RealiseComparatif
{
	
	long CP, CF, CE, IT, AM, CA, AD;

	
	public RealiseComparatif(int moisDebut, int anneeDebut, int moisFin, int anneeFin, String leDossierId, String sessionId) throws Exception	{
	

		
		// Il faut rcuprer tous les totaux
		
		// Charges de personnel
		reqCompta CPreq=new reqCompta( moisDebut, anneeDebut, moisFin, anneeFin,"CP", leDossierId, sessionId);
		int dernier=CPreq.initEtGetEnum();

		long debit=0, credit=0;
		
		
		for(int i=0; i<=dernier; i++)
		{
			debit+=CPreq.getDebit(i);
			credit+=CPreq.getCredit(i);
			CP+=(credit-debit);
		}
		
		// Charges financieres
		reqCompta CFreq=new reqCompta( moisDebut, anneeDebut, moisFin, anneeFin,"CF", leDossierId, sessionId);
		dernier=CFreq.initEtGetEnum();

		debit=0; credit=0;
		
		
		for(int i=0; i<=dernier; i++)
		{
			debit+=CFreq.getDebit(i);
			credit+=CFreq.getCredit(i);
			CF+=(credit-debit);
		}
		
		// Charges externes
		reqCompta CEreq=new reqCompta( moisDebut, anneeDebut, moisFin, anneeFin,"CE", leDossierId, sessionId);
		dernier=CEreq.initEtGetEnum();

		debit=0; credit=0;
		
		
		for(int i=0; i<=dernier; i++)
		{
			debit+=CEreq.getDebit(i);
			credit+=CEreq.getCredit(i);
			CE+=(credit-debit);
		}
		
		
		// Impots et taxes
		reqCompta ITreq=new reqCompta( moisDebut, anneeDebut, moisFin, anneeFin,"IT", leDossierId, sessionId);
		dernier=ITreq.initEtGetEnum();

		debit=0; credit=0;
		
		
		for(int i=0; i<=dernier; i++)
		{
			debit+=ITreq.getDebit(i);
			credit+=ITreq.getCredit(i);
			IT+=(credit-debit);
		}
		
		
		// Amortissements
		reqCompta AMreq=new reqCompta( moisDebut, anneeDebut, moisFin, anneeFin,"AM", leDossierId, sessionId);
		dernier=AMreq.initEtGetEnum();

		debit=0; credit=0;
		
		
		for(int i=0; i<=dernier; i++)
		{
			debit+=AMreq.getDebit(i);
			credit+=AMreq.getCredit(i);
			AM+=(credit-debit);
		}
		
		
		// Achats directs
		reqCompta ADreq=new reqCompta( moisDebut, anneeDebut, moisFin, anneeFin,"AD", leDossierId, sessionId);
		dernier=ADreq.initEtGetEnum();

		debit=0; credit=0;
		
		
		for(int i=0; i<=dernier; i++)
		{
			debit+=ADreq.getDebit(i);
			credit+=ADreq.getCredit(i);
			AD+=(credit-debit);
		}
		
		
		// Chiffre d'affaires
		reqCompta CAreq=new reqCompta( moisDebut, anneeDebut, moisFin, anneeFin,"CA", leDossierId, sessionId);
		dernier=CAreq.initEtGetEnum();

		debit=0; credit=0;
		
		
		for(int i=0; i<=dernier; i++)
		{
			debit+=CAreq.getDebit(i);
			credit+=CAreq.getCredit(i);
			CA+=(credit-debit);
		}
	
			
	}
	
	public long getCP()
	{
		return CP;
	}
	
	public long getCF()
	{
		return CF;
	}
	
	public long getCE()
	{
		return CE;
	}
	
	public long getIT()
	{
		return IT;
	}
	
	public long getAM()
	{
		return AM;
	}
	
	public long getAD()
	{
		return AD;
	}
	
	public long getCA()
	{
		return CA;
	}
	

}
