package org.opensi.compta.actions.rapprochementBancaire;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;


public class OpSaisie {
	private int rapproId;
	private double montantC;
	private double montantD;
	private String libelle;
	private int pointage=0;
	private int ligRBId=0;
	private ArrayList<String> listoprb = new ArrayList<String>();
	private double solde;
	private double soldenonppointe;
	private double totcredit;
	private double totdebit;
	private Connection con;
	private String basedossier;
	private Long dateOp;
	public OpSaisie(Connection con, String basedossier) {	
		this.con=con;
		this.basedossier=basedossier;
	}
	public OpSaisie(int rapproId, double montantC, double montantD, String libelle, Long dateOp, Connection con, String basedossier) {
		this.rapproId = rapproId;
		this.montantC = montantC;
		this.montantD = montantD;
		this.libelle=libelle;
		this.dateOp=dateOp;
		this.con=con;
		this.basedossier=basedossier;
	}
	public ArrayList<String> getlistoprb() {
		return listoprb;
	}
	public int getLigRBId() {
		return ligRBId;
	}
	public void setLigRBId(int ligRBId) {
		this.ligRBId = ligRBId;
	}
	public int getPointage() {
		return pointage;
	}
	public void setPointage(int pointage) {
		this.pointage = pointage;
	}
	public String getLibelle() {
		return libelle;
	}
	public void setLibelle(String libelle) {
		this.libelle = libelle;
	}
	public double getMontantC() {
		return montantC;
	}
	public void setMontantC(double montantC) {
		this.montantC = montantC;
	}
	public double getMontantD() {
		return montantD;
	}
	public void setMontantD(double montantD) {
		this.montantD = montantD;
	}
	public int getRapproId() {
		return rapproId;
	}
	public void setRapproId(int rapproId) {
		this.rapproId = rapproId;
	}

	public void setSolde(double solde) {
		this.solde = solde;
	}
	public double getSolde() {
		return solde;
	}
	public double getTotcredit() {
		return totcredit;
	}
	public void setTotcredit(double totcredit) {
		this.totcredit = totcredit;
	}
	public double getTotdebit() {
		return totdebit;
	}
	public void setTotdebit(double totdebit) {
		this.totdebit = totdebit;
	}
	public double getSoldenonppointe() {
		return soldenonppointe;
	}
	public void setSoldenonppointe(double soldenonppointe) {
		this.soldenonppointe = soldenonppointe;
	}
	public String createOpSaisie() {
		String Status;
		PreparedStatement pstmt = null;		
		try {		 
			String INSERT_LIGNE =
				"INSERT INTO " + basedossier +".LIGNE_RB set Rappro_Id=?, Montant_C=?, Montant_D=?, Libelle=?, Date_Op=?";
			pstmt = con.prepareStatement(INSERT_LIGNE);      		  	    
			pstmt.setInt(1, rapproId);   
			pstmt.setDouble(2, montantC); 
			pstmt.setDouble(3, montantD); 
			pstmt.setString(4, libelle); 
			pstmt.setLong(5, dateOp);

			pstmt.executeUpdate();
			Status="1";
		}
		catch (SQLException sqle) {
			sqle.printStackTrace();
			Status="0";
		}
		return Status;
	}
	public String DeleteOpSaisie(Connection con) {
		String  Status = null;
		PreparedStatement pstmt = null;
		try {
			String DELETE_LIGNES_RAPPRO =
				"DELETE FROM " + basedossier +".LIGNE_RB where Rappro_Id=?";	
			pstmt = con.prepareStatement(DELETE_LIGNES_RAPPRO);   	 
			pstmt.setInt(1, rapproId);   
			pstmt.executeUpdate();
			Status ="1";

		}

		catch (SQLException sqle) {		    	
			sqle.printStackTrace();
			Status="error";
		}
		return Status;
	}
	public String DeletelgOpSaisie(Connection con) {
		String  Status = null;
		PreparedStatement pstmt = null;
		try {
			String DELETE_LIGNES_RAPPRO =
				"DELETE FROM " + basedossier +".LIGNE_RB where  Ligne_RB_Id=?";	
			pstmt = con.prepareStatement(DELETE_LIGNES_RAPPRO);   	 		     
			pstmt.setInt(1, getLigRBId());
			pstmt.executeUpdate();
			Status ="1";

		}

		catch (SQLException sqle) {		    	
			sqle.printStackTrace();
			Status="error";
		}
		return Status;
	}
	public void updatePointage(Connection con) {
		PreparedStatement pstmt = null;		
		try {		 
			String UPDATE_LIGNE =
				"UPDATE " + basedossier +".LIGNE_RB set Pointage=?  WHERE Ligne_RB_Id=?";
			pstmt = con.prepareStatement(UPDATE_LIGNE);      		 
			pstmt.setInt(1, getPointage());   
			pstmt.setInt(2, getLigRBId()); 	    
			pstmt.executeUpdate();
		}
		catch (SQLException sqle) {
			sqle.printStackTrace();
		}
	}
	public ArrayList<String> listeOpSaisie() {
		PreparedStatement pstmt = null;	

		try {

			String LISTE_OP_RB =						 
				"SELECT distinct Ligne_RB_Id from " + basedossier +".LIGNE_RB WHERE Rappro_Id=?";
			pstmt = con.prepareStatement(LISTE_OP_RB);      		 
			pstmt.setInt(1, rapproId);   		   
			ResultSet rs = pstmt.executeQuery();
			while (rs.next()) {	
				String op = rs.getString(1);		    	 
				listoprb.add(op);		    	
			}	  
		}
		catch (SQLException sqle) {
			sqle.printStackTrace();
		}
		return listoprb;
	}
	//insertion des op saisies non pointes sur le nouveau rapprochement  la cloture d'un rapprochement
	public void insertOpSaisieNonPointee(int rapproidcloture) {
		PreparedStatement pstmt = null;	

		try {		 
			String INSERT_LIGNE =
				"INSERT INTO " + basedossier +".LIGNE_RB (Rappro_Id,Montant_C,Montant_D,Libelle,Pointage, Date_Op) select ? , Montant_C, Montant_D, Libelle, Pointage, Date_Op  from " + basedossier +".LIGNE_RB where Rappro_Id=? and Pointage=0 ";
			pstmt = con.prepareStatement(INSERT_LIGNE); 		  	 
			pstmt.setInt(1, rapproId);  
			pstmt.setInt(2, rapproidcloture);
			pstmt.executeUpdate();

		}	
		catch (SQLException sqle) {
			sqle.printStackTrace();
		}

	}

	public void calculSoldesOpSaisie(String list) {
		PreparedStatement pstmt = null;
		PreparedStatement pstmt2 = null;
		try {						
			if (!list.equals("")){
				String SOLDES_OP =							 
					"SELECT SUM(Montant_D-Montant_C) as solde, SUM(Montant_C) as totcredit, SUM(Montant_D) as totdebit  from " + basedossier +".LIGNE_RB WHERE Ligne_RB_Id IN ("+list+")";					 					
				pstmt = con.prepareStatement(SOLDES_OP);    						
				ResultSet rs = pstmt.executeQuery();			     
				while (rs.next()) {	
					solde = rs.getDouble(1);			    	 
					totcredit = rs.getDouble(2);
					totdebit = rs.getDouble(3);					    	

				}

				String SOLDES_OP_NON_POINTEE =							 
					"SELECT SUM(Montant_D-Montant_C) as solde from " + basedossier +".LIGNE_RB WHERE Ligne_RB_Id IN ("+list+") and Pointage=0";					 					
				pstmt2 = con.prepareStatement(SOLDES_OP_NON_POINTEE);    						  
				ResultSet rs2 = pstmt2.executeQuery();			     
				while (rs2.next()) {	
					soldenonppointe = rs2.getDouble(1);			    	 					    	 					    	 

				}					 
			}
			else{
				solde=0;
				soldenonppointe =0;
				totcredit =0;
				totdebit =0;
			}


		}
		catch (SQLException sqle) {
			sqle.printStackTrace();
		}

	}
	public String getBase() {
		return basedossier;
	}
	public void setBase(String basedossier) {
		this.basedossier = basedossier;
	}
}
