package org.opensi.compta.actions.rapprochementBancaire;

import java.sql.Connection;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.tools.Arrondi;
import org.opensi.util.tools.DateTime;

public class InfoRapprochement extends Action {


		 
		
		public boolean serverSide() { return true; }

		  public boolean service(Session s, ServletRequest r, Object info) throws Exception {
			  Connection con = s.getConnection(null);
			
			  try{
				  
  			      String base = s.getCookie().get("BaseExo");
  			      String basedossier=s.getCookie().get("BaseDossier");
				  String req=r.getParameter("req");	
				  if (req.equals("infoRappro")){						  
				
					  int rapproid=new Integer(r.getParameter("rapproid"));					 
					  Rapprochement rappro=new Rapprochement(rapproid,con,base,basedossier);
					  rappro.loadRappro(rapproid);
					  r.addParameter("Num_Releve", rappro.getNumReleve());
					  String Date_Releve="";
					  String Date_Rappro=DateTime.formatTime(rappro.getDateRappro(),"dd/MM/yyyy").toString();
					  if (rappro.getDateReleve()==0){
						  Date_Releve="";  
					  }
					  else{
						 Date_Releve=DateTime.formatTime(rappro.getDateReleve(),"dd/MM/yyyy").toString();  
					  }					  					  
					  r.addParameter("Date_Rappro", Date_Rappro);
					  r.addParameter("Date_Releve", Date_Releve);
					  r.addParameter("Solde_Releve", new Double(rappro.getSoldeReleve()).toString());
					  
					  
					  
					  //	liste des operations saisies
					  String listopsaisie=rappro.getListopsaisie();						 									 
					  s.getCookie().set("oprb", listopsaisie);
					         //	liste des operations 					 
					  String listop=rappro.getListop();								 
					  s.getCookie().set("op", "");					  
					  s.getCookie().set("op", listop);	
					  double soldefinal=0;
					  //si le rapprochement est clotur on prend la valeur stock dans la base RAPPROCHEMENT
					  int iscloture=0;
					  
					  if (rappro.isCloture()){
						  
						  iscloture=1;
					  }
					  
					  soldefinal=rappro.getSoldeFinal();  					 
					  
					  //  attention il faut avoir fait le get sur les operations pour connaitre le nbre d'operation et les soldes
					  //  faire aprs getListop() et getListopsaisie() - ces methodes utilisent la liste des operations contruitent  partir du get
					  rappro.calculSoldesop();
					  	//si le rapprochement n'est pas cloture on calcul le solde final dans getSoldesop
					
					  if (iscloture==0){
						  soldefinal=rappro.getSoldeFinal();					
					  }
					  double soldecomptable=rappro.getSolde();
					  double totdebit=rappro.getTotdebit();
					  double totcredit=rappro.getTotcredit();
					  double soldeopnonpointee=rappro.getSoldenonppointe();
					  double soldeini=rappro.getSoldeINI();
					  
					  
					  //si le rapprochement est sur deux exercices on cre les listes oprb2 et op2 de l'exercice precedent
					  String deuxiemebase="";
					  if (iscloture==0){
						  //si l'exercice n'est pas clotur on vrifie si les dates se trouvent  cheval sur deux exercices
					  deuxiemebase = rappro.sEncoursSurDeuxExo(s);
					   	//sinon on verifie que les opid des lignes de rapprochement se trouvent toutes sur la meme base
					  	if (deuxiemebase.equals("")){
					  		deuxiemebase=rappro.sClotureSurDeuxExo(s);
					  	}
					  }
					  else if (iscloture==1){
						  //si l'exercice est cltur on vrifie si sur ce rappro, plusieurs Nom_Base sont insres (opid sur plusieurs bases)
						  deuxiemebase=rappro.sClotureSurDeuxExo(s);  
					  }
				
					  if (!deuxiemebase.equals("")){
						  r.addParameter("2exo", deuxiemebase); 
						  rappro.setBase(deuxiemebase);					
						   String listop2=rappro.getListop();
						   s.getCookie().set("op2", "");
						   s.getCookie().set("op2", listop2);
						 
						   //on recalcule les soldes sur la base de l'exercice precedent
						   rappro.calculSoldesop();						   
						   //le solde comptable est celui de l'exercice en cours (solde des op + l'AN)
						   //le solde initial est toujours celui stock en base
						   //le solde final est recalcul si on se trouve sur un exercice non clotur
						   Arrondi arrondi=new Arrondi(2); 
						   if (iscloture==0){								  
								  //on calcul le solde final, on soustrait les op non pointes de l'exercice precedent et les opsaisies non pointes (dej comptabilises)	
							   soldefinal=arrondi.round(soldefinal - (rappro.getSoldenonppointe()-rappro.getSoldeRBnonppointe()));
								 
							  }
							  //on ajoute les debits de l'exercice prcedent
							  totdebit=arrondi.round(totdebit + rappro.getTotdebitOp());		
							  //on ajoute les credits de l'exercice precedent
							  totcredit= arrondi.round(totcredit + rappro.getTotcreditOp());
							  //soldeopnonpointee=soldeopnonpointee + rappro.getSoldenonppointe();
					  }
					  else{
						  r.addParameter("2exo", "");
					  }	 	
					  
					  
					  r.addParameter("soldecomptable", new Double(soldecomptable).toString());
					  r.addParameter("totdebit", new Double(totdebit).toString());
					  r.addParameter("totcredit", new Double(totcredit).toString());
					  r.addParameter("soldeopnonpointee", new Double(soldeopnonpointee).toString());
					  r.addParameter("soldeini", new Double(soldeini).toString());
					  r.addParameter("soldefinal", new Double(soldefinal).toString());
					  r.addParameter("iscloture", new Integer(iscloture).toString());
				  }
				
			  }
			  catch (Exception e) {		        	

					 r.addParameter("status", "fail");
					 e.printStackTrace();
					
				     }
			  finally {					
				 
					  s.closeConnection(con,null);
			 }
			return true;
		  } 
				  
	}

