/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Edition du rapport de coherence comptable
 */

package org.opensi.compta.actions.rapports;

import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;


public class RapportCoherence extends Action {


	class MyPageEvent implements PdfPageEvent {

	private String dateCourante;

	private String dossierId;
	private String raisonSociale;
	private String adresse;
	private String compAdresse;
	private String codePostal;
	private String ville;
	
	private String debutExercice;
	private String finExercice;


		public MyPageEvent(Session session, String dossierId, String debutExercice, String finExercice, String baseDossier) throws Exception {
			
			this.dossierId = dossierId;
						
			Connection con = session.getConnection(null);
			Statement stt = con.createStatement();
			ResultSet rset = stt.executeQuery("select * from "+ baseDossier +".SOCIETE");

			rset.next();

			this.raisonSociale = rset.getString("Denomination");
			this.adresse = rset.getString("Adresse_1");
			this.compAdresse = rset.getString("Adresse_2");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");

			rset.close();				

			stt.close();
			session.closeConnection(con, null);			

			SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
			this.finExercice = formatDate.format(new Date(Long.parseLong(finExercice)));
			this.debutExercice = formatDate.format(new Date(Long.parseLong(debutExercice)));
			formatDate.applyPattern("dd/MM/yyyy - HH:mm:ss");
			this.dateCourante = formatDate.format(new Date(System.currentTimeMillis()));
			
		}

    public void onStartPage(PdfWriter writer, Document document) {

    	try {

				// Entete Gnrale
      	

				PdfPTable bandeau = new PdfPTable(1);
					
				bandeau.setWidthPercentage(100);

				PdfPTable entete = new PdfPTable(3);

				PdfPCell cellEntete = new PdfPCell(entete.getDefaultCell());

				cellEntete.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
				cellEntete.setBorderWidth(0);
				cellEntete.setMinimumHeight(10);

				cellEntete.setPhrase(new Phrase("Dossier : " + this.dossierId, fontGen));
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(raisonSociale, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);					

				cellEntete.setPhrase(new Phrase("Date : " + this.dateCourante, fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.adresse, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.compAdresse, fontGen));
				cellEntete.setColspan(3);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("Page : "+ document.getPageNumber(), fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.codePostal + " " + this.ville, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);					

				cellEntete.setPhrase(new Phrase("Rapport de Coherence Comptable", new Font(Font.HELVETICA, 16, Font.BOLD)));
				cellEntete.setColspan(3);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(""));
				cellEntete.setFixedHeight(10);
				entete.addCell(cellEntete);
				
								
				cellEntete.setPhrase(new Phrase("Exercice du " + this.debutExercice + " au " + this.finExercice, fontGen));
				cellEntete.setMinimumHeight(0);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);						
				
				
				PdfPCell cellBandeau = new PdfPCell(entete);					
				cellBandeau.setPadding(10);

				bandeau.addCell(cellBandeau);

				document.add(bandeau);
				
				// fin Entete Gnrale
				
			} 
			catch(DocumentException de) {	de.printStackTrace(); }
		
		}    

		public void onEndPage(PdfWriter writer, Document document) {}
		public void onOpenDocument(PdfWriter writer, Document document) {}    
    public void onCloseDocument(PdfWriter writer, Document document) {}
    public void onParagraph(PdfWriter writer, Document document, float paragraphPosition) {}
    public void onParagraphEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onChapter(PdfWriter writer,Document document,float paragraphPosition, Paragraph title) {}
    public void onChapterEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onSection(PdfWriter writer,Document document,float paragraphPosition, int depth, Paragraph title) {}
    public void onSectionEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onGenericTag(PdfWriter writer, Document document, Rectangle rect, String text) {}

	}


private static final Font fontGen = new Font(Font.HELVETICA , 10, Font.NORMAL);		// font pour lignes d'entete
private static final Font fontTitre = new Font(Font.HELVETICA , 10, Font.BOLD);		// font pour lignes de listing
private static final Font fontLine = new Font(Font.HELVETICA , 9, Font.NORMAL);		// font pour lignes de listing
private static final Font fontCol = new Font(Font.HELVETICA , 9, Font.BOLD);		// font pour lignes de listing
private DecimalFormat numFormat = new DecimalFormat("0.00");


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {

		
		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator('.');
		dfs.setGroupingSeparator(' ');
		
		numFormat.setDecimalFormatSymbols(dfs);
		numFormat.setNegativeSuffix("");
		numFormat.setNegativePrefix("-");
		numFormat.setPositiveSuffix(" ");
		numFormat.setGroupingUsed(true);
		numFormat.setGroupingSize(3);		
		
		String ctrlComptes = r.getParameter("CtrlComptes");
		String ctrlJournaux = r.getParameter("CtrlJournaux");
		String ctrlTiers = r.getParameter("CtrlTiers");
		String ctrlCJ = r.getParameter("CtrlCJ");
		
		String base = s.getCookie().get("BaseExo");
		String baseDossier = s.getCookie().get("BaseDossier");
		String dossierId = s.getCookie().get("Dossier_Id");
		String debutExercice = s.getCookie().get("Debut_Exercice");
		String finExercice = s.getCookie().get("Fin_Exercice");		
		
		ResultSet rset;		
		String requete;
		

		if (dossierId==null || base==null || finExercice==null || debutExercice==null) 
			return false;
			
		else {			
			
			
			Document document = new Document(PageSize.A4, 30, 25, 25, 25);

			String chemin = s.getAppConfiguration().get("opensi.absdir") + "/pdf/";

			PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(chemin + "rapport_coherence.pdf"));
      	
			MyPageEvent event = new MyPageEvent(s, dossierId, debutExercice, finExercice, baseDossier);

			writer.setPageEvent(event);									
				
			document.open();
			
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			
			putSpace(document, 25);
			
			requete = "select count(*) as NbComptes, sum(Total_Credit) as Credit, sum(Total_Debit) as Debit from "+baseDossier+".COMPTE c, "+ base +".SOLDE_COMPTE s where s.Numero_Compte=c.Numero_Compte and c.Type_Compte='G'";
			rset = stt.executeQuery(requete);
			
			double debitCptes = 0;
			double creditCptes = 0;			
			
			rset.next();
			debitCptes = rset.getDouble("Debit");
			creditCptes = rset.getDouble("Credit");
			putSectionEquilibreComptes(document,debitCptes,creditCptes,rset.getInt("NbComptes"), ctrlComptes);
			rset.close();
			
			putSpace(document, 30);
			
			putTitreSection(document, "EQUILIBRE DES JOURNAUX", ctrlJournaux);
			putSpace(document, 20);
			putColJournal(document);
			putSpace(document, 5);
			
			requete = "select e.Code_Journal, j.Intitule,count(*) as NbEc, sum(Montant_D) as Debit, sum(Montant_C) as Credit ";
      requete += " from "+baseDossier+".JOURNAL j, "+base+".ECRITURE e, "+base+".OPERATION o " ;
      requete += " where j.Code_Journal=e.Code_Journal and e.Ecriture_Id=o.Ecriture_Id group by e.Code_Journal, j.Intitule";
			rset = stt.executeQuery(requete);
			
			double debitTotal = 0;
			double creditTotal = 0;
			int nbEcritures = 0;
			
			
			while (rset.next()) {
				String code_journal = rset.getString("Code_Journal");
				String libelle = rset.getString("Intitule");
				double debit = rset.getDouble("Debit");
				double credit = rset.getDouble("Credit");
				int nbEc = rset.getInt("NbEc");

				debitTotal += debit;
				creditTotal += credit;
				nbEcritures += nbEc;

				putLigneJournal(document, code_journal, libelle, debit, credit, nbEc);
			}
			rset.close();
			
			
			putSpace(document, 5);
			putLigneTotaux(document, nbEcritures, debitTotal, creditTotal);
			
			putSpace(document, 30);
			putTitreSection(document, "COHERENCE COMPTES / JOURNAUX", ctrlCJ);
			putSpace(document, 20);
			putSectionCoherenceCJ(document, debitCptes, creditCptes, debitTotal, creditTotal);
			
			putSpace(document, 30);
			putTitreSection(document, "CONTROLE DES TIERS", ctrlTiers);
			putSpace(document, 20);
			
			requete = "select sum(Total_Debit) as Total_Debit, sum(Total_Credit) as Total_Credit from "+base+".SOLDE_COMPTE s join "+baseDossier+".COMPTE c on c.Numero_Compte=s.Numero_Compte where c.Centralisateur=1 and c.Numero_Compte like '401%'";
			rset = stt.executeQuery(requete);
			
			double debitCollectif = 0;
			double creditCollectif = 0;
			
			rset.next();
			debitCollectif = rset.getDouble("Total_Debit");
			creditCollectif = rset.getDouble("Total_Credit");
			rset.close();			
			
			requete = "select count(*) as NbComptes, sum(Total_Debit) as Total_Debit, sum(Total_Credit) as Total_Credit from "+baseDossier+".COMPTE c, "+ base +".SOLDE_COMPTE s where s.Numero_Compte=c.Numero_Compte and c.Type_Compte='F'";
			rset = stt.executeQuery(requete);
			
			double debitTiers = 0;
			double creditTiers = 0;
			int nbComptes = 0;
			
			rset.next();
			debitTiers = rset.getDouble("Total_Debit");
			creditTiers = rset.getDouble("Total_Credit");
			nbComptes = rset.getInt("NbComptes");
			rset.close();
			
			putSectionTiers(document, "F", debitTiers, creditTiers, debitCollectif, creditCollectif, nbComptes);
			putSpace(document, 20);
			
			requete = "select sum(Total_Debit) as Total_Debit, sum(Total_Credit) as Total_Credit from "+base+".SOLDE_COMPTE s join "+baseDossier+".COMPTE c on c.Numero_Compte=s.Numero_Compte where c.Centralisateur=1 and c.Numero_Compte like '411%'";
			rset = stt.executeQuery(requete);
			
			debitCollectif = 0;
			creditCollectif = 0;
			
			rset.next();
			debitCollectif = rset.getDouble("Total_Debit");
			creditCollectif = rset.getDouble("Total_Credit");
			rset.close();
			
			requete = "select count(*) as NbComptes, sum(Total_Debit) as Total_Debit, sum(Total_Credit) as Total_Credit from "+baseDossier+".COMPTE c, "+ base +".SOLDE_COMPTE s where s.Numero_Compte=c.Numero_Compte and Type_Compte='C'";
			rset = stt.executeQuery(requete);
			
			debitTiers = 0;
			creditTiers = 0;
			nbComptes = 0;
			
			rset.next();
			debitTiers = rset.getDouble("Total_Debit");
			creditTiers = rset.getDouble("Total_Credit");
			nbComptes = rset.getInt("NbComptes");
			rset.close();
			
			putSectionTiers(document, "C", debitTiers, creditTiers, debitCollectif, creditCollectif, nbComptes);
		
			stt.close();
			s.closeConnection(con, null);
		
			document.close();
			
			return true;
			
		}
				
	
	} // fin processRequest



	/** renvoi une section equilibre des comptes */


	private void putSectionEquilibreComptes(Document document, double debit, double credit, int nbComptes, String ctrlComptes) throws DocumentException {		
		
			
		putTitreSection(document, "EQUILIBRE DES COMPTES", ctrlComptes);
		putSpace(document, 20);
		
		PdfPTable infos = new PdfPTable(7);
		infos.setWidthPercentage(100);
		int[] widths = {10,9,20,9,20,9,23};
		infos.setWidths(widths);
		
		PdfPCell cell = new PdfPCell(infos.getDefaultCell());
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setFixedHeight(20);
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		
		cell.setPhrase(new Phrase(""));
		infos.addCell(cell);
		cell.setPhrase(new Phrase("Dbit :", fontLine));
		infos.addCell(cell);
		cell.setPhrase(new Phrase(numFormat.format(debit), fontLine));
		infos.addCell(cell);
		cell.setPhrase(new Phrase("Crdit :", fontLine));
		infos.addCell(cell);
		cell.setPhrase(new Phrase(numFormat.format(credit), fontLine));
		infos.addCell(cell);
		cell.setPhrase(new Phrase("Ecart :", fontLine));
		infos.addCell(cell);
		cell.setPhrase(new Phrase(numFormat.format(debit-credit), fontLine));		
		infos.addCell(cell);
		
		cell.setPhrase(new Phrase(""));
		infos.addCell(cell);
		cell.setColspan(6);
		cell.setPhrase(new Phrase("Nombre de comptes gnraux :  "+nbComptes, fontLine));
		infos.addCell(cell);
		
		document.add(infos);		
		
	}
	
	
	private void putSectionTiers(Document document, String tiers, double debitTiers, double creditTiers, double debitCollectif, double creditCollectif, int nbComptes) throws DocumentException {
	
		PdfPTable infos = new PdfPTable(5);
		infos.setWidthPercentage(100);
		int[] widths = {10,30,16,16,28};
		infos.setWidths(widths);
		
		PdfPCell cell = new PdfPCell(infos.getDefaultCell());
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		
		// entetes colonnes
		cell.setPhrase(new Phrase(""));
		infos.addCell(cell);
		infos.addCell(cell);
		cell.setBorder(PdfPCell.BOX);
		cell.setPhrase(new Phrase("DEBIT", fontCol));
		infos.addCell(cell);
		cell.setPhrase(new Phrase("CREDIT", fontCol));
		infos.addCell(cell);
		
		cell.setPhrase(new Phrase(""));
		cell.setBorder(PdfPCell.NO_BORDER);
		infos.addCell(cell);	
		
		
		cell.setPaddingRight(5);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		
		// ligne compte tiers
		cell.setPhrase(new Phrase(""));
		infos.addCell(cell);
		cell.setBorder(PdfPCell.BOX);
		cell.setPhrase(new Phrase("COMPTES "+(tiers.equalsIgnoreCase("F")?"FOURNISSEURS":"CLIENTS"), fontCol));
		infos.addCell(cell);		
		cell.setPhrase(new Phrase(numFormat.format(debitTiers), fontLine));
		infos.addCell(cell);
		cell.setPhrase(new Phrase(numFormat.format(creditTiers), fontLine));
		infos.addCell(cell);
		
		cell.setPhrase(new Phrase(""));
		cell.setBorder(PdfPCell.NO_BORDER);
		infos.addCell(cell);	
		
		// ligne compte collectif
		cell.setPhrase(new Phrase(""));
		infos.addCell(cell);
		cell.setBorder(PdfPCell.BOX);
		cell.setPhrase(new Phrase("COMPTES COLLECTIFS "+(tiers.equalsIgnoreCase("F")?"401":"411"), fontCol));
		infos.addCell(cell);	
		cell.setPhrase(new Phrase(numFormat.format(debitCollectif), fontLine));
		infos.addCell(cell);
		cell.setPhrase(new Phrase(numFormat.format(creditCollectif), fontLine));
		infos.addCell(cell);
		
		cell.setPhrase(new Phrase(""));
		cell.setBorder(PdfPCell.NO_BORDER);
		infos.addCell(cell);	
		
		// ligne ecarts
		cell.setPhrase(new Phrase(""));
		infos.addCell(cell);
		cell.setBorder(PdfPCell.BOX);
		cell.setPhrase(new Phrase("ECART", fontCol));
		infos.addCell(cell);	
		cell.setPhrase(new Phrase(numFormat.format(debitTiers-debitCollectif), fontLine));
		infos.addCell(cell);
		cell.setPhrase(new Phrase(numFormat.format(creditTiers-creditCollectif), fontLine));
		infos.addCell(cell);
		
		cell.setPhrase(new Phrase(""));
		cell.setBorder(PdfPCell.NO_BORDER);
		infos.addCell(cell);
		
		// espace
		cell.setPhrase(new Phrase(""));
		cell.setColspan(5);
		cell.setFixedHeight(10);
		cell.setBorder(PdfPCell.NO_BORDER);
		infos.addCell(cell);		
		
		// ligne nombre de comptes
		cell.setColspan(1);
		cell.setMinimumHeight(1);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cell.setPhrase(new Phrase(""));
		infos.addCell(cell);
		cell.setPhrase(new Phrase("Nombre de comptes "+(tiers.equalsIgnoreCase("F")?"fournisseurs : ":"clients : "), fontLine));
		infos.addCell(cell);
		cell.setColspan(3);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cell.setPhrase(new Phrase(""+nbComptes, fontLine));
		infos.addCell(cell);		
		
		document.add(infos);
	
	}
	
	private void putSectionCoherenceCJ(Document document, double debitCptes, double creditCptes, double debitJournaux, double creditJournaux) throws DocumentException {
		
		PdfPTable infos = new PdfPTable(5);
		infos.setWidthPercentage(100);
		int[] widths = {10,15,20,15,40};
		infos.setWidths(widths);
		
		PdfPCell cell = new PdfPCell(infos.getDefaultCell());
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		
		cell.setPhrase(new Phrase(""));
		infos.addCell(cell);
		cell.setPhrase(new Phrase("Ecart au dbit :", fontLine));
		infos.addCell(cell);
		cell.setPhrase(new Phrase(numFormat.format(debitCptes-debitJournaux), fontLine));
		infos.addCell(cell);
		cell.setPhrase(new Phrase("Ecart au crdit :", fontLine));
		infos.addCell(cell);
		cell.setPhrase(new Phrase(numFormat.format(creditCptes-creditJournaux), fontLine));
		infos.addCell(cell);
		
		document.add(infos);		
	
	}	
	
	private void putColJournal(Document document) throws DocumentException {
		
		PdfPTable infos = new PdfPTable(7);
		infos.setWidthPercentage(100);
		int[] widths = {10,5,30,12,16,16,11};
		infos.setWidths(widths);
		
		PdfPCell cell = new PdfPCell(infos.getDefaultCell());
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		
		cell.setPhrase(new Phrase(""));
		infos.addCell(cell);
		cell.setBorder(PdfPCell.BOX);
		cell.setPhrase(new Phrase("CJ", fontCol));
		infos.addCell(cell);
		cell.setPhrase(new Phrase("INTITULE", fontCol));
		infos.addCell(cell);		
		cell.setPhrase(new Phrase("ECRITURES", fontCol));
		infos.addCell(cell);
		cell.setPhrase(new Phrase("DEBIT", fontCol));
		infos.addCell(cell);
		cell.setPhrase(new Phrase("CREDIT", fontCol));
		infos.addCell(cell);
		cell.setPhrase(new Phrase("ECART", fontCol));
		infos.addCell(cell);
		
		document.add(infos);
		
	}
	
	
	private void putLigneTotaux(Document document, int nbEc, double debit, double credit) throws DocumentException {
		
		PdfPTable infos = new PdfPTable(6);
		infos.setWidthPercentage(100);
		int[] widths = {10,35,12,16,16,11};
		infos.setWidths(widths);
		
		PdfPCell cell = new PdfPCell(infos.getDefaultCell());
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		
		cell.setPhrase(new Phrase(""));
		infos.addCell(cell);
		cell.setBorder(PdfPCell.BOX);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cell.setPaddingRight(5);
		cell.setPhrase(new Phrase("TOTAUX", fontCol));
		infos.addCell(cell);		
		
		cell.setPhrase(new Phrase(""+nbEc, fontCol));
		infos.addCell(cell);
		cell.setPhrase(new Phrase(numFormat.format(debit), fontCol));
		infos.addCell(cell);
		cell.setPhrase(new Phrase(numFormat.format(credit), fontCol));
		infos.addCell(cell);
		cell.setPhrase(new Phrase(numFormat.format(debit-credit), fontCol));
		infos.addCell(cell);
		
		document.add(infos);
		
	}
	
	
	private void putLigneJournal(Document document, String code, String libelle, double debit, double credit, int nbEc) throws DocumentException {
		
		PdfPTable infos = new PdfPTable(7);
		infos.setWidthPercentage(100);
		int[] widths = {10,5,30,12,16,16,11};
		infos.setWidths(widths);
		
		PdfPCell cell = new PdfPCell(infos.getDefaultCell());
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		
		cell.setPhrase(new Phrase(""));
		infos.addCell(cell);
		cell.setBorder(PdfPCell.BOX);
		cell.setPhrase(new Phrase(code, fontLine));
		infos.addCell(cell);
		cell.setPhrase(new Phrase(libelle, fontLine));
		infos.addCell(cell);
		
		cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cell.setPaddingRight(5);
		
		cell.setPhrase(new Phrase(""+nbEc, fontLine));
		infos.addCell(cell);
		cell.setPhrase(new Phrase(numFormat.format(debit), fontLine));
		infos.addCell(cell);
		cell.setPhrase(new Phrase(numFormat.format(credit), fontLine));
		infos.addCell(cell);
		cell.setPhrase(new Phrase(numFormat.format(debit-credit), fontLine));
		infos.addCell(cell);
		
		document.add(infos);
		
	}
	
	private void putTitreSection(Document document, String titre, String ctrl) throws DocumentException {
	
		PdfPTable sectionTitre = new PdfPTable(2);	
		sectionTitre.setWidthPercentage(100);		
		
		PdfPCell cell = new PdfPCell(sectionTitre.getDefaultCell());
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setFixedHeight(25);
		cell.setBorder(PdfPCell.BOX-PdfPCell.RIGHT);
		
		cell.setPhrase(new Phrase(titre, fontTitre));
		sectionTitre.addCell(cell);
		
		cell.setBorder(PdfPCell.BOX-PdfPCell.LEFT);
		cell.setPaddingRight(5);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cell.setPhrase(new Phrase(ctrl.equals("1")?"> OK":"> Incoherence", fontTitre));
		sectionTitre.addCell(cell);
		
		document.add(sectionTitre);
	}
	

	private void putSpace(Document document, int space) throws DocumentException {
	
		PdfPTable sectionSpace = new PdfPTable(1);	
		sectionSpace.setWidthPercentage(100);		
		
		PdfPCell cell = new PdfPCell(sectionSpace.getDefaultCell());
		
		cell.setPhrase(new Phrase(""));
		cell.setFixedHeight(space);
		cell.setBorder(PdfPCell.NO_BORDER);
		sectionSpace.addCell(cell);
		
		document.add(sectionSpace);			
	}
	

} // fin RapportCoherence
