/******************************************************************************/
/* OpenSI : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Edition des balances ages fournisseurs et clients.
 */

package org.opensi.compta.actions.etats;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.tools.DateTime;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;


public class GenPdfBalanceAgee extends Action {


	class MyPageEvent implements PdfPageEvent {

	private String dateCourante;

	private String dossierId;
	private String raisonSociale;
	private String adresse;
	private String compAdresse;
	private String codePostal;
	private String ville;
	private String monnaieTenue;

	private String titre;
	private String debutExercice;
	private String finExercice;
	private String colNonAff;


		public MyPageEvent(String dossierId, String type, String debutExercice, String finExercice) throws SQLException {

			this.dossierId = dossierId;
			this.titre = type.equals("C")?"Clients":"Fournisseurs";
			this.colNonAff = type.equals("C")?"Cr\u00E9dit":"D\u00E9bit";

			String reqLeDossier = "select s.Denomination, s.Adresse_1, s.Adresse_2, s.Code_Postal, s.Ville, d.Intitule as Devise from "+ baseDossier +".SOCIETE s join DEVISE d on s.Monnaie_Tenue=d.Devise_Id";

			Statement stt = con.createStatement();
			ResultSet rset = stt.executeQuery(reqLeDossier);

			rset.next();

			this.raisonSociale = rset.getString("Denomination");
			this.adresse = rset.getString("Adresse_1");
			this.compAdresse = rset.getString("Adresse_2");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.monnaieTenue = rset.getString("Devise");

			rset.close();

			stt.close();

			SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
			this.dateCourante = formatDate.format(new Date(System.currentTimeMillis()));
			this.finExercice = formatDate.format(new Date(Long.parseLong(finExercice)));
			this.debutExercice = formatDate.format(new Date(Long.parseLong(debutExercice)));
		}

    public void onStartPage(PdfWriter writer, Document document) {

    	try {

				// Entete Gnrale


				PdfPTable bandeau = new PdfPTable(1);

				bandeau.setWidthPercentage(100);

				PdfPTable entete = new PdfPTable(3);

				PdfPCell cellEntete = new PdfPCell(entete.getDefaultCell());

				cellEntete.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
				cellEntete.setBorderWidth(0);
				cellEntete.setMinimumHeight(10);

				cellEntete.setPhrase(new Phrase("Dossier : " + this.dossierId, fontGen));
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(raisonSociale, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("Date : " + this.dateCourante, fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.adresse, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.compAdresse, fontGen));
				cellEntete.setColspan(3);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("Page : "+ document.getPageNumber(), fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.codePostal + " " + this.ville, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase("Balance Ag\u00E9e "+ titre+ " en "+ monnaieTenue, new Font(Font.HELVETICA, 16, Font.BOLD)));
				cellEntete.setColspan(3);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(""));
				cellEntete.setFixedHeight(10);
				entete.addCell(cellEntete);


				cellEntete.setPhrase(new Phrase("Exercice du " + this.debutExercice + " au " + this.finExercice, fontGen));
				cellEntete.setMinimumHeight(0);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);


				PdfPCell cellBandeau = new PdfPCell(entete);
				cellBandeau.setPadding(10);

				bandeau.addCell(cellBandeau);

				document.add(bandeau);

				// fin Entete Gnrale

				SimpleDateFormat formatDate2 = new SimpleDateFormat("dd/MM/yy");

				// Titres de colonnes

				PdfPTable titresColonnes = new PdfPTable(9);
				titresColonnes.setWidthPercentage(100);
				titresColonnes.setWidths(widths);
				PdfPCell cellTitre = new PdfPCell(titresColonnes.getDefaultCell());

				cellTitre.setFixedHeight(12);
				cellTitre.setBorder(PdfPCell.NO_BORDER);
				cellTitre.setPhrase(new Phrase(""));
				cellTitre.setColspan(9);
				titresColonnes.addCell(cellTitre);
				cellTitre.setColspan(2);

				cellTitre.setFixedHeight(18);
				cellTitre.setBackgroundColor(Color.LIGHT_GRAY);
				cellTitre.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

				cellTitre.setBorder(PdfPCell.BOX - PdfPCell.BOTTOM);
				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				cellTitre.setPaddingRight(5);
				cellTitre.setPhrase(new Phrase("Sommes dues depuis le", fontLine));
				titresColonnes.addCell(cellTitre);
				cellTitre.setPaddingRight(0);

				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				cellTitre.setColspan(1);
				cellTitre.setPhrase(new Phrase(formatDate2.format(new Date(dateTranche4)), fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase(formatDate2.format(new Date(dateTranche3)), fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase(formatDate2.format(new Date(dateTranche2)), fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase(formatDate2.format(new Date(dateTranche1)), fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase(formatDate2.format(new Date(dateTranche0)), fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase(colNonAff +" non", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setBorder(PdfPCell.BOX - PdfPCell.TOP - PdfPCell.RIGHT);
				cellTitre.setPhrase(new Phrase("COMPTE", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setBorder(PdfPCell.BOX - PdfPCell.TOP - PdfPCell.LEFT);
				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				cellTitre.setPhrase(new Phrase("INTITULE", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setBorder(PdfPCell.BOX - PdfPCell.TOP);
				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				cellTitre.setPhrase(new Phrase("+ de "+ tranche4 +"j", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase(tranche3+ " \u00E0 "+ tranche4 +"j", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase(tranche2+ " \u00E0 "+ tranche3 +"j", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase(tranche1+ " \u00E0 "+ tranche2 +"j", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("0 \u00E0 "+ tranche1 +"j", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("affect\u00E9", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("SOLDE", fontLine));
				titresColonnes.addCell(cellTitre);

				document.add(titresColonnes);

				// fin Titres de colonnes

			}
			catch(DocumentException de) {	de.printStackTrace(); }

		}

		public void onEndPage(PdfWriter writer, Document document) {}
		public void onOpenDocument(PdfWriter writer, Document document) {}
    public void onCloseDocument(PdfWriter writer, Document document) {}
    public void onParagraph(PdfWriter writer, Document document, float paragraphPosition) {}
    public void onParagraphEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onChapter(PdfWriter writer,Document document,float paragraphPosition, Paragraph title) {}
    public void onChapterEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onSection(PdfWriter writer,Document document,float paragraphPosition, int depth, Paragraph title) {}
    public void onSectionEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onGenericTag(PdfWriter writer, Document document, Rectangle rect, String text) {}

	}


private static final Font fontGen = new Font(Font.HELVETICA , 10, Font.NORMAL);		// font pour lignes d'entete
private static final Font fontLine = new Font(Font.HELVETICA , 9, Font.NORMAL);		// font pour lignes de listing
private DecimalFormat numFormat = new DecimalFormat("0.00");
private DecimalFormat numFormat2 = new DecimalFormat("0");

private int widths[] = {10,20,10,10,10,10,10,10,10}; // largeurs des colonnes du listing
private String tranche1;
private String tranche2;
private String tranche3;
private String tranche4;
private long dateTranche0;
private long dateTranche1;
private long dateTranche2;
private long dateTranche3;
private long dateTranche4;

private Connection con;
private String baseDossier;


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {


		con = s.getConnection(null);


		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator('.');
		dfs.setGroupingSeparator(' ');

		numFormat.setDecimalFormatSymbols(dfs);
		numFormat.setGroupingUsed(true);
		numFormat.setGroupingSize(3);

		numFormat2.setDecimalFormatSymbols(dfs);
		numFormat2.setGroupingUsed(true);
		numFormat2.setGroupingSize(3);


		String dossierId = s.getCookie().get("Dossier_Id");
		String base = s.getCookie().get("BaseExo");
		baseDossier = s.getCookie().get("BaseDossier");

		String debutExercice = r.getParameter("Debut_Exercice");
		String finExercice = r.getParameter("Fin_Exercice");
		String dateFin = r.getParameter("Date_Fin");
		String type = r.getParameter("Type");
		String tri = r.getParameter("Tri");
		String periode = r.getParameter("Periode");
		this.tranche1 = r.getParameter("Tranche1");
		this.tranche2 = r.getParameter("Tranche2");
		this.tranche3 = r.getParameter("Tranche3");
		this.tranche4 = r.getParameter("Tranche4");

		ResultSet rset;  // sommes dues

		long finPeriode;

		String numeroCompte;
		String intitule;

		String selDebit;
		String selCredit;

		String ordre;

		double sommeTranche1;
		double sommeTranche2;
		double sommeTranche3;
		double sommeTranche4;
		double sommeTranche5;
		double sommeNonAff;

		double totalTranche1 = 0;
		double totalTranche2 = 0;
		double totalTranche3 = 0;
		double totalTranche4 = 0;
		double totalTranche5 = 0;
		double totalNonAff = 0;

		long unJour = 24*60*60*1000;


		if (periode.equalsIgnoreCase("dd")) {
			finPeriode = DateTime.parseDate(dateFin, "dd/MM/yy");
		}
		else {
			DateTime dt = new DateTime();
			finPeriode = dt.getDateInMillis();
		}

		if (type.equalsIgnoreCase("C")) {
			selDebit = "tranche";
			selCredit = "nonaff";
		}
		else {
			selDebit = "nonaff";
			selCredit = "tranche";
		}

		dateTranche0 = finPeriode;
		dateTranche1 = finPeriode - Long.parseLong(tranche1)*unJour;
		dateTranche2 = finPeriode - Long.parseLong(tranche2)*unJour;
		dateTranche3 = finPeriode - Long.parseLong(tranche3)*unJour;
		dateTranche4 = finPeriode - Long.parseLong(tranche4)*unJour;


		Document document = new Document(PageSize.A4, 25, 25, 25, 25);

		String chemin = s.getAppConfiguration().get("opensi.absdir") + "/pdf/";

		String fichierPdf = r.getParameter("FichierPDF");

		PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(chemin + fichierPdf));

		MyPageEvent event = new MyPageEvent(dossierId, type, debutExercice, finExercice);

		writer.setPageEvent(event);

		document.open();


		PdfPTable listing = new PdfPTable(9);
		listing.setWidthPercentage(100);
		listing.setWidths(widths);

		if (tri.equalsIgnoreCase("N")) {
			ordre = "c.Numero_Compte";
		}
		else if (tri.equalsIgnoreCase("A")) {
			ordre = "c.Intitule";
		}
		else {
			ordre = "s.Solde desc";
		}

		Statement stt = con.createStatement();
		PreparedStatement ps = con.prepareStatement("select sum(Montant_C) as "+ selCredit +", sum(Montant_D) as "+ selDebit +" from "+ base +".OPERATION where Lettre='' and	Numero_Compte=? and ((Date_Echeance>0 and Date_Echeance>? and Date_Echeance<=?) or (Date_Echeance=0 and Date_Op>? and Date_Op<=?))");

		String reqLesComptes = "select c.Numero_Compte, c.Intitule from "+ baseDossier +".COMPTE c join "+ base +".SOLDE_COMPTE s on c.Numero_Compte=s.Numero_Compte where s.Solde<>0 and c.Type_Compte='"+ type +"' order by "+ ordre;
		ResultSet rset0 = stt.executeQuery(reqLesComptes);

		while (rset0.next()) {

			numeroCompte = rset0.getString("Numero_Compte");
			intitule = rset0.getString("Intitule");

			sommeTranche1 = 0;
			sommeTranche2 = 0;
			sommeTranche3 = 0;
			sommeTranche4 = 0;
			sommeTranche5 = 0;
			sommeNonAff = 0;

			ps.clearParameters();
			ps.setString(1,numeroCompte);
			ps.setLong(2,dateTranche1);
			ps.setLong(3,finPeriode);
			ps.setLong(4,dateTranche1);
			ps.setLong(5,finPeriode);

			rset = ps.executeQuery();

			if (rset.next()) {
				sommeTranche1 = rset.getDouble("tranche");
				sommeNonAff += rset.getDouble("nonaff");
				totalTranche1 += sommeTranche1;
			}
			rset.close();

			ps.clearParameters();
			ps.setString(1,numeroCompte);
			ps.setLong(2,dateTranche2);
			ps.setLong(3,dateTranche1);
			ps.setLong(4,dateTranche2);
			ps.setLong(5,dateTranche1);

			rset = ps.executeQuery();

			if (rset.next()) {
				sommeTranche2 = rset.getDouble("tranche");
				sommeNonAff += rset.getDouble("nonaff");
				totalTranche2 += sommeTranche2;
			}
			rset.close();

			ps.clearParameters();
			ps.setString(1,numeroCompte);
			ps.setLong(2,dateTranche3);
			ps.setLong(3,dateTranche2);
			ps.setLong(4,dateTranche3);
			ps.setLong(5,dateTranche2);

			rset = ps.executeQuery();

			if (rset.next()) {
				sommeTranche3 = rset.getDouble("tranche");
				sommeNonAff += rset.getDouble("nonaff");
				totalTranche3 += sommeTranche3;
			}
			rset.close();

			ps.clearParameters();
			ps.setString(1,numeroCompte);
			ps.setLong(2,dateTranche4);
			ps.setLong(3,dateTranche3);
			ps.setLong(4,dateTranche4);
			ps.setLong(5,dateTranche3);

			rset = ps.executeQuery();

			if (rset.next()) {
				sommeTranche4 = rset.getDouble("tranche");
				sommeNonAff += rset.getDouble("nonaff");
				totalTranche4 += sommeTranche4;
			}
			rset.close();

			ps.clearParameters();
			ps.setString(1,numeroCompte);
			ps.setLong(2,0);
			ps.setLong(3,dateTranche4);
			ps.setLong(4,0);
			ps.setLong(5,dateTranche4);

			rset = ps.executeQuery();

			if (rset.next()) {
				sommeTranche5 = rset.getDouble("tranche");
				sommeNonAff += rset.getDouble("nonaff");
				totalTranche5 += sommeTranche5;
			}
			rset.close();

			totalNonAff += sommeNonAff;
			putLigneBalanceAgee(listing, numeroCompte, intitule, sommeTranche1, sommeTranche2, sommeTranche3, sommeTranche4, sommeTranche5, sommeNonAff);

		}
		rset0.close();

		stt.close();
		ps.close();

		putTotalGeneral(listing, totalTranche1, totalTranche2, totalTranche3, totalTranche4, totalTranche5, totalNonAff);

		document.add(listing);

		document.close();

		s.closeConnection(con, null);


		try {
			File filePdf = new File(chemin, fichierPdf);
			filePdf.deleteOnExit();
		}
		catch(SecurityException se) {
			s.trace("Impossible d'enregistrer le fichier  supprimer");
			se.printStackTrace();
		}


		return true;


	} // fin service



	/** Ajoute une ligne au listing */

	private void putLigneBalanceAgee(PdfPTable listing, String compte, String intitule, double tranche1, double tranche2, double tranche3, double tranche4, double tranche5, double nonAff) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setBorder(PdfPCell.LEFT);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPhrase(new Phrase(compte, fontLine));
		listing.addCell(cellListing);

		cellListing.setBorder(PdfPCell.RIGHT);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setPhrase(new Phrase(intitule, fontLine));
		listing.addCell(cellListing);

		cellListing.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);
		cellListing.setPaddingRight(4);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase(tranche5==0?"":numFormat2.format(tranche5), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(tranche4==0?"":numFormat2.format(tranche4), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(tranche3==0?"":numFormat2.format(tranche3), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(tranche2==0?"":numFormat2.format(tranche2), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(tranche1==0?"":numFormat2.format(tranche1), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(nonAff==0?"":numFormat2.format(nonAff), fontLine));
		listing.addCell(cellListing);

		double solde = tranche1 + tranche2 + tranche3 + tranche4 + tranche5 - nonAff;

		cellListing.setPhrase(new Phrase(numFormat.format(solde), fontLine));
		listing.addCell(cellListing);

	}


	/** Ajoute une ligne de total au listing */

	private void putTotalGeneral(PdfPTable listing, double tranche1, double tranche2, double tranche3, double tranche4, double tranche5, double nonAff) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setBackgroundColor(Color.LIGHT_GRAY);
		cellListing.setBorder(PdfPCell.BOX);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(4);
		cellListing.setFixedHeight(20);

		cellListing.setColspan(2);
		cellListing.setPhrase(new Phrase("Total G\u00E9n\u00E9ral", fontLine));
		listing.addCell(cellListing);

		cellListing.setColspan(1);
		cellListing.setPhrase(new Phrase(tranche5==0?"":numFormat2.format(tranche5), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(tranche4==0?"":numFormat2.format(tranche4), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(tranche3==0?"":numFormat2.format(tranche3), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(tranche2==0?"":numFormat2.format(tranche2), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(tranche1==0?"":numFormat2.format(tranche1), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(nonAff==0?"":numFormat2.format(nonAff), fontLine));
		listing.addCell(cellListing);

		double solde = tranche1 + tranche2 + tranche3 + tranche4 + tranche5 - nonAff;

		cellListing.setPhrase(new Phrase(numFormat.format(solde), fontLine));
		listing.addCell(cellListing);

	}


} // fin GenPdfBalanceAgee
