/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Edition du grand livre.
 */

package org.opensi.compta.actions.etats;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.listing.ListingFile;
import org.opensi.util.listing.ListingTabFile;
import org.opensi.util.tools.DateTime;


public class GenCsvGrandLivre extends Action {


private DecimalFormat numFormat = new DecimalFormat("0.00");

private boolean exocomplet;
private long debutPeriode;
private long finPeriode;
private String base;
private String baseDossier;
private String cpteDebut;
private String cpteFin;
private String edCpte;
private String edEcriture;
private String edition;
private String debutExercice;
private String finExercice;

private Connection con;


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {


		con = s.getConnection(null);

		this.base = s.getCookie().get("BaseExo");
		this.debutExercice = r.getParameter("Debut_Exercice");
		this.finExercice = r.getParameter("Fin_Exercice");
		String dateDebut = r.getParameter("Date_Debut");
		String dateFin = r.getParameter("Date_Fin");
		String type = r.getParameter("Type");
		String periode = r.getParameter("Periode");
		this.edition = r.getParameter("Edition");
		this.cpteDebut = r.getParameter("Cpte_Debut");
		this.cpteFin = r.getParameter("Cpte_Fin");
		this.edCpte = r.getParameter("Ed_Cpte");
		this.edEcriture = r.getParameter("Ed_Ecriture");
		this.baseDossier = s.getCookie().get("BaseDossier");

		if (periode.equals("dd")) {
			debutPeriode = DateTime.parseDate(dateDebut, "dd/MM/yy");
			finPeriode = DateTime.parseDate(dateFin, "dd/MM/yy");
			exocomplet = false;
		}
		else {
			debutPeriode = Long.parseLong(debutExercice);
			finPeriode = Long.parseLong(finExercice);
			exocomplet = true;
		}


		String buffer = s.getAppConfiguration().get("opensi.absdir") + "/iobuffer/";
		String fichier = r.getParameter("FichierCSV");

		ListingFile lf = new ListingTabFile();

		lf.newLine();
		lf.addToLine("Date");
		lf.addToLine("CJ");
		lf.addToLine("Libell\u00E9");
		lf.addToLine("N\u00B0 Pi\u00E8ce");
		lf.addToLine("D\u00E9bit");
		lf.addToLine("LT");
		lf.addToLine("Cr\u00E9dit");
		lf.addToLine("Solde");
		lf.addToLine("Infos");
		lf.addToLine("Date \u00E9ch\u00E9ance");


		if (type.equalsIgnoreCase("T")) {
			putGrandLivre(lf, "C");
			putGrandLivre(lf, "F");
			putGrandLivre(lf, "A");
			putGrandLivre(lf, "G");
		}
		else {
			putGrandLivre(lf, type);
		}
		
		lf.write(buffer, fichier, true);

		s.closeConnection(con, null);


		return true;


	} // fin service


	private void putGrandLivre(ListingFile listing, String typeLivre) throws Exception {

		ResultSet rset;  // operations
		ResultSet rset2; // journaux
		ResultSet rset3; // ecritures

		double soldeInter;
		double debitOp;
		double creditOp;

		boolean afficheCompte;

		String Numero;
		String Numero2;
		String Numero1;
		String index2 = "";
		String index1 = "";

		double solde2 = 0;
		double debit2 = 0;
		double credit2 = 0;

		double solde1 = 0;
		double debit1 = 0;
		double credit1 = 0;

		double solde = 0;
		double debit = 0;
		double credit = 0;

		double soldeCpte = 0;
		double debitCpte = 0;
		double creditCpte = 0;


		String reqComptes = "select Numero_Compte, Intitule, Centralisateur from "+ baseDossier +".COMPTE where Type_Compte='"+ typeLivre +"'";

		if (edition.equals("P")) {
			reqComptes += " and Numero_Compte<='"+ cpteFin +"' and Numero_Compte>='"+ cpteDebut +"'";
		}

		reqComptes += " order by Numero_Compte";


		String reqSoldesGen = "select sum(Montant_D) as Debit, sum(Montant_C) as Credit from "+ base +".OPERATION where Numero_Compte=?";
		String reqSoldesAux = "select sum(Montant_D) as Debit, sum(Montant_C) as Credit from "+ base +".OPERATION o,"+ baseDossier +".COMPTE c where c.Collectif=? and o.Numero_Compte=c.Numero_Compte";
		String reqOperations = "select Num_Piece, Date_Op, Date_Echeance, Code_Journal, Contrepartie, Libelle, Lettre, Montant_D, Montant_C, Commentaire from "+	base +".ECRITURE e,"+ base +".OPERATION o where o.Ecriture_Id=e.Ecriture_Id and o.Numero_Compte=?";


		if (!exocomplet) {
			String suiteReq = (Long.parseLong(debutExercice)==debutPeriode
												?" and Date_Op<="+ finPeriode
												:" and Date_Op<="+ finPeriode +" and Date_Op>="+ debutPeriode);

			reqSoldesGen += suiteReq;
			reqSoldesAux += suiteReq;
			reqOperations += suiteReq;
		}

		if (edEcriture.equalsIgnoreCase("N")) {
			reqOperations += " and Lettre=''";
		}
		else if (edEcriture.equalsIgnoreCase("S")) {
			reqOperations += " and Lettre<>''";
		}

		reqOperations += " order by Date_Op";


		PreparedStatement psSoldesGen = con.prepareStatement(reqSoldesGen);
		PreparedStatement psSoldesAux = con.prepareStatement(reqSoldesAux);
		PreparedStatement psOperations = con.prepareStatement(reqOperations);


		Statement stt = con.createStatement();
		rset = stt.executeQuery(reqComptes);

		while (rset.next()) {

			Numero = rset.getString("Numero_Compte");
			Numero2 = Numero.substring(0,2);
			Numero1 = Numero.substring(0,1);


			if (rset.getInt("Centralisateur")==1)
				{ psSoldesAux.setString(1, Numero); rset2 = psSoldesAux.executeQuery(); }
			else
				{	psSoldesGen.setString(1, Numero);	rset2 = psSoldesGen.executeQuery(); }


			while (rset2.next()) {
				debitCpte = rset2.getDouble("Debit");
				creditCpte = rset2.getDouble("Credit");
				soldeCpte = debitCpte - creditCpte;
			}
			rset2.close();

			if (!index2.equals("") && Numero2.compareTo(index2)!=0) {
				putLigneClasse(listing, index2, debit2, credit2, solde2);
				debit2 = 0;
				credit2 = 0;
				solde2 = 0;
			}

			if (!index1.equals("") && Numero1.compareTo(index1)!=0) {
				putLigneClasse1(listing, typeLivre, index1, debit1, credit1, solde1);
				debit1 = 0;
				credit1 = 0;
				solde1 = 0;
			}

			afficheCompte = edCpte.equalsIgnoreCase("T")?true:!(debitCpte-creditCpte<0.01 && debitCpte-creditCpte>-0.01);
			afficheCompte = afficheCompte && !(debitCpte<0.01 && creditCpte<0.01 && debitCpte>-0.01 && creditCpte>-0.01);

			if (afficheCompte) {

				putIntituleCompte(listing, rset.getString("Numero_Compte"), rset.getString("Intitule"));

				psOperations.setString(1, Numero);
				rset3 = psOperations.executeQuery();

				soldeInter = 0;

				while (rset3.next()) {

					creditOp = rset3.getDouble("Montant_C");
					debitOp = rset3.getDouble("Montant_D");
					soldeInter += debitOp - creditOp;

					if (soldeInter<0.01 && soldeInter>-0.01)
						soldeInter = 0;

					putLigneGrandLivre(listing, rset3.getLong("Date_Op"),rset3.getString("Code_Journal"),rset3.getString("Contrepartie"), rset3.getString("Libelle"),
					 rset3.getString("Num_Piece"), debitOp, rset3.getString("Lettre"), creditOp, soldeInter, rset3.getString("Commentaire"), rset3.getLong("Date_Echeance"));
				}
				rset3.close();


				putTotalCompte(listing, rset.getString("Numero_Compte"), debitCpte, creditCpte, soldeCpte);

				solde2 += soldeCpte;
				debit2 += debitCpte;
				credit2 += creditCpte;

				solde1 += soldeCpte;
				debit1 += debitCpte;
				credit1 += creditCpte;

				if (!Numero1.equals("0")) {
					solde += soldeCpte;
					debit += debitCpte;
					credit += creditCpte;
				}
			}

			index2 = Numero2;
			index1 = Numero1;
		}

		putLigneClasse(listing, index2, debit2, credit2, solde2);
		putLigneClasse1(listing, typeLivre, index1, debit1, credit1, solde1);

		if (typeLivre.equalsIgnoreCase("G")) {
			putTotalGeneral(listing, debit, credit, solde);
		}

		rset.close();

		psSoldesAux.close();
		psSoldesGen.close();
		psOperations.close();

		stt.close();
	}


	/** Ajoute une ligne d'operation au listing */

	private void putLigneGrandLivre(ListingFile lf, long dateOp, String codeJournal, String contrePartie, String libelle, String piece, double debit, String lettrage, double credit, double solde, String commentaire, long dateEcheance) {

		SimpleDateFormat formatDatePoint = new SimpleDateFormat("dd.MM.yy");
		
		lf.newLine();
		lf.addToLine("" + formatDatePoint.format(new Date(dateOp)));
		lf.addToLine(codeJournal);
		lf.addToLine(contrePartie +" "+ libelle);
		lf.addToLine("'" + piece);
		lf.addToLine("" + (debit==0?"":numFormat.format(debit)).replaceAll("\\.", ","));
		lf.addToLine(lettrage);
		lf.addToLine("" + (credit==0?"":numFormat.format(credit)).replaceAll("\\.", ","));
		lf.addToLine("" + (numFormat.format(solde)).replaceAll("\\.", ","));
		lf.addToLine(commentaire);
		lf.addToLine(dateEcheance!=0?"" + formatDatePoint.format(new Date(dateEcheance)):"");
	}


	/** Ajoute une ligne de total pour un journal au listing */

	private void putTotalGeneral(ListingFile lf, double debit, double credit, double solde) {

		lf.newLine();
		lf.addToLine("");
		lf.addToLine("");
		lf.addToLine("TOTAL GENERAL");
		lf.addToLine("");
		lf.addToLine(("" + numFormat.format(debit)).replaceAll("\\.", ","));
		lf.addToLine("");
		lf.addToLine(("" + numFormat.format(credit)).replaceAll("\\.", ","));
		lf.addToLine(("" + numFormat.format(solde)).replaceAll("\\.", ","));
		lf.addToLine("");
		lf.addToLine("");
	}

	private void putIntituleCompte(ListingFile lf, String numCompte, String intitule) {

		lf.newLine();
		lf.addToLine("");
		lf.addToLine("");
		lf.addToLine(numCompte + " " + intitule);
		lf.addToLine("");
		lf.addToLine("");
		lf.addToLine("");
		lf.addToLine("");
		lf.addToLine("");
		lf.addToLine("");
		lf.addToLine("");
	}


	private void putTotalCompte(ListingFile lf, String numCompte, double debit, double credit, double solde) {

		lf.newLine();
		lf.addToLine("");
		lf.addToLine("");
		lf.addToLine("Total compte "+ numCompte);
		lf.addToLine("");
		lf.addToLine(("" + numFormat.format(debit)).replaceAll("\\.", ","));
		lf.addToLine("");
		lf.addToLine(("" + numFormat.format(credit)).replaceAll("\\.", ","));
		lf.addToLine(("" + numFormat.format(solde)).replaceAll("\\.", ","));
		lf.addToLine("");
		lf.addToLine("");

	}


	private void putLigneClasse(ListingFile lf, String index, double debit, double credit, double solde) {

		if (!(debit<0.01 && credit<0.01 && debit>-0.01 && credit>-0.01)) {

			lf.newLine();
			lf.addToLine("");
			lf.addToLine("");
			lf.addToLine("Total classe " + index);
			lf.addToLine("");
			lf.addToLine(("" + numFormat.format(debit)).replaceAll("\\.", ","));
			lf.addToLine("");
			lf.addToLine(("" + numFormat.format(credit)).replaceAll("\\.", ","));
			lf.addToLine(("" + numFormat.format(solde)).replaceAll("\\.", ","));
			lf.addToLine("");
			lf.addToLine("");
		}

	}


	private void putLigneClasse1(ListingFile lf, String typeLivre, String index, double debit, double credit, double solde) {

		lf.newLine();
		lf.addToLine("");
		lf.addToLine("");

		if (typeLivre.equalsIgnoreCase("C")) {
			lf.addToLine("TOTAL CLIENTS");
		}
		else if (typeLivre.equalsIgnoreCase("F")) {
			lf.addToLine("TOTAL FOURNISSEURS");
		}
		else if (typeLivre.equalsIgnoreCase("A")) {
			lf.addToLine("TOTAL AUXILIAIRES");
		}
		else {
			lf.addToLine("Total classe " + index);
		}
		lf.addToLine("");
		lf.addToLine(("" + numFormat.format(debit)).replaceAll("\\.", ","));
		lf.addToLine("");
		lf.addToLine(("" + numFormat.format(credit)).replaceAll("\\.", ","));
		lf.addToLine(("" + numFormat.format(solde)).replaceAll("\\.", ","));
		lf.addToLine("");
		lf.addToLine("");
	}


} // fin GenCsvGrandLivre



