/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Edition de la balance.
 */


package org.opensi.compta.actions.etats;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.listing.ListingFile;
import org.opensi.util.listing.ListingTabFile;
import org.opensi.util.tools.DateTime;


public class GenCsvBalance extends Action {


private DecimalFormat numFormat = new DecimalFormat("0.00");

private long debutPeriode;
private	long finPeriode;
private boolean exocomplet;
private String base;
private String baseDossier;
private String edition;
private String cpteDebut;
private String cpteFin;
private String debutExercice;
private String finExercice;
private String edCpte;

private Connection con;


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {


		con = s.getConnection(null);

		this.base = s.getCookie().get("BaseExo");
		this.baseDossier = s.getCookie().get("BaseDossier");

		this.debutExercice = r.getParameter("Debut_Exercice");
		this.finExercice = r.getParameter("Fin_Exercice");
		String type = r.getParameter("Type");
		String periode = r.getParameter("Periode");
		String dateDebut = r.getParameter("Date_Debut");
		String dateFin = r.getParameter("Date_Fin");
		this.edition = r.getParameter("Edition");
		this.cpteDebut = r.getParameter("Cpte_Debut");
		this.cpteFin = r.getParameter("Cpte_Fin");
		this.edCpte = r.getParameter("Ed_Cpte");
		

		if (periode.equals("dd")) {
			debutPeriode = DateTime.parseDate(dateDebut, "dd/MM/yy");
			finPeriode = DateTime.parseDate(dateFin, "dd/MM/yy");
			exocomplet = false;
		}
		else {
			debutPeriode = Long.parseLong(debutExercice);
			finPeriode = Long.parseLong(finExercice);
			exocomplet = true;
		}
		
		String buffer = s.getAppConfiguration().get("opensi.absdir") + "/iobuffer/";
	
		String fichier = r.getParameter("FichierCSV");

		ListingFile lf = new ListingTabFile();

		lf.newLine();
		lf.addToLine("COMPTE");
		lf.addToLine("INTITULE");
		lf.addToLine("DEBIT");
		lf.addToLine("CREDIT");
		lf.addToLine("SOLDE");

		if (type.equalsIgnoreCase("T")) {
			putBalance(lf, "C");
			putBalance(lf, "F");
			putBalance(lf, "A");
			putBalance(lf, "G");
		}
		else {
			putBalance(lf, type);
		}
		
		lf.write(buffer, fichier, true);

		s.closeConnection(con, null);


		return true;


	} // fin service


	private void putBalance(ListingFile lf, String typeBalance) throws SQLException, Exception {

		boolean resultat = false;
		boolean bilan = false;
		boolean afficheCompte;

		String Numero;
		String Numero2;
		String Numero1;
		String index2 = "";
		String index1 = "";

		double solde2 = 0;
		double debit2 = 0;
		double credit2 = 0;

		double solde1 = 0;
		double debit1 = 0;
		double credit1 = 0;

		double solde = 0;
		double debit = 0;
		double credit = 0;

		double soldeCpte = 0;
		double debitCpte = 0;
		double creditCpte = 0;

		double creditResultat = 0;
		double debitResultat = 0;
		double creditBilan = 0;
		double debitBilan = 0;


		ResultSet rset; // comptes
		ResultSet rset2; // soldes des comptes

		Statement stt = con.createStatement();


		String reqSoldesGen = "select sum(Montant_D) as Debit, sum(Montant_C) as Credit from "+ base +".OPERATION where Numero_Compte=?";
		String reqSoldesAux = "select sum(Montant_D) as Debit, sum(Montant_C) as Credit from "+ base +".OPERATION o,"+ baseDossier +".COMPTE c where c.Collectif=? and o.Numero_Compte=c.Numero_Compte";

		if (!exocomplet) {
			String suiteReq = (Long.parseLong(debutExercice)==debutPeriode
												?" and Date_Op<="+ finPeriode
												:" and Date_Op<="+ finPeriode +" and Date_Op>="+ debutPeriode);

			reqSoldesGen += suiteReq;
			reqSoldesAux += suiteReq;
		}

		PreparedStatement psSoldesGen = con.prepareStatement(reqSoldesGen);
		PreparedStatement psSoldesAux = con.prepareStatement(reqSoldesAux);


		String reqComptes = "select Numero_Compte, Intitule, Centralisateur from "+ baseDossier +".COMPTE where Type_Compte='"+ typeBalance +"'";

		if (edition.equals("P")) {
			reqComptes += " and Numero_Compte<='"+ cpteFin +"' and Numero_Compte>='"+ cpteDebut +"'";
		}

		reqComptes += " order by Numero_Compte";
		rset = stt.executeQuery(reqComptes);

		while (rset.next()) {

			Numero = rset.getString("Numero_Compte");
			Numero2 = Numero.substring(0,2);
			Numero1 = Numero.substring(0,1);


			if (rset.getInt("Centralisateur")==1)
				{ psSoldesAux.setString(1, Numero); rset2 = psSoldesAux.executeQuery(); }
			else
				{	psSoldesGen.setString(1, Numero);	rset2 = psSoldesGen.executeQuery(); }


			while (rset2.next()) {

				debitCpte = rset2.getDouble("Debit");
				creditCpte = rset2.getDouble("Credit");
				soldeCpte = debitCpte - creditCpte;
			}
			rset2.close();


			if (!index2.equals("") && Numero2.compareTo(index2)!=0) {

				putLigneClasse(lf, index2, debit2, credit2, solde2);
				debit2 = 0;
				credit2 = 0;
				solde2 = 0;

			}

			if (!index1.equals("") && Numero1.compareTo(index1)!=0) {

				putLigneClasse1(lf, typeBalance, index1, debit1, credit1, solde1);
				debit1 = 0;
				credit1 = 0;
				solde1 = 0;

				if (!bilan && (Numero1.compareTo("5")==1 || Numero1.compareTo("6")==1 || Numero1.compareTo("7")==1)) {
					putTotalBilan(lf, debitBilan, creditBilan, debitBilan-creditBilan);
					bilan = true;
					resultat = true;
				}

			}

			afficheCompte = edCpte.equalsIgnoreCase("T")?true:!(debitCpte-creditCpte<0.01 && debitCpte-creditCpte>-0.01);

			afficheCompte = afficheCompte && !(debitCpte<0.01 && creditCpte<0.01 && debitCpte>-0.01 && creditCpte>-0.01);

			if (!edition.equalsIgnoreCase("T") && afficheCompte) {
				putLigneCompte(lf, rset.getString("Numero_Compte"), rset.getString("Intitule"), debitCpte, creditCpte, soldeCpte);
			}

			if (afficheCompte) {
				solde2 += soldeCpte;
				debit2 += debitCpte;
				credit2 += creditCpte;

				solde1 += soldeCpte;
				debit1 += debitCpte;
				credit1 += creditCpte;

				if (!bilan && !Numero1.equals("0")) {
					debitBilan += debitCpte;
					creditBilan += creditCpte;
					solde += soldeCpte;
					debit += debitCpte;
					credit += creditCpte;
				}

				if (resultat) {
					debitResultat += debitCpte;
					creditResultat += creditCpte;
					solde += soldeCpte;
					debit += debitCpte;
					credit += creditCpte;
				}
			}

			index2 = Numero2;
			index1 = Numero1;
			
		}

		putLigneClasse(lf, index2, debit2, credit2, solde2);
		putLigneClasse1(lf, typeBalance, index1, debit1, credit1, solde1);
		
		if (resultat) {
			putTotalResultat(lf, debitResultat, creditResultat, debitResultat-creditResultat);
		}

		if (typeBalance.equalsIgnoreCase("G")) {
			
			putTotalGeneral(lf, debit, credit, solde);
		}

		rset.close();

		psSoldesAux.close();
		psSoldesGen.close();
		stt.close();
	}


	private void putLigneCompte(ListingFile lf, String numCompte, String libelle, double debit, double credit, double solde) {

		lf.newLine();
		lf.addToLine(numCompte);
		lf.addToLine(libelle);
		lf.addToLine("" + (debit==0?"":numFormat.format(debit)).replaceAll("\\.", ","));
		lf.addToLine("" + (credit==0?"":numFormat.format(credit)).replaceAll("\\.", ","));
		lf.addToLine("" + (solde==0?"":numFormat.format(solde)).replaceAll("\\.", ","));

	}


	private void putTotalGeneral(ListingFile lf, double debit, double credit, double solde) {

		lf.newLine();
		lf.addToLine("");
		lf.addToLine("TOTAL GENERAL");
		lf.addToLine("" + (debit==0?"":numFormat.format(debit)).replaceAll("\\.", ","));
		lf.addToLine("" + (credit==0?"":numFormat.format(credit)).replaceAll("\\.", ","));
		lf.addToLine("" + (solde==0?"":numFormat.format(solde)).replaceAll("\\.", ","));
	
	}

	private void putLigneClasse(ListingFile lf, String index, double debit, double credit, double solde) {

		if (!(debit<0.01 && credit<0.01 && debit>-0.01 && credit>-0.01)) {

			lf.newLine();
			lf.addToLine("");
			lf.addToLine("Total classe "+ index);
			lf.addToLine("" + (debit==0?"":numFormat.format(debit)).replaceAll("\\.", ","));
			lf.addToLine("" + (credit==0?"":numFormat.format(credit)).replaceAll("\\.", ","));
			lf.addToLine("" + (solde==0?"":numFormat.format(solde)).replaceAll("\\.", ","));
		}
	}

	private void putLigneClasse1(ListingFile lf, String typeBalance, String index, double debit, double credit, double solde) {

		lf.newLine();
		lf.addToLine("");

		if (typeBalance.equalsIgnoreCase("C")) {
			lf.addToLine("TOTAL CLIENTS");
		}
		else if (typeBalance.equalsIgnoreCase("F")) {
			lf.addToLine("TOTAL FOURNISSEURS");
		}
		else if (typeBalance.equalsIgnoreCase("A")) {
			lf.addToLine("TOTAL AUXILIAIRES");
		}
		else {
			lf.addToLine("Total classe "+ index);
		}
		
		lf.addToLine("" + (debit==0?"":numFormat.format(debit)).replaceAll("\\.", ","));
		lf.addToLine("" + (credit==0?"":numFormat.format(credit)).replaceAll("\\.", ","));
		lf.addToLine("" + (solde==0?"":numFormat.format(solde)).replaceAll("\\.", ","));
	}

	private void putTotalResultat(ListingFile lf, double debit, double credit, double solde) {

		lf.newLine();
		lf.addToLine("");
		lf.addToLine("Total Comptes de R\u00E9sultat");
		lf.addToLine("" + (debit==0?"":numFormat.format(debit)).replaceAll("\\.", ","));
		lf.addToLine("" + (credit==0?"":numFormat.format(credit)).replaceAll("\\.", ","));
		lf.addToLine("" + (solde==0?"":numFormat.format(solde)).replaceAll("\\.", ","));

	}

	private void putTotalBilan(ListingFile lf, double debit, double credit, double solde) {

		lf.newLine();
		lf.addToLine("");
		lf.addToLine("Total Comptes de Bilan");
		lf.addToLine("" + (debit==0?"":numFormat.format(debit)).replaceAll("\\.", ","));
		lf.addToLine("" + (credit==0?"":numFormat.format(credit)).replaceAll("\\.", ","));
		lf.addToLine("" + (solde==0?"":numFormat.format(solde)).replaceAll("\\.", ","));

	}

} // fin GenCsvBalance
