/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'un avoir standard
 */

package org.opensi.compta.actions.etats;


import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;


public class DataPlanComptableGeneral {


	private DecimalFormatSymbols dfs2 = new DecimalFormatSymbols();
	
	private DecimalFormat numFormatQte = new DecimalFormat("0.##");
	
	protected ArrayList<LignePlanGeneral> lignes = new ArrayList<LignePlanGeneral>(10);
	


	// coordonnes socit mettrice

	protected String raisonSociale;
	protected String adresse;	
	protected String codePostal;
	protected String ville;
	protected String tel;
	protected String fax;
	protected String email;
	
	protected int numClasse;
	protected int codePlan;
	protected String libClasse;
	protected int Niveau;
	protected int code;


	
	public DataPlanComptableGeneral(Session s) {
		try {
		
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			
			String baseDossier = s.getCookie().get("BaseDossier");
			
			
			dfs2.setDecimalSeparator('.');
			numFormatQte.setDecimalFormatSymbols(dfs2);
			
			// Paramtres dossier
      
			String reqCom = "select * from "+ baseDossier +".SOCIETE";
			
			ResultSet rset = stt.executeQuery(reqCom);
						
			if (rset.next()) {
				
				this.raisonSociale = rset.getString("Denomination");
				this.adresse = rset.getString("Adresse_1");				
				this.codePostal = rset.getString("Code_Postal");
				this.ville = rset.getString("Ville");
				this.tel = rset.getString("Telephone");
				this.fax = rset.getString("Fax");
				this.email = rset.getString("Email");			
			}		
		
			// selection des lignes du plan comptable gnral
			ResultSet rset2;
			Statement stt2 = con.createStatement();
			String reqPlan = "select * from CLASSE_PLAN_COMPTABLE where Code_Plan=1 order by Code";
			rset2 = stt2.executeQuery(reqPlan);
			
			while(rset2.next()) {	
				LignePlanGeneral lp=new LignePlanGeneral();	
				lp.codePlan =rset2.getInt("Code_Plan");
				lp.numClasse = rset2.getInt("Numero_Classe");
				lp.libClasse = rset2.getString("Libelle_Classe");				
				lp.niveau = rset2.getInt("Niveau");
				lp.code =rset2.getInt("Code");
				lignes.add(lp);
			}
			rset.close();
			stt.close();			
			s.closeConnection(con, null);
			
		} catch(Exception e) {
			e.printStackTrace();
		}	
	}
	
	
	public int getNbLignes() {
		return lignes.size();
	}	
	
} 
