/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un tat des stocks en csv
 */

package org.opensi.compta.actions.etats;

import org.opensi.util.listing.ListingFile;
import org.opensi.util.listing.ListingTabFile;


public class CsvRechEcriture {

	private DataRechEcriture data;	   // 

	public CsvRechEcriture(String buffer, String fichier, DataRechEcriture lignedata) throws Exception {

		this.data = lignedata;

		ListingFile lf = new ListingTabFile();

		lf.newLine();
		lf.addToLine("Date");
		lf.addToLine("CJ");
		lf.addToLine("Compte");
		lf.addToLine("Commentaire");
		lf.addToLine("Libelle");
		lf.addToLine("Echeance");
		lf.addToLine("Debit");
		lf.addToLine("Lettre");
		lf.addToLine("Credit");
		lf.addToLine("Num Piece");	
		

		int nbLignes = data.getNbLignes();

		for (int i=0; i<nbLignes; i++) {
			LigneEcriture le = data.lignes.get(i);

			lf.newLine();
			lf.addToLine("" + le.date);
			lf.addToLine("" + le.codejournal);
			lf.addToLine(("" + le.Numero_Compte));
			lf.addToLine(("" + le.commentaire));
			lf.addToLine(("" + le.libelle));
			lf.addToLine(("" + le.echeance));
			lf.addToLine(("" + le.debit).replaceAll("\\.", ","));
			lf.addToLine(("" + le.lettrage));
			lf.addToLine(("" + le.credit).replaceAll("\\.", ","));
			lf.addToLine(("" + le.numpiece));
			
		}

		lf.write(buffer, fichier, true);
	}



} // fin CsvRechEcriture 
