/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.api;

import java.util.Hashtable;

import org.opensi.util.tools.DateTime;


public class Parameters {

	
	private Hashtable<String, String> htParams;

	
	public Parameters(Hashtable<String, String> htParams) {
		
		this.htParams = htParams;
	}
	

	public String getParameter(String parameterName) {
	
		return htParams.get(parameterName);
	}
	
	
	public String getNullParameter(String parameterName) {
	
		String value = htParams.get(parameterName);
	
		return value.isEmpty()?null:value;
	}


	public long getLongParameter(String parameterName) {
	
		return Long.parseLong(htParams.get(parameterName));
	}
	
	
	public int getIntParameter(String parameterName) {
	
		return Integer.parseInt(htParams.get(parameterName));
	}
		
	
	public boolean getBooleanParameter(String parameterName) {
		
		return Boolean.parseBoolean(htParams.get(parameterName));
	}
	
	
	public long getDateParameter(String parameterName) {
	
		return DateTime.parseDate(htParams.get(parameterName), "dd/MM/yyyy");
	}
	
	
	public long getPeriodeParameter(String parameterName) {
	
		return DateTime.parseDate(htParams.get(parameterName), "MMyy");
	}


	public double getDoubleParameter(String parameterName) {
	
		return Double.parseDouble(htParams.get(parameterName));
	}

	

} // fin Parameters
