/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.api;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;


public class LeevElement {

	
	// nom de l'lment
	private String name;
	
	// liste des lments contenus dans l'lment
	private ArrayList<LeevElement> elements = new ArrayList<LeevElement>();
	
	// liste des entits de l'lment
	private HashMap<String,String> entities = new HashMap<String,String>();
	
	
	private Iterator<String> itEntities;
	private String currentEntity;	
	private int itElements = -1;

	
	public LeevElement(String name) {
		
		this.name = name;
	}
	
	
	public String getName() {
	
		return this.name;
	}
	
	
	public void addElement(LeevElement le) {
		
		elements.add(le);
	}
	
	public boolean nextElement() {
		
		itElements++;
		
		return itElements<elements.size();
	}
	
	public LeevElement getElement() {
		try {
			return elements.get(itElements);
		}
		catch(IndexOutOfBoundsException e) {
			return null;
		}
	}	
	
	public void addEntity(String entityName, String entityValue) {
	
		entities.put(entityName, entityValue);
	}
	
	
	public void addEntity(String entityName, int entityValue) {
	
		entities.put(entityName, String.valueOf(entityValue));
	}
	
	
	public void addEntity(String entityName, double entityValue) {
	
		entities.put(entityName, String.valueOf(entityValue));
	}
	
	
	public void addEntity(String entityName, boolean entityValue) {
	
		entities.put(entityName, String.valueOf(entityValue));
	}
	

	public boolean nextEntity() {
	
		if (itEntities==null) {
			itEntities = entities.keySet().iterator();
		}
	
		if (itEntities.hasNext()) {
			this.currentEntity = itEntities.next();
			return true;
		}
		else {
			this.currentEntity = null;
			return false;
		}
	}
	
	
	public String getEntityName() {
		return this.currentEntity;
	}
	
	
	public String getEntityValue() {
		return entities.get(this.currentEntity);
	}
	
	
	public int nbElements() {
		return elements.size();
	}

} // fin LeevElement
