/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.actions.exercice;


import java.sql.*;

import org.opensi.api.*;

import org.opensi.util.tools.DateTime;


public class GetPeriodeEnCours implements ActionOSI {
	
	
	public void processAction(SessionOSI sosi, Parameters param, LeevElement result, ActionError error) throws Exception {
	
		Connection con = sosi.getConnection();
		String baseExo = sosi.getBaseExo();
		String baseDossier = sosi.getBaseDossier();
		
		DateTime dt = new DateTime(System.currentTimeMillis());
		dt.setDay(1);
		long dateMoisCourant = dt.getDateInMillis();
		
		int exerciceId = sosi.getExerciceId();
		int periodeId = 0;
		String datePeriode = "";
		boolean derniere = false;
		
		String reqPeriode = "select pe.Periode_Id, pe.Periode from "+ baseDossier +".EXERCICE e, "+ baseExo +".PERIODE_EXERCICE pe";
		reqPeriode += " where pe.Periode>=e.Debut_Exercice and pe.Periode<=e.Fin_Exercice and pe.Cloture=0";
		reqPeriode += " and e.Exercice_Id=? and pe.Periode<? order by pe.Periode";
		PreparedStatement psPeriode = con.prepareStatement(reqPeriode);
		psPeriode.setInt(1, exerciceId);
		psPeriode.setLong(2, dateMoisCourant);
		ResultSet rset = psPeriode.executeQuery();
		if (rset.next()) {
			periodeId = rset.getInt("Periode_Id");
			datePeriode = DateTime.formatTime(rset.getLong("Periode"), "MMMM yyyy");
		}
		rset.close();
		psPeriode.close();
		
		String reqNbPeriode = "select count(*) as nb from "+ baseDossier +".EXERCICE e, "+ baseExo +".PERIODE_EXERCICE pe";
		reqNbPeriode += " where pe.Periode>=e.Debut_Exercice and pe.Periode<=e.Fin_Exercice and pe.Cloture=0";
		reqNbPeriode += " and e.Exercice_Id=?";
		PreparedStatement psNbPeriode = con.prepareStatement(reqNbPeriode);
		psNbPeriode.setInt(1, exerciceId);
		rset = psNbPeriode.executeQuery();
		rset.next();
		derniere = (rset.getInt("nb")==1);
		rset.close();
		psNbPeriode.close();
		
		result.addEntity("Periode_Id", periodeId);
		result.addEntity("Periode", datePeriode);
		result.addEntity("Dernier", derniere?"1":"0");
	}


} // fin GetPeriodeEnCours

