/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.actions.ecritures;


import java.sql.*;

import org.opensi.api.*;

import org.opensi.util.tools.DateTime;


public class GetLocationEcriture implements ActionOSI {
	
	
	public void processAction(SessionOSI sosi, Parameters param, LeevElement result, ActionError error) throws Exception {
	
		Connection con = sosi.getConnection();
		String baseExo = sosi.getBaseExo();
		
		int opId = param.getIntParameter("Op_Id");
		int nbEcrPage = param.getIntParameter("Nb_Ecr_Page");
		
		PreparedStatement psEcr = con.prepareStatement("select e.Code_Journal, e.Ecriture_Id, e.Date_Ecriture from "+ baseExo +".ECRITURE e join "+ baseExo +".OPERATION o on o.Ecriture_Id=e.Ecriture_Id where o.Op_Id=?");
		
		psEcr.setInt(1, opId);
		ResultSet rsE = psEcr.executeQuery();
		
		if (rsE.next()) {
			result.addEntity("Code_Journal", rsE.getString("Code_Journal"));
			result.addEntity("Periode", DateTime.formatTime(rsE.getLong("Date_Ecriture"), "MMyy"));
			
			PreparedStatement psNumEcr = con.prepareStatement("select count(Ecriture_Id) from "+ baseExo +".ECRITURE where Code_Journal=? and Date_Ecriture=? and Ecriture_Id<?");
			
			psNumEcr.setString(1, rsE.getString("Code_Journal"));
			psNumEcr.setLong(2, rsE.getLong("Date_Ecriture"));
			psNumEcr.setInt(3, rsE.getInt("Ecriture_Id"));
			ResultSet rsNE = psNumEcr.executeQuery();
			
			rsNE.next();
			
			result.addEntity("Page", rsNE.getInt(1)/nbEcrPage+1);
			
			psNumEcr.close();
		}
		
		psEcr.close();
	}
	

} // fin GetLocationEcriture

