/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.xml;

import com.lowagie.text.Anchor;
import com.lowagie.text.Annotation;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.Chapter;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocListener;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Entities;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.Graphic;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Meta;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Row;
import com.lowagie.text.Section;
import com.lowagie.text.Table;
import com.lowagie.text.TextElementArray;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SAXiTextHandler
extends DefaultHandler {
    protected DocListener document;
    protected Stack stack;
    protected int chapters = 0;
    protected Chunk currentChunk = null;
    protected boolean ignore = false;
    protected boolean controlOpenClose = true;

    public SAXiTextHandler(DocListener docListener) {
        this.document = docListener;
        this.stack = new Stack();
    }

    public void setControlOpenClose(boolean bl) {
        this.controlOpenClose = bl;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        Properties properties = new Properties();
        if (attributes != null) {
            int n = 0;
            while (n < attributes.getLength()) {
                String string4 = attributes.getQName(n);
                properties.setProperty(string4, attributes.getValue(n));
                ++n;
            }
        }
        this.handleStartingTags(string3, properties);
    }

    public void handleStartingTags(String string, Properties properties) {
        Object object;
        if (this.ignore || "ignore".equals(string)) {
            this.ignore = true;
            return;
        }
        if (this.currentChunk != null) {
            try {
                object = (TextElementArray)this.stack.pop();
            }
            catch (EmptyStackException emptyStackException) {
                object = new Paragraph();
            }
            object.add((Object)this.currentChunk);
            this.stack.push(object);
            this.currentChunk = null;
        }
        if (Chunk.isTag((String)string)) {
            this.currentChunk = new Chunk(properties);
            return;
        }
        if (Entities.isTag((String)string)) {
            object = new Font();
            if (this.currentChunk != null) {
                this.handleEndingTags("chunk");
                object = this.currentChunk.font();
            }
            this.currentChunk = Entities.get((String)properties.getProperty("id"), (Font)object);
            return;
        }
        if (Phrase.isTag((String)string)) {
            this.stack.push(new Phrase(properties));
            return;
        }
        if (Anchor.isTag((String)string)) {
            this.stack.push(new Anchor(properties));
            return;
        }
        if (Paragraph.isTag((String)string) || Section.isTitle((String)string)) {
            this.stack.push(new Paragraph(properties));
            return;
        }
        if (List.isTag((String)string)) {
            this.stack.push(new List(properties));
            return;
        }
        if (ListItem.isTag((String)string)) {
            this.stack.push(new ListItem(properties));
            return;
        }
        if (Cell.isTag((String)string)) {
            this.stack.push(new Cell(properties));
            return;
        }
        if (Table.isTag((String)string)) {
            object = new Table(properties);
            float[] fArray = object.getProportionalWidths();
            int n = 0;
            while (n < fArray.length) {
                if (fArray[n] == 0.0f) {
                    fArray[n] = 100.0f / (float)fArray.length;
                }
                ++n;
            }
            try {
                object.setWidths(fArray);
            }
            catch (BadElementException badElementException) {
                throw new ExceptionConverter((Exception)((Object)badElementException));
            }
            this.stack.push(object);
            return;
        }
        if (Section.isTag((String)string)) {
            Section section;
            object = (Element)this.stack.pop();
            try {
                section = ((Section)object).addSection(properties);
            }
            catch (ClassCastException classCastException) {
                throw new ExceptionConverter((Exception)classCastException);
            }
            this.stack.push(object);
            this.stack.push(section);
            return;
        }
        if (Chapter.isTag((String)string)) {
            object = (String)((Hashtable)properties).remove("number");
            this.chapters = object != null ? Integer.parseInt((String)object) : ++this.chapters;
            Chapter chapter = new Chapter(properties, this.chapters);
            this.stack.push(chapter);
            return;
        }
        if (Image.isTag((String)string)) {
            try {
                object = Image.getInstance((Properties)properties);
                try {
                    Object e = this.stack.pop();
                    if (e instanceof Chapter || e instanceof Section || e instanceof Cell) {
                        ((TextElementArray)e).add(object);
                        this.stack.push(e);
                        return;
                    }
                    Stack stack = new Stack();
                    try {
                        while (!(e instanceof Chapter || e instanceof Section || e instanceof Cell)) {
                            stack.push(e);
                            if (e instanceof Anchor) {
                                object.setAnnotation(new Annotation(0.0f, 0.0f, 0.0f, 0.0f, ((Anchor)e).reference()));
                            }
                            e = this.stack.pop();
                        }
                        ((TextElementArray)e).add(object);
                        this.stack.push(e);
                    }
                    catch (EmptyStackException emptyStackException) {
                        this.document.add((Element)object);
                    }
                    while (!stack.empty()) {
                        this.stack.push(stack.pop());
                    }
                    return;
                }
                catch (EmptyStackException emptyStackException) {
                    try {
                        this.document.add((Element)object);
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter((Exception)((Object)documentException));
                    }
                    return;
                }
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        }
        if (Annotation.isTag((String)string)) {
            object = new Annotation(properties);
            try {
                try {
                    TextElementArray textElementArray = (TextElementArray)this.stack.pop();
                    try {
                        textElementArray.add(object);
                    }
                    catch (Exception exception) {
                        this.document.add((Element)object);
                    }
                    this.stack.push(textElementArray);
                }
                catch (EmptyStackException emptyStackException) {
                    this.document.add((Element)object);
                }
                return;
            }
            catch (DocumentException documentException) {
                throw new ExceptionConverter((Exception)((Object)documentException));
            }
        }
        if (this.isNewline(string)) {
            try {
                object = (TextElementArray)this.stack.pop();
                object.add((Object)Chunk.NEWLINE);
                this.stack.push(object);
            }
            catch (EmptyStackException emptyStackException) {
                if (this.currentChunk == null) {
                    try {
                        this.document.add((Element)Chunk.NEWLINE);
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter((Exception)((Object)documentException));
                    }
                }
                this.currentChunk.append("\n");
            }
            return;
        }
        if (this.isNewpage(string)) {
            try {
                object = (TextElementArray)this.stack.pop();
                Chunk chunk = new Chunk("");
                chunk.setNewPage();
                object.add((Object)chunk);
                this.stack.push(object);
            }
            catch (EmptyStackException emptyStackException) {
                try {
                    this.document.newPage();
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter((Exception)((Object)documentException));
                }
            }
            return;
        }
        if ("horizontalrule".equals(string)) {
            Graphic graphic = new Graphic();
            graphic.setHorizontalLine(1.0f, 100.0f);
            try {
                object = (TextElementArray)this.stack.pop();
                object.add((Object)graphic);
                this.stack.push(object);
            }
            catch (EmptyStackException emptyStackException) {
                try {
                    this.document.add((Element)graphic);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter((Exception)((Object)documentException));
                }
            }
            return;
        }
        if (this.isDocumentRoot(string)) {
            Iterator iterator = ((Hashtable)properties).keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                String string2 = properties.getProperty((String)object);
                try {
                    this.document.add((Element)new Meta((String)object, string2));
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter((Exception)((Object)documentException));
                }
            }
            if (this.controlOpenClose) {
                this.document.open();
            }
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.ignore) {
            return;
        }
        String string = new String(cArray, n, n2);
        if (string.trim().length() == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = string.length();
        boolean bl = false;
        int n4 = 0;
        while (n4 < n3) {
            char c = string.charAt(n4);
            switch (c) {
                case ' ': {
                    if (bl) break;
                    stringBuffer.append(c);
                    break;
                }
                case '\n': {
                    if (n4 <= 0) break;
                    bl = true;
                    stringBuffer.append(' ');
                    break;
                }
                case '\r': {
                    break;
                }
                case '\t': {
                    break;
                }
                default: {
                    bl = false;
                    stringBuffer.append(c);
                }
            }
            ++n4;
        }
        if (this.currentChunk == null) {
            this.currentChunk = new Chunk(stringBuffer.toString());
        } else {
            this.currentChunk.append(stringBuffer.toString());
        }
    }

    public void endElement(String string, String string2, String string3) {
        this.handleEndingTags(string3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleEndingTags(String string) {
        if ("ignore".equals(string)) {
            this.ignore = false;
            return;
        }
        if (this.ignore) {
            return;
        }
        if (this.isNewpage(string)) return;
        if (Annotation.isTag((String)string)) return;
        if (Image.isTag((String)string)) return;
        if (this.isNewline(string)) {
            return;
        }
        try {
            Object object;
            block44: {
                Cell cell;
                Object object2;
                List list;
                if (Section.isTitle((String)string)) {
                    Paragraph paragraph = (Paragraph)this.stack.pop();
                    if (this.currentChunk != null) {
                        paragraph.add((Object)this.currentChunk);
                        this.currentChunk = null;
                    }
                    Section section = (Section)this.stack.pop();
                    section.setTitle(paragraph);
                    this.stack.push(section);
                    return;
                }
                if (this.currentChunk != null) {
                    try {
                        object = (TextElementArray)this.stack.pop();
                    }
                    catch (EmptyStackException emptyStackException) {
                        object = new Paragraph();
                    }
                    object.add((Object)this.currentChunk);
                    this.stack.push(object);
                    this.currentChunk = null;
                }
                if (Chunk.isTag((String)string)) {
                    return;
                }
                if (Phrase.isTag((String)string) || Anchor.isTag((String)string) || List.isTag((String)string) || Paragraph.isTag((String)string)) {
                    object = (Element)this.stack.pop();
                    try {
                        TextElementArray textElementArray = (TextElementArray)this.stack.pop();
                        textElementArray.add(object);
                        this.stack.push(textElementArray);
                        return;
                    }
                    catch (EmptyStackException emptyStackException) {
                        this.document.add((Element)object);
                    }
                    return;
                }
                if (ListItem.isTag((String)string)) {
                    object = (ListItem)this.stack.pop();
                    list = (List)this.stack.pop();
                    list.add(object);
                    this.stack.push(list);
                }
                if (Table.isTag((String)string)) {
                    object = (Table)this.stack.pop();
                    try {
                        list = (TextElementArray)this.stack.pop();
                        list.add(object);
                        this.stack.push(list);
                        return;
                    }
                    catch (EmptyStackException emptyStackException) {
                        this.document.add((Element)object);
                    }
                    return;
                }
                if (!Row.isTag((String)string)) break block44;
                object = new ArrayList();
                int n = 0;
                while ((object2 = (Element)this.stack.pop()).type() == 20) {
                    cell = (Cell)object2;
                    n += cell.colspan();
                    ((ArrayList)object).add(cell);
                }
                Table table = (Table)object2;
                if (table.columns() < n) {
                    table.addColumns(n - table.columns());
                }
                Collections.reverse(object);
                float[] fArray = new float[n];
                boolean[] blArray = new boolean[n];
                int n2 = 0;
                while (n2 < n) {
                    fArray[n2] = 0.0f;
                    blArray[n2] = true;
                    ++n2;
                }
                float f = 0.0f;
                int n3 = 0;
                Iterator iterator = ((AbstractList)object).iterator();
                while (iterator.hasNext()) {
                    block46: {
                        block45: {
                            cell = (Cell)iterator.next();
                            object2 = cell.cellWidth();
                            if (object2 != null) break block45;
                            if (cell.colspan() == 1 && fArray[n3] == 0.0f) {
                                try {
                                    fArray[n3] = 100.0f / (float)n;
                                    f += fArray[n3];
                                }
                                catch (Exception exception) {}
                                break block46;
                            } else if (cell.colspan() == 1) {
                                blArray[n3] = false;
                            }
                            break block46;
                        }
                        if (cell.colspan() == 1 && ((String)object2).endsWith("%")) {
                            try {
                                fArray[n3] = Float.valueOf(((String)object2).substring(0, ((String)object2).length() - 1) + "f").floatValue();
                                f += fArray[n3];
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    n3 += cell.colspan();
                    table.addCell(cell);
                }
                float[] fArray2 = table.getProportionalWidths();
                if (fArray2.length == n) {
                    float f2 = 0.0f;
                    int n4 = 0;
                    while (n4 < n) {
                        if (blArray[n4] && fArray2[n4] != 0.0f) {
                            f2 += fArray2[n4];
                            fArray[n4] = fArray2[n4];
                        }
                        ++n4;
                    }
                    if (100.0 >= (double)f) {
                        int n5 = 0;
                        while (n5 < fArray2.length) {
                            if (fArray[n5] == 0.0f && fArray2[n5] != 0.0f) {
                                fArray[n5] = fArray2[n5] / f2 * (100.0f - f);
                            }
                            ++n5;
                        }
                    }
                    table.setWidths(fArray);
                }
                this.stack.push(table);
            }
            if (Cell.isTag((String)string)) {
                return;
            }
            if (Section.isTag((String)string)) {
                this.stack.pop();
                return;
            }
            if (Chapter.isTag((String)string)) {
                this.document.add((Element)this.stack.pop());
                return;
            }
            if (!this.isDocumentRoot(string)) return;
            try {
                while (true) {
                    object = (Element)this.stack.pop();
                    try {
                        TextElementArray textElementArray = (TextElementArray)this.stack.pop();
                        textElementArray.add(object);
                        this.stack.push(textElementArray);
                    }
                    catch (EmptyStackException emptyStackException) {
                        this.document.add((Element)object);
                    }
                }
            }
            catch (EmptyStackException emptyStackException) {
                if (!this.controlOpenClose) return;
                this.document.close();
                return;
            }
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter((Exception)((Object)documentException));
        }
    }

    private boolean isNewpage(String string) {
        return "newpage".equals(string);
    }

    private boolean isNewline(String string) {
        return "newline".equals(string);
    }

    protected boolean isDocumentRoot(String string) {
        return "itext".equals(string);
    }
}

