/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.util;

import java.util.StringTokenizer;

public class StringUtils {
    public static String normalizeUrl(String in) {
        if (in == null) {
            return "";
        }
        String arg = in.trim();
        StringBuffer sbuff = new StringBuffer();
        char prevC = '\uffff';
        for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            if (Character.isWhitespace(c)) {
                if (!Character.isWhitespace(prevC) && sbuff.charAt(sbuff.length() - 1) != '-') {
                    sbuff.append('-');
                }
            } else {
                switch (c) {
                    case '\u00e0': 
                    case '\u00e1': 
                    case '\u00e2': 
                    case '\u00e3': 
                    case '\u00e4': 
                    case '\u00e5': 
                    case '\u00e6': {
                        sbuff.append('a');
                        break;
                    }
                    case '\u00c0': 
                    case '\u00c1': 
                    case '\u00c2': 
                    case '\u00c3': 
                    case '\u00c4': 
                    case '\u00c5': 
                    case '\u00c6': {
                        sbuff.append('A');
                        break;
                    }
                    case '\u00e8': 
                    case '\u00e9': 
                    case '\u00ea': 
                    case '\u00eb': {
                        sbuff.append('e');
                        break;
                    }
                    case '\u00c8': 
                    case '\u00c9': 
                    case '\u00ca': 
                    case '\u00cb': {
                        sbuff.append('E');
                        break;
                    }
                    case '\u00ec': 
                    case '\u00ed': 
                    case '\u00ee': 
                    case '\u00ef': {
                        sbuff.append('i');
                        break;
                    }
                    case '\u00cc': 
                    case '\u00cd': 
                    case '\u00ce': 
                    case '\u00cf': {
                        sbuff.append('I');
                        break;
                    }
                    case '\u00f0': 
                    case '\u00f2': 
                    case '\u00f3': 
                    case '\u00f4': 
                    case '\u00f5': 
                    case '\u00f6': 
                    case '\u00f8': {
                        sbuff.append('o');
                        break;
                    }
                    case '\u00d2': 
                    case '\u00d3': 
                    case '\u00d4': 
                    case '\u00d5': 
                    case '\u00d6': 
                    case '\u00d8': {
                        sbuff.append('O');
                        break;
                    }
                    case '\u00b5': 
                    case '\u00f9': 
                    case '\u00fa': 
                    case '\u00fb': 
                    case '\u00fc': {
                        sbuff.append('u');
                        break;
                    }
                    case '\u00d9': 
                    case '\u00da': 
                    case '\u00db': 
                    case '\u00dc': {
                        sbuff.append('U');
                        break;
                    }
                    case '\u00fd': 
                    case '\u00ff': {
                        sbuff.append('y');
                        break;
                    }
                    case '\u00a5': 
                    case '\u00dd': {
                        sbuff.append('Y');
                        break;
                    }
                    case '\u00e7': {
                        sbuff.append('c');
                        break;
                    }
                    case '\u00c7': {
                        sbuff.append('C');
                        break;
                    }
                    case '\u00d0': {
                        sbuff.append('D');
                        break;
                    }
                    case '\u00f1': {
                        sbuff.append('n');
                        break;
                    }
                    case '\u00d1': {
                        sbuff.append('N');
                        break;
                    }
                    case '\u00df': {
                        sbuff.append('s');
                        break;
                    }
                    case '_': {
                        sbuff.append('-');
                        break;
                    }
                    default: {
                        if (!Character.isLetterOrDigit(c)) break;
                        sbuff.append(c);
                    }
                }
            }
            prevC = c;
        }
        return sbuff.toString();
    }

    public static String quoteMessage(String in) {
        return StringUtils.encodeWithRules("> " + in, "\n=\n> ;", ";");
    }

    public static String removeHtmlTags(String in) {
        if (in.indexOf(60) < 0) {
            return in;
        }
        if (in.indexOf(62) < 0) {
            return in;
        }
        String s = in;
        boolean startsWithLt = in.startsWith("<");
        StringTokenizer st = new StringTokenizer(s, "<");
        StringBuffer b = startsWithLt ? new StringBuffer() : new StringBuffer(st.nextToken());
        while (st.hasMoreTokens()) {
            String tk = st.nextToken();
            int pos = tk.indexOf(62);
            if (pos < 0) {
                b.append(" " + tk);
                continue;
            }
            b.append(" " + tk.substring(pos + 1));
        }
        return b.toString();
    }

    public static String encodeWithRules(String s, String rules, String sep) {
        if (rules == null || s == null) {
            return s;
        }
        if (sep == null) {
            sep = ";";
        }
        StringTokenizer st = new StringTokenizer(rules, sep);
        String ret = new String(s);
        while (st.hasMoreTokens()) {
            String v;
            String tok = st.nextToken();
            int pos = tok.lastIndexOf(61);
            if (pos <= 0) continue;
            String k = tok.substring(0, pos).replace("\\n", "\n").replace("\\r", "\r");
            String string = v = pos >= tok.length() - 1 ? "" : tok.substring(pos + 1);
            if (v.equals("\" \"")) {
                v = " ";
            } else if (v.equals("\"\"")) {
                v = "";
            }
            ret = ret.replace(k, v);
        }
        return ret;
    }

    public static void main(String[] args) {
        System.out.println(StringUtils.normalizeUrl(args[0]));
    }
}

