/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.util;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ESParamList {
    private Hashtable params_ = null;

    public ESParamList() {
        this.params_ = new Hashtable(8);
    }

    public ESParamList(Hashtable h) {
        this.params_ = h == null ? new Hashtable(8) : h;
    }

    public void decode(String plist) {
        if (plist == null || plist.length() <= 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(plist, "&");
        while (st.hasMoreTokens()) {
            String ptok = st.nextToken();
            int pos = ptok.indexOf(61);
            if (pos <= 0 || ptok.length() < 3) continue;
            String k = ptok.substring(0, pos);
            String v = ptok.substring(pos + 1);
            this.params_.put(this.UrlDecode(k), this.UrlDecode(v));
        }
    }

    public String encode() {
        StringBuffer buf = new StringBuffer();
        Enumeration en = this.params_.keys();
        while (en.hasMoreElements()) {
            Object k = en.nextElement();
            String val = this.params_.get(k).toString();
            if (val == null || val.equals("")) {
                val = " ";
            }
            buf.append(this.UrlEncode(k.toString()) + "=" + this.UrlEncode(val));
            if (!en.hasMoreElements()) continue;
            buf.append("&");
        }
        return buf.toString();
    }

    public void textdecode(String plist, String sep) {
        if (sep == null || sep.length() > 1) {
            sep = "|";
        }
        if (plist == null || plist.length() <= 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(plist, sep);
        while (st.hasMoreTokens()) {
            String ptok = st.nextToken();
            int pos = ptok.indexOf(61);
            if (pos <= 0 || ptok.length() < 3) continue;
            String k = ptok.substring(0, pos);
            String v = ptok.substring(pos + 1);
            this.params_.put(k, v);
        }
    }

    public String textencode(String sep) {
        if (sep == null || sep.length() > 1) {
            sep = "|";
        }
        StringBuffer buf = new StringBuffer();
        Enumeration en = this.params_.keys();
        while (en.hasMoreElements()) {
            Object k = en.nextElement();
            String val = this.params_.get(k).toString();
            if (val == null || val.equals("")) {
                val = " ";
            }
            buf.append(k.toString() + "=" + val);
            if (!en.hasMoreElements()) continue;
            buf.append(sep);
        }
        return buf.toString();
    }

    public Object get(String k) {
        return this.params_.get(k);
    }

    public void put(String k, Object v) {
        if (k == null || v == null) {
            return;
        }
        this.params_.put(k, v);
    }

    public Enumeration keys() {
        return this.params_.keys();
    }

    public String toString() {
        return this.params_.toString();
    }

    public String uniqueEncode() {
        Vector<String> v = new Vector<String>(8);
        Enumeration<Object> en = this.params_.keys();
        while (en.hasMoreElements()) {
            String crt = en.nextElement().toString();
            boolean ins = false;
            for (int i = 0; i < v.size(); ++i) {
                if (crt.compareTo((String)v.elementAt(i)) > 0) continue;
                v.insertElementAt(crt, i);
                ins = true;
                break;
            }
            if (ins) continue;
            v.addElement(crt);
        }
        StringBuffer buf = new StringBuffer();
        en = v.elements();
        while (en.hasMoreElements()) {
            Object k = en.nextElement();
            buf.append(this.UrlEncode(k.toString()) + "=" + this.UrlEncode(this.params_.get(k).toString()));
            if (!en.hasMoreElements()) continue;
            buf.append("&");
        }
        return buf.toString();
    }

    public Hashtable toHashtable() {
        return this.params_;
    }

    private String UrlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (Exception e) {
            return s;
        }
    }

    private String UrlDecode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (Exception e) {
            return s;
        }
    }

    public static void main(String[] args) {
        ESParamList p = new ESParamList();
        p.put("Firstname", "Pierre Yves");
        p.put("Last Name", "Gibello");
        System.out.println(p.toString());
        String encoded = p.encode();
        System.out.println(encoded);
        p.decode(encoded);
        System.out.println(p.toString());
        encoded = p.uniqueEncode();
        System.out.println(encoded);
        p.decode(encoded);
        System.out.println(p.toString());
    }
}

