/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BufferedRandomAccessFile {
    RandomAccessFile raf_ = null;
    private final int BUF_SIZE = 128;
    byte[] buffer = null;
    int buf_end = 0;
    int buf_pos = 0;
    long real_pos = 0L;

    public BufferedRandomAccessFile(File f) throws IOException {
        this.raf_ = new RandomAccessFile(f, "r");
        this.buffer = new byte[128];
    }

    public final int read() throws IOException {
        if (this.buf_pos >= this.buf_end && this.fillBuffer() < 0) {
            return -1;
        }
        if (this.buf_end == 0) {
            return -1;
        }
        return this.buffer[this.buf_pos++] & 0xFF;
    }

    private int fillBuffer() throws IOException {
        int n = this.raf_.read(this.buffer, 0, 128);
        if (n >= 0) {
            this.real_pos += (long)n;
            this.buf_end = n;
            this.buf_pos = 0;
        }
        return n;
    }

    private void invalidate() throws IOException {
        this.buf_end = 0;
        this.buf_pos = 0;
        this.real_pos = this.raf_.getFilePointer();
    }

    public final String readLine() throws IOException {
        String str = null;
        if (this.buf_end - this.buf_pos <= 0 && this.fillBuffer() < 0) {
            return null;
        }
        int lineend = -1;
        for (int i = this.buf_pos; i < this.buf_end; ++i) {
            if (this.buffer[i] != 10) continue;
            lineend = i;
            break;
        }
        if (lineend < 0) {
            int c;
            StringBuffer input = new StringBuffer(256);
            int prev = -1;
            while ((c = this.read()) != -1 && c != 10) {
                input.append((char)c);
                prev = c;
            }
            if (c == -1 && input.length() == 0) {
                return null;
            }
            return prev == 13 ? input.substring(0, input.length() - 1) : input.toString();
        }
        str = lineend > 0 && this.buffer[lineend - 1] == 13 ? new String(this.buffer, this.buf_pos, lineend - this.buf_pos - 1) : new String(this.buffer, this.buf_pos, lineend - this.buf_pos);
        this.buf_pos = lineend + 1;
        return str;
    }

    public long getFilePointer() throws IOException {
        long l = this.real_pos;
        return l - (long)this.buf_end + (long)this.buf_pos;
    }

    public void seek(long pos) throws IOException {
        int n = (int)(this.real_pos - pos);
        if (n >= 0 && n <= this.buf_end) {
            this.buf_pos = this.buf_end - n;
        } else {
            this.raf_.seek(pos);
            this.invalidate();
        }
    }

    public void close() throws IOException {
        this.buffer = null;
        this.buf_pos = 0;
        this.buf_end = 0;
        this.real_pos = 0L;
        if (this.raf_ != null) {
            this.raf_.close();
        }
    }
}

