/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.openeas.api;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import org.experlog.base.ESCookie;
import org.experlog.base.ESStore;
import org.experlog.base.OpenClient;
import org.experlog.db.ESDbObject;
import org.experlog.openeas.api.AppConfiguration;
import org.experlog.openeas.api.Cookie;
import org.experlog.openeas.api.DbObject;
import org.experlog.util.Client;

public class Session {
    OpenClient session_;

    protected Session(Client s) {
        this.session_ = (OpenClient)s;
    }

    protected OpenClient getSession() {
        return this.session_;
    }

    public DbObject newDbObject(String table, ResultSet rs) throws SQLException {
        return new DbObject(new ESDbObject(this.session_, table, rs));
    }

    public AppConfiguration getAppConfiguration() {
        return new AppConfiguration(this.session_.getAppConfiguration());
    }

    public Cookie getCookie() {
        return new Cookie((ESCookie)this.session_.getCookie());
    }

    public String getClientId() {
        return this.session_.getClientId();
    }

    public static Session findClient(String id) {
        OpenClient c = ESStore.getInstance().findClient(id);
        if (c == null) {
            return null;
        }
        return new Session(c);
    }

    public static Session getClient(String id, HttpServletRequest req) throws Exception {
        OpenClient c = ESStore.getInstance().getClient(id, req);
        if (c == null) {
            return null;
        }
        return new Session(c);
    }

    public Connection getConnection(String datasourcename) throws Exception {
        return this.session_.getConnection(datasourcename);
    }

    public void closeConnection(Connection c, String dsn) throws SQLException {
        this.session_.closeConnection(c, dsn);
    }

    public void logRequest(String dsn, String request) {
        this.session_.logRequest(dsn, request);
    }

    public void updateDB(String sql) throws SQLException, Exception {
        this.updateDB(null, sql);
    }

    public void updateDB(String datasourcename, String sql) throws SQLException, Exception {
        this.session_.updateDB(datasourcename, sql);
    }

    public void debug(String msg) {
        System.err.println(msg);
    }

    public void trace(String msg) {
        System.err.println(msg);
    }

    public String sqlEncode(String s) {
        return this.sqlEncode(null, s);
    }

    public String sqlEncode(String datasourcename, String s) {
        return this.session_.sqlEncode(datasourcename, s);
    }

    public void resetTimer() {
        this.session_.resetTimer();
    }
}

